/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.syncable.impl;

import com.tydic.se.es.confige.restClient.EsConfig;
import com.tydic.se.es.data.SeSyncEsCommodityDataBo;
import com.tydic.se.es.enums.SeEsEnums;
import com.tydic.se.es.syncable.bo.SyncAbleReqBo;
import com.tydic.se.es.syncable.bo.SyncAbleRspBo;
import com.tydic.se.es.syncable.impl.AbstractSyncAble;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.es.util.SeEsRspUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="syncAbleDeleteImpl")
public class SyncAbleDeleteImpl
extends AbstractSyncAble {
    private static final Logger log = LoggerFactory.getLogger(SyncAbleDeleteImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    public Long getMethod() {
        return SeEsEnums.SyncMethod.DELETE.getMethod();
    }

    public SyncAbleRspBo dealSync(SyncAbleReqBo reqBo) {
        SyncAbleRspBo retBo = SeEsRspUtil.getSuccessRspBo(SyncAbleRspBo.class);
        List<SeSyncEsCommodityDataBo> commodityDataBos = super.qryCommodityInfos(reqBo);
        if (CollectionUtils.isEmpty(commodityDataBos)) {
            log.error("\u6570\u636e\u540c\u6b65\uff0c\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a\u6839\u636e\u5165\u53c2\u83b7\u53d6\u5230\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            retBo.setCode("1");
            retBo.setMessage("\u6570\u636e\u540c\u6b65\uff0c\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a\u6839\u636e\u5165\u53c2\u83b7\u53d6\u5230\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return retBo;
        }
        List commodityIds = commodityDataBos.stream().map(SeSyncEsCommodityDataBo::getCommodityId).collect(Collectors.toList());
        Long sceneId = reqBo.getSceneId();
        for (Long commodityId : commodityIds) {
            BoolQueryBuilder qryBuilder = QueryBuilders.boolQuery();
            if (null != sceneId) {
                qryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"scene_id", (String)String.valueOf(sceneId)));
            }
            qryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (String)String.valueOf(commodityId)));
            try {
                this.elasticsearchUtil.deleteByQuery(this.esConfig.getIndexAlias(), (QueryBuilder)qryBuilder);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\uff1a{}\uff0c\u5220\u9664\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
        return retBo;
    }
}

