/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.SeBusinessException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.GetSourceRequest;
import org.elasticsearch.client.core.GetSourceResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchUtil.class);
    private final Boolean isDebug = log.isDebugEnabled();
    private static final int BATCH_SIZE = 1000;
    @Qualifier(value="restHighLevelClient")
    @Autowired
    private RestHighLevelClient client;

    public Boolean createIndex(String indexName, String indexSource) {
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)indexSource)) {
            log.info("\u521b\u5efaES\u7d22\u5f15\u5165\u53c2:\u7d22\u5f15\u540d\u79f0[indexName]\u3001\u7d22\u5f15\u7ed3\u6784[indexSource]\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (this.isDebug.booleanValue()) {
            log.debug("\u521b\u5efaES\u7d22\u5f15\uff0c\u672c\u6b21\u7684\u7d22\u5f15\u4e3a\uff1a{}", (Object)indexName);
        }
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        JSONObject sourceJson = JSON.parseObject((String)indexSource);
        request.source(sourceJson.toJSONString(), XContentType.JSON);
        try {
            CreateIndexResponse response = this.client.indices().create(request, RequestOptions.DEFAULT);
            if (response.isAcknowledged()) {
                log.info("\u521b\u5efaES\u7d22\u5f15\u6210\u529f");
                return true;
            }
            log.info("\u521b\u5efaES\u7d22\u5f15\u5931\u8d25");
        }
        catch (IOException e) {
            log.error("\u521b\u5efaES\u7d22\u5f15\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public Boolean deleteIndices(String indexNames) {
        if (StringUtils.isEmpty((CharSequence)indexNames)) {
            log.info("\u5220\u9664ES\u7d22\u5f15\u5165\u53c2[indexNames]\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (this.isDebug.booleanValue()) {
            log.debug("\u5220\u9664ES\u7d22\u5f15\u5165\u53c2\u4e3a\uff1a{}", (Object)indexNames);
        }
        DeleteIndexRequest request = new DeleteIndexRequest(indexNames);
        try {
            AcknowledgedResponse response = this.client.indices().delete(request, RequestOptions.DEFAULT);
            if (response.isAcknowledged()) {
                log.info("\u7d22\u5f15'{}',\u5220\u9664\u6210\u529f", (Object)indexNames);
                return true;
            }
            log.info("\u5220\u9664ES\u7d22\u5f15\u5931\u8d25");
        }
        catch (IOException e) {
            log.error("\u5220\u9664ES\u7d22\u5f15\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public Boolean updateIndexSetting(String indexName, String setting) {
        if (this.isDebug.booleanValue()) {
            log.debug("\u66f4\u65b0\u7d22\u5f15setting\u5165\u53c2\uff1aindexName='{}'\uff0csetting='{}'", (Object)indexName, (Object)setting);
        }
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)setting)) {
            log.info("\u66f4\u65b0\u7d22\u5f15setting\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff0c[indexName]\u548c[setting]\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{indexName});
        request.settings(setting, XContentType.JSON);
        try {
            AcknowledgedResponse response = this.client.indices().putSettings(request, RequestOptions.DEFAULT);
            if (response.isAcknowledged()) {
                log.info("\u66f4\u65b0\u7d22\u5f15setting\u6210\u529f");
                return true;
            }
            log.info("\u66f4\u65b0\u7d22\u5f15setting\u5931\u8d25");
        }
        catch (IOException e) {
            log.error("\u66f4\u65b0\u7d22\u5f15setting\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public Boolean updateMapping(String indexName, String mapping) {
        if (this.isDebug.booleanValue()) {
            log.debug("\u66f4\u65b0\u7d22\u5f15mapping\u5165\u53c2\uff1aindexName='{}'\uff0cmapping='{}'", (Object)indexName, (Object)mapping);
        }
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)mapping)) {
            log.info("\u66f4\u65b0\u7d22\u5f15mapping\u65f6\uff0c\u7d22\u5f15\u540d\u79f0[indexName]\u548cMAPPING[mapping]\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!this.isExistIndex(indexName).booleanValue()) {
            log.info("\u7d22\u5f15'{}'\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object)indexName);
        }
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName});
        request.source(mapping, XContentType.JSON);
        try {
            AcknowledgedResponse response = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
            if (response.isAcknowledged()) {
                log.info("\u7d22\u5f15mapping\u66f4\u65b0\u6210\u529f");
                return true;
            }
            log.info("\u66f4\u65b0\u7d22\u5f15mapping\u5931\u8d25");
        }
        catch (IOException e) {
            log.error("\u66f4\u65b0\u7d22\u5f15mapping\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public Boolean reIndex(String sourceIndex, String destIndex) {
        if (log.isDebugEnabled()) {
            log.info("\u7d22\u5f15\u91cd\u5efa\uff0c\u5165\u53c2\uff1asourceIndex='{}'\uff0cdestIndex='{}'", (Object)sourceIndex, (Object)destIndex);
        }
        if (StringUtils.isEmpty((CharSequence)sourceIndex) || StringUtils.isEmpty((CharSequence)destIndex)) {
            log.error("\u7d22\u5f15\u91cd\u5efa\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u6e90\u7d22\u5f15[sourceIndex]\u3001\u76ee\u6807\u7d22\u5f15[destIndex]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!this.isExistIndex(sourceIndex, destIndex).booleanValue()) {
            log.info("\u68c0\u67e5\u539f\u7d22\u5f15\u3001\u76ee\u6807\u7d22\u5f15\u662f\u5426\u90fd\u5b58\u5728");
            return false;
        }
        ReindexRequest request = new ReindexRequest();
        request.setSourceIndices(new String[]{sourceIndex});
        request.setDestIndex(destIndex);
        request.setDestOpType("create");
        request.setConflicts("proceed");
        request.setSourceBatchSize(1000);
        request.setRefresh(true);
        this.client.reindexAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                log.info("======\u7d22\u5f15\u91cd\u5efa\u5b8c\u6210\uff0c\u5171\u5904\u7406\u4e86\uff1a{}", (Object)bulkByScrollResponse.getTotal());
            }

            public void onFailure(Exception e) {
                log.info("======\u7d22\u5f15\u91cd\u5efa\u5f02\u5e38\uff1a" + e);
            }
        });
        return true;
    }

    public Boolean isExistIndex(String ... indexName) {
        if (this.isDebug.booleanValue()) {
            log.debug("\u68c0\u9a8c\u7d22\u5f15\u662f\u5426\u5b58\u5728\uff0c\u5165\u53c2\uff1a{}", (Object[])indexName);
        }
        if (0 == indexName.length) {
            log.info("\u68c0\u9a8c\u7d22\u5f15\u662f\u5426\u5b58\u5728\uff0c\u5165\u53c2\uff1a[indexName]\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        GetIndexRequest request = new GetIndexRequest(indexName);
        try {
            Boolean isExist = this.client.indices().exists(request, RequestOptions.DEFAULT);
            if (isExist.booleanValue()) {
                log.info("\u7d22\u5f15\u5b58\u5728");
                return true;
            }
        }
        catch (IOException e) {
            log.error("\u68c0\u9a8cES\u7d22\u5f15\u662f\u5426\u5b58\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public String addDocument(String indexName, String docId, JSONObject source) {
        if (this.isDebug.booleanValue()) {
            log.debug("\u65b0\u589e\u6587\u7ae0\u5165\u53c2\uff1aindexName='{}'\uff0cid='{}'\uff0csource='{}'", new Object[]{indexName, docId, source});
        }
        if (StringUtils.isEmpty((CharSequence)indexName) || source.isEmpty()) {
            log.info("\u65b0\u589e\u6587\u7ae0\uff0c[indexName]\uff0c[source]\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        IndexRequest request = new IndexRequest(indexName);
        if (!StringUtils.isEmpty((CharSequence)docId)) {
            request.id(docId);
        }
        request.source(source.toJSONString(), XContentType.JSON);
        try {
            IndexResponse response = this.client.index(request, RequestOptions.DEFAULT);
            if (!StringUtils.isEmpty((CharSequence)response.getId())) {
                log.info("\u65b0\u589e\u6587\u7ae0\u6210\u529f");
                return response.getId();
            }
            if (response.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                log.info("\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a{}", (Object)failures[0].reason());
            }
        }
        catch (IOException e) {
            log.error("\u65b0\u589e\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
        }
        return null;
    }

    public Map<String, String> addDocumentBatch(String indexName, List<Map<String, JSONObject>> sources) {
        if (StringUtils.isEmpty((CharSequence)indexName) || sources.isEmpty()) {
            log.info("\u6279\u91cf\u65b0\u589e\u6587\u7ae0\uff0c[indexName]\uff0c[source]\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, String> failMap = new HashMap<String, String>(16);
        int pages = (int)Math.ceil((double)sources.size() / 1000.0);
        for (int i = 0; i < pages; ++i) {
            List<Map<String, JSONObject>> subList = this.getSubList(sources, 1000, i);
            this.dealDocumentBatch(indexName, subList, failMap);
            log.info("\u6279\u91cf\u65b0\u589e\u6587\u7ae0\uff0c\u7b2c\uff1a{} \u6b21\uff0c\u672c\u6b21\u6267\u884c\u63d2\u5165\uff1a{} \u6761", (Object)i, (Object)subList.size());
        }
        log.info("\u6279\u91cf\u65b0\u589e\u6587\u7ae0\u5b8c\u6bd5\uff0c\u5171\u8bb0\u6267\u884c\uff1a{}\u6761", (Object)sources.size());
        return failMap;
    }

    private void dealDocumentBatch(String indexName, List<Map<String, JSONObject>> source, Map<String, String> failMap) {
        BulkRequest request = new BulkRequest();
        source.forEach(map -> {
            for (Map.Entry entry : map.entrySet()) {
                request.add(new IndexRequest(indexName).id((String)entry.getKey()).source(((JSONObject)entry.getValue()).toJSONString(), XContentType.JSON));
            }
        });
        try {
            BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
            if (response.hasFailures()) {
                for (BulkItemResponse itemResponse : response) {
                    if (!itemResponse.isFailed()) continue;
                    log.info("\u6587\u7ae0ID='{}'\uff0c\u65b0\u589e\u5931\u8d25\u4e86\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a{}", (Object)itemResponse.getId(), (Object)itemResponse.getFailureMessage());
                    failMap.put(itemResponse.getId(), itemResponse.getFailureMessage());
                }
            }
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u63d2\u5165\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
        }
    }

    private List<Map<String, JSONObject>> getSubList(List<Map<String, JSONObject>> dataList, int pageSize, int currentPage) {
        ArrayList<Map<String, JSONObject>> currentPageList = new ArrayList<Map<String, JSONObject>>();
        if (!dataList.isEmpty()) {
            int currIdx = currentPage > 0 ? currentPage * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size(); ++i) {
                Map<String, JSONObject> map = dataList.get(currIdx + i);
                currentPageList.add(map);
            }
        }
        return currentPageList;
    }

    public Boolean deleteDoc(String indexName, String docId) {
        if (this.isDebug.booleanValue()) {
            log.debug("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName={}\uff0cdocId={}", (Object)indexName, (Object)docId);
        }
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)docId)) {
            log.info("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2[indexName]\u548c[docId]\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        DeleteRequest request = new DeleteRequest(indexName, docId);
        try {
            DeleteResponse response = this.client.delete(request, RequestOptions.DEFAULT);
            if (response.getShardInfo().getFailed() <= 0) {
                log.info("\u5220\u9664\u6587\u7ae0\u6210\u529f");
                return true;
            }
            ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
            log.info("\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a{}", (Object)failures[0].reason());
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public void deleteAllDoc(String indexName) {
        this.deleteByQuery(indexName, (QueryBuilder)QueryBuilders.matchAllQuery());
    }

    public void deleteByQuery(String indexName, QueryBuilder queryBuilder) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexName});
        request.setQuery(queryBuilder);
        request.setRefresh(true);
        try {
            BulkByScrollResponse bulkByScrollResponse = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean updateDoc(String indexName, String docId, JSONObject source) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName = '{}', docId = '{}'", (Object)indexName, (Object)docId);
        }
        UpdateRequest request = new UpdateRequest(indexName, docId);
        request.doc(source.toJSONString(), XContentType.JSON);
        try {
            UpdateResponse response = this.client.update(request, RequestOptions.DEFAULT);
            if (DocWriteResponse.Result.UPDATED.equals((Object)response.getResult())) {
                log.info("\u6587\u7ae0\u66f4\u65b0\u6210\u529f");
                return true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public JSONObject getDocById(String indexName, String docId) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636e\u6587\u7ae0ID\u83b7\u53d6\u6587\u7ae0\uff1a\u5165\u53c2\uff1aindexName='{}'\uff0cdocId='{}'", (Object)indexName, (Object)docId);
        }
        GetSourceRequest request = new GetSourceRequest(indexName, docId);
        Map source = new HashMap(16);
        try {
            GetSourceResponse response = this.client.getSource(request, RequestOptions.DEFAULT);
            source = response.getSource();
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u83b7\u53d6\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
        }
        if (source.isEmpty()) {
            log.info("\u6839\u636e\u5165\u53c2\uff1a\u5165\u53c2\uff1aindexName='{}'\uff0cdocId='{}'\uff0c\u672a\u67e5\u8be2\u5230\u6587\u7ae0", (Object)indexName, (Object)docId);
        }
        return new JSONObject(source);
    }

    public Object addAlias(String indexName, String alias) {
        if (log.isDebugEnabled()) {
            log.debug("\u4e3a\u7d22\u5f15\u6dfb\u52a0\u522b\u540d\uff0c\u5165\u53c2\uff1aindexName='{}'\uff0calias='{}'", (Object)indexName, (Object)alias);
        }
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)alias)) {
            log.error("\u4e3a\u7d22\u5f15\u6dfb\u52a0\u522b\u540d\uff0c\u5165\u53c2\uff1a\u7d22\u5f15\u540d\u79f0[indexName]\uff0c\u522b\u540d[alias] \u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(alias);
        aliasesRequest.addAliasAction(aliasAction);
        try {
            AcknowledgedResponse response = this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
            if (response.isAcknowledged()) {
                log.info("\u4e3a\u7d22\u5f15\u6dfb\u52a0\u522b\u540d\u6210\u529f");
                return true;
            }
            log.info("\u4e3a\u7d22\u5f15\u6dfb\u52a0\u522b\u540d\u5931\u8d25");
        }
        catch (IOException e) {
            log.error("\u4e3a\u7d22\u5f15\u6dfb\u52a0\u522b\u540d\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public Boolean moveAliasIndex(String alias, String oldIndexName, String newIndexName) {
        if (log.isDebugEnabled()) {
            log.debug("\u522b\u540d\u6307\u5b9a\u7d22\u5f15\u8fc1\u79fb\uff0c\u5165\u53c2\uff1aalias='{}'\uff0coldIndexName='{}'\uff0cnewIndexName='{}'", new Object[]{alias, oldIndexName, newIndexName});
        }
        if (StringUtils.isEmpty((CharSequence)alias) || StringUtils.isEmpty((CharSequence)oldIndexName) || StringUtils.isEmpty((CharSequence)newIndexName)) {
            log.error("\u522b\u540d\u6307\u5b9a\u7d22\u5f15\u8fc1\u79fb\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u522b\u540d[alias]\u3001\u539f\u7d22\u5f15\u540d\u79f0[oldIndexName]\u3001\u65b0\u7d22\u5f15\u540d\u79f0[newIndexName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions addNewIndexAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(newIndexName).alias(alias);
        IndicesAliasesRequest.AliasActions removeOldIndexAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX).index(oldIndexName);
        aliasesRequest.addAliasAction(addNewIndexAction);
        aliasesRequest.addAliasAction(removeOldIndexAction);
        try {
            AcknowledgedResponse response = this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
            if (response.isAcknowledged()) {
                log.info("\u522b\u540d\u6307\u5b9a\u7d22\u5f15\u8fc1\u79fb\u6210\u529f");
                return true;
            }
            log.info("\u522b\u540d\u6307\u5b9a\u7d22\u5f15\u8fc1\u79fb\u5931\u8d25");
        }
        catch (IOException e) {
            log.error("\u522b\u540d\u6307\u5b9a\u7d22\u5f15\u8fc1\u79fb\u5931\u8d25\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public Boolean existsAlias(String alias) {
        if (log.isDebugEnabled()) {
            log.debug("\u6821\u9a8c\u7d22\u5f15\u662f\u5426\u5b58\u5728\uff0c\u5165\u53c2\uff1aalias='{}'", (Object)alias);
        }
        if (StringUtils.isEmpty((CharSequence)alias)) {
            log.error("\u6821\u9a8c\u7d22\u5f15\u662f\u5426\u5b58\u5728\uff0c\u5165\u53c2\uff1a\u522b\u540d[alias]\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        GetAliasesRequest request = new GetAliasesRequest();
        request.aliases(new String[]{alias});
        try {
            boolean exists = this.client.indices().existsAlias(request, RequestOptions.DEFAULT);
            if (exists) {
                return true;
            }
        }
        catch (IOException e) {
            log.error("\u6821\u9a8c\u7d22\u5f15\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff1a" + e);
        }
        return false;
    }

    public void reIndexAndMoveAliasIndexAsync(final String sourceIndex, final String destIndex, final String alias) {
        if (log.isDebugEnabled()) {
            log.info("\u7d22\u5f15\u91cd\u5efa\uff0c\u5165\u53c2\uff1asourceIndex='{}'\uff0cdestIndex='{}'", (Object)sourceIndex, (Object)destIndex);
        }
        if (StringUtils.isEmpty((CharSequence)sourceIndex) || StringUtils.isEmpty((CharSequence)destIndex)) {
            log.error("\u7d22\u5f15\u91cd\u5efa\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u6e90\u7d22\u5f15[sourceIndex]\u3001\u76ee\u6807\u7d22\u5f15[destIndex]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (!this.isExistIndex(sourceIndex, destIndex).booleanValue()) {
            log.info("\u68c0\u67e5\u539f\u7d22\u5f15\u3001\u76ee\u6807\u7d22\u5f15\u662f\u5426\u90fd\u5b58\u5728");
            return;
        }
        ReindexRequest request = new ReindexRequest();
        request.setSourceIndices(new String[]{sourceIndex});
        request.setDestIndex(destIndex);
        request.setDestOpType("create");
        request.setConflicts("proceed");
        request.setSourceBatchSize(1000);
        request.setSlices(10);
        request.setRefresh(true);
        this.client.reindexAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                log.info("======\u7d22\u5f15\u91cd\u5efa\u5b8c\u6210\uff0c\u5171\u5904\u7406\u4e86\uff1a{}", (Object)bulkByScrollResponse.getTotal());
                if (ElasticsearchUtil.this.moveAliasIndex(alias, sourceIndex, destIndex).booleanValue()) {
                    log.info("======\u522b\u540d\u6307\u5b9a\u7684\u7d22\u5f15\u8fc1\u79fb\u6210\u529f");
                }
            }

            public void onFailure(Exception e) {
                log.info("======\u7d22\u5f15\u91cd\u5efa\u5f02\u5e38\uff1a" + e);
            }
        });
    }

    public String postEsSearch(String indexName, String esQueryBody) {
        Long startTime = System.currentTimeMillis();
        String esResult = "";
        String method = "POST";
        String endpoint = new StringBuffer().append("/").append(indexName).append("/_search").toString();
        Request request = new Request(method, endpoint);
        request.setJsonEntity(esQueryBody);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            esResult = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SeBusinessException("\u8c03\u7528es\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        Long endTime = System.currentTimeMillis();
        log.info("\u672c\u6b21es\u67e5\u8be2\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms\uff0cesQueryBody:" + esQueryBody);
        return esResult;
    }

    public String postEsAnalyze(String indexName, String esQueryBody) {
        Long startTime = System.currentTimeMillis();
        String esResult = "";
        String method = "POST";
        String endpoint = new StringBuffer().append("/").append(indexName).append("/_analyze").toString();
        Request request = new Request(method, endpoint);
        request.setJsonEntity(esQueryBody);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            esResult = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SeBusinessException("\u8c03\u7528es\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        Long endTime = System.currentTimeMillis();
        log.info("\u672c\u6b21es\u67e5\u8be2\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms\uff0cesQueryBody:" + esQueryBody);
        return esResult;
    }
}

