/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.beanpost;

import com.tydic.se.es.exception.BusinessException;
import com.tydic.se.es.syncable.SyncAble;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SyncAbleManager {
    private static final Logger log = LoggerFactory.getLogger(SyncAbleManager.class);
    private final Map<Long, SyncAble> syncAbleMap = new ConcurrentHashMap<Long, SyncAble>();

    public SyncAble getSyncAbleByMethod(Long method) {
        SyncAble syncAble = this.syncAbleMap.get(method);
        if (null == syncAble) {
            log.error("\u83b7\u53d6SyncAble\u5b9e\u73b0\u7c7b\u5931\u8d25\uff0c\u540c\u6b65\u65b9\u5f0f[{}]\uff0c\u6ca1\u6709\u5b9e\u73b0\u7c7b", (Object)method);
            throw new BusinessException("1001", "\u83b7\u53d6SyncAble\u5b9e\u73b0\u7c7b\u5931\u8d25\uff0c\u540c\u6b65\u65b9\u5f0f[" + method + "]\uff0c\u6ca1\u6709\u5b9e\u73b0\u7c7b");
        }
        return syncAble;
    }

    public void registerSyncAble(SyncAble syncAble) {
        Assert.notNull((Object)syncAble, (String)"syncAble can not be null");
        Assert.notNull((Object)syncAble.getMethod(), (String)"syncAble.getMethod(), can not be null");
        Long method = syncAble.getMethod();
        SyncAble registeredAble = this.syncAbleMap.get(method);
        if (null != registeredAble) {
            log.error("\u540c\u6b65\u65b9\u5f0f\uff1a[{}]\u6ce8\u518c\u91cd\u590d");
            throw new BusinessException("1001", "\u540c\u6b65\u65b9\u5f0f\uff1a[" + method + "]\u6ce8\u518c\u91cd\u590d");
        }
        log.info("SyncAbleManager.registerSyncAble()\u6ce8\u518c\u4e86\u540c\u6b65\u65b9\u5f0f\uff1a" + method);
        this.syncAbleMap.put(method, syncAble);
    }
}

