/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.syncable.impl;

import com.tydic.se.es.data.SeEsDataBo;
import com.tydic.se.es.data.SeSyncEsCommodityDataBo;
import com.tydic.se.es.enums.SeEsEnums;
import com.tydic.se.es.syncable.bo.SyncAbleReqBo;
import com.tydic.se.es.syncable.bo.SyncAbleRspBo;
import com.tydic.se.es.syncable.impl.AbstractSyncAble;
import com.tydic.se.es.util.SeEsRspUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="syncAbleAddImpl")
public class SyncAbleAddImpl
extends AbstractSyncAble {
    private static final Logger log = LoggerFactory.getLogger(SyncAbleAddImpl.class);

    public Long getMethod() {
        return SeEsEnums.SyncMethod.ADD.getMethod();
    }

    public SyncAbleRspBo dealSync(SyncAbleReqBo reqBo) {
        SyncAbleRspBo retBo = SeEsRspUtil.getSuccessRspBo(SyncAbleRspBo.class);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((CharSequence)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setCode("1");
            retBo.setMessage("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        List<SeSyncEsCommodityDataBo> commodityDataBos = super.qryCommodityInfos(reqBo);
        if (CollectionUtils.isEmpty(commodityDataBos)) {
            log.error("\u6570\u636e\u540c\u6b65\uff0c\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a\u6839\u636e\u5165\u53c2\u83b7\u53d6\u5230\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            retBo.setCode("1");
            retBo.setMessage("\u6570\u636e\u540c\u6b65\uff0c\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a\u6839\u636e\u5165\u53c2\u83b7\u53d6\u5230\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return retBo;
        }
        List<Long> commodityIds = commodityDataBos.stream().map(SeSyncEsCommodityDataBo::getCommodityId).collect(Collectors.toList());
        List<SeEsDataBo> esDataBos = super.assembleEsSkuInfo(reqBo, commodityIds);
        if (CollectionUtils.isEmpty(esDataBos)) {
            log.error("\u6570\u636e\u540c\u6b65\uff0c\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a\u6839\u636e\u5546\u54c1ID\u5217\u8868\u83b7\u53d6\u5355\u54c1\u4fe1\u606f\u5931\u8d25");
            retBo.setCode("1");
            retBo.setMessage("\u6570\u636e\u540c\u6b65\uff0c\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a\u6839\u636e\u5546\u54c1ID\u5217\u8868\u83b7\u53d6\u5355\u54c1\u4fe1\u606f\u5931\u8d25");
            return retBo;
        }
        super.assembleCommodityAndCategory(reqBo, commodityIds, esDataBos, commodityDataBos);
        super.assembleSkuPool(reqBo, commodityIds, esDataBos);
        super.assembleChannel(esDataBos);
        super.assembleLabel(esDataBos);
        super.assembleApproval(esDataBos);
        super.syncToEs(esDataBos, reqBo.getIndexName());
        super.syncAttrToEs(commodityIds);
        return retBo;
    }

    private String validateArgs(SyncAbleReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getSyncType()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'syncType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

