/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.util;

import com.ohaotian.plugin.file.FileClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SeFileUtil {
    private static final int EOF = -1;
    @Resource
    FileClient fileClient;
    private static FileClient fileClients;
    private static String basePrefix;
    private static String bucketName;
    private static String endPoint;
    private static final String HTTP = "http://";
    private static final String BACKSLASH = "/";
    private static final String POINT = ".";

    @PostConstruct
    public void init() {
        fileClients = this.fileClient;
    }

    @Value(value="${participle.file.folder:se/participle}")
    public void setBasePrefix(String basePrefix) {
        SeFileUtil.basePrefix = basePrefix;
    }

    @Value(value="${oss.bucketName}")
    public void setBucketName(String bucketName) {
        SeFileUtil.bucketName = bucketName;
    }

    @Value(value="${oss.endpoint}")
    public void setEndPoint(String endPoint) {
        SeFileUtil.endPoint = endPoint;
    }

    public static String uploadFile(ByteArrayOutputStream outputStream, String fileName) {
        return SeFileUtil.uploadFile(SeFileUtil.outConvertToIn(outputStream), fileName);
    }

    public static String uploadFile(InputStream inputStream, String fileName) {
        String filePath;
        System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1a\u51c6\u5907\u4e0a\u4f20\u6587\u4ef6---------------------");
        System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1a\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb\uff0c\u6587\u4ef6\u540d\u79f0\uff1a" + fileName);
        try {
            filePath = fileClients.uploadFileByInputStream(basePrefix, fileName, inputStream);
        }
        catch (Exception e) {
            System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b:\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c" + e);
            return null;
        }
        System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1a\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\uff1a" + filePath);
        return filePath;
    }

    public static List<String> getFileAsList(String fileName) {
        InputStream inputStream = SeFileUtil.getFileAsInputStream(fileName);
        if (null == inputStream) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        List<String> lineStr = bufferedReader.lines().collect(Collectors.toList());
        return lineStr;
    }

    public static ByteArrayOutputStream getFileAsOutputStream(String fileName) {
        InputStream inputStream = SeFileUtil.getFileAsInputStream(fileName);
        if (null == inputStream) {
            return null;
        }
        return SeFileUtil.inConvertOut(inputStream);
    }

    public static InputStream getFileAsInputStream(String fileName) {
        InputStream inputStream;
        System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1a\u6587\u4ef6\u4e0b\u8f7d\u5f00\u59cb\uff0c\u6587\u4ef6\u540d\u79f0\uff1a" + fileName);
        String filePath = basePrefix + BACKSLASH + fileName;
        System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1a\u672c\u6b21\u4e0b\u8f7d\u8def\u5f84\u4e3a\uff1a" + filePath);
        try {
            inputStream = fileClients.downLoadToInputStream(filePath);
        }
        catch (Exception e) {
            System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b:\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff0c" + e);
            return null;
        }
        return inputStream;
    }

    public static ByteArrayOutputStream inConvertOut(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int readSize;
            while ((readSize = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, readSize);
                outputStream.flush();
            }
        }
        catch (IOException e) {
            System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1ainConvertOut \u5f02\u5e38\uff1a" + e.getMessage());
        }
        return outputStream;
    }

    public static InputStream outConvertToIn(ByteArrayOutputStream outputStream) {
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static String getAbsolutePath(String fileName) {
        System.out.println("ES\u6a21\u5757\u6587\u4ef6\u5de5\u5177\u7c7b\uff1a\u5730\u5740\u62fc\u63a5");
        System.out.println("\u4f20\u5165\u7684\u5730\u5740\u4e3a\uff1a" + fileName);
        return HTTP + bucketName + POINT + endPoint + BACKSLASH + basePrefix + BACKSLASH + fileName;
    }
}

