/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.ability.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.se.es.ability.SeParticipleQueryAbilityService;
import com.tydic.se.es.ability.bo.SeParticipleQueryServiceListRspBo;
import com.tydic.se.es.ability.bo.SeParticipleQueryServiceReqBo;
import com.tydic.se.es.ability.bo.SeParticipleQueryServiceRspBo;
import com.tydic.se.es.util.SeFileUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="seQueryParticipleAbilityService")
public class SeParticipleQueryAbilityServiceImpl
implements SeParticipleQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SeParticipleQueryAbilityServiceImpl.class);
    @Value(value="${participle.file.name:participle.txt}")
    private String fileName;

    public SeParticipleQueryServiceListRspBo queryParticipleList(SeParticipleQueryServiceReqBo reqBo) {
        SeParticipleQueryServiceListRspBo rspBo = new SeParticipleQueryServiceListRspBo();
        List<String> queryAsList = this.getParticipleFileList(this.fileName, reqBo.getParticiple());
        rspBo.setParticipleWords(queryAsList);
        rspBo.setMessage("\u6210\u529f");
        rspBo.setCode("0");
        return rspBo;
    }

    public List<String> getParticipleFileList(String fileName, String queryParticiple) {
        List<String> fileAsList = SeFileUtil.getFileAsList(fileName);
        if (CollectionUtils.isEmpty(fileAsList)) {
            log.info("\u6839\u636e\u6587\u4ef6\u540d\uff1a{}\uff0c\u672a\u83b7\u53d6\u5230\u6587\u4ef6", (Object)fileName);
            fileAsList = new ArrayList<String>();
        }
        ArrayList<String> queryAsList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)queryParticiple) && !CollectionUtils.isEmpty(fileAsList)) {
            for (String str : fileAsList) {
                if (!str.equals(queryParticiple) && !str.contains(queryParticiple)) continue;
                queryAsList.add(str);
            }
        } else {
            queryAsList.addAll(fileAsList);
        }
        return queryAsList;
    }

    public RspPage<SeParticipleQueryServiceRspBo> queryParticiplePage(SeParticipleQueryServiceReqBo reqBo) {
        if (reqBo.getPageNo() < 1) {
            reqBo.setPageNo(1);
        }
        if (reqBo.getPageSize() < 1) {
            reqBo.setPageSize(10);
        }
        List<String> fileAsList = this.getParticipleFileList(this.fileName, reqBo.getParticiple());
        RspPage rspPage = new RspPage();
        rspPage.setRecordsTotal(fileAsList.size());
        int total = fileAsList.size() / reqBo.getPageSize();
        if (fileAsList.size() % reqBo.getPageSize() != 0) {
            ++total;
        }
        rspPage.setTotal(total);
        rspPage.setPageNo(reqBo.getPageNo());
        int pageNo = reqBo.getPageNo();
        int pageSize = reqBo.getPageSize();
        int index = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        ArrayList<SeParticipleQueryServiceRspBo> seAddPurchaseInLogBOList = new ArrayList<SeParticipleQueryServiceRspBo>();
        for (int i = 0; i < pageSize && i < fileAsList.size() - index; ++i) {
            SeParticipleQueryServiceRspBo seQueryParticipleServiceRspBo = new SeParticipleQueryServiceRspBo();
            seQueryParticipleServiceRspBo.setParticipleWord(fileAsList.get(index + i));
            seAddPurchaseInLogBOList.add(seQueryParticipleServiceRspBo);
        }
        rspPage.setRows(seAddPurchaseInLogBOList);
        return rspPage;
    }
}

