/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.async;

import com.tydic.se.base.dao.UccCommodityMapper;
import com.tydic.se.es.busi.po.SeDataAsyncDataReqParam;
import com.tydic.se.es.constants.SeEsConstant;
import com.tydic.se.es.syncable.SyncAble;
import com.tydic.se.es.syncable.bo.SyncAbleReqBo;
import com.tydic.se.es.syncable.bo.SyncAbleRspBo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SeDataAsyncService
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SeDataAsyncService.class);
    private UccCommodityMapper uccCommodityMapper;
    private SyncAble syncAble;
    private SeDataAsyncDataReqParam asyncReqParam;

    public void setUccCommodityMapper(UccCommodityMapper uccCommodityMapper) {
        this.uccCommodityMapper = uccCommodityMapper;
    }

    public void setSyncAble(SyncAble syncAble) {
        this.syncAble = syncAble;
    }

    public void setAsyncReqParam(SeDataAsyncDataReqParam asyncReqParam) {
        this.asyncReqParam = asyncReqParam;
    }

    @Override
    public void run() {
        int total = this.asyncReqParam.getTotal();
        if (0 == total) {
            log.info("\u4f9b\u5e94\u5546[{}]\uff0c\u65e0\u540c\u6b65\u6570\u636e", (Object)this.asyncReqParam.getSupplierId());
            return;
        }
        int cycle = total % this.asyncReqParam.getSize() == 0 ? total / this.asyncReqParam.getSize() : total / this.asyncReqParam.getSize() + 1;
        SyncAbleReqBo ableReqBo = new SyncAbleReqBo();
        ableReqBo.setIndexName(this.asyncReqParam.getIndexName());
        for (int i = 0; i < cycle; ++i) {
            int star = this.asyncReqParam.getStar() + i * this.asyncReqParam.getSize();
            int size = this.asyncReqParam.getSize();
            if (total < this.asyncReqParam.getSize()) {
                size = total;
            }
            log.info("\u4f9b\u5e94\u5546" + this.asyncReqParam.getSupplierId() + "\uff0c \u7b2c" + i + "\u7247\u5206\u9875\u6267\u884c\u7684\u8303\u56f4\u4e3a\uff1a" + star + "-->" + (star + size));
            List commodityIds = null;
            try {
                commodityIds = this.uccCommodityMapper.queryCommodityListsLimit(this.asyncReqParam.getSupplierId(), star, size);
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u4f9b\u5e94\u5546ID\u83b7\u53d6\u5546\u54c1\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (CollectionUtils.isEmpty((Collection)commodityIds)) continue;
            ableReqBo.setCommodityIds(commodityIds);
            ableReqBo.setSyncType(SeEsConstant.SYNC_TYPE_BY_COMMODITY_ID);
            ableReqBo.setSupplierId(this.asyncReqParam.getSupplierId());
            SyncAbleRspBo ableRetBo = this.syncAble.dealSync(ableReqBo);
            if ("0".equals(ableRetBo.getCode())) continue;
            log.error("SeDataAsyncService : \u540c\u6b65\u5546\u54c1\u5f02\u5e38\uff1a" + ableRetBo.getMessage());
        }
    }
}

