/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.confige.properties;

import cn.hutool.core.util.ReflectUtil;
import com.tydic.se.es.constants.PropertyKeys;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class EsToolPropertiesManager {
    private static final Logger log = LoggerFactory.getLogger(EsToolPropertiesManager.class);
    @Autowired
    private Environment environment;
    private Properties properties = new Properties();

    public Properties getProperties() {
        this.initVo();
        return this.properties;
    }

    @PostConstruct
    public void initVo() {
        if (this.environment instanceof AbstractEnvironment) {
            Set<String> keySet = this.getPropertyKeys();
            for (String key : keySet) {
                if (StringUtils.isEmpty((CharSequence)this.environment.getProperty(key))) continue;
                this.properties.setProperty(key, this.environment.getProperty(key));
            }
            log.info("EsToolProperties\u5c5e\u6027\u586b\u5145\u5b8c\u6210\uff0c\u4e00\u5171\u586b\u5145\u4e86\uff1a{} \u4e2a", (Object)this.properties.size());
        } else {
            log.info("EsToolProperties\u5c5e\u6027\u586b\u5145\u5931\u8d25");
            System.exit(0);
        }
    }

    private Set<String> getPropertyKeys() {
        HashSet<String> keySet = new HashSet<String>(16);
        Map map = ReflectUtil.getFieldMap(PropertyKeys.class);
        for (Map.Entry entry : map.entrySet()) {
            Field field = (Field)entry.getValue();
            try {
                keySet.add((String)field.get(entry.getKey()));
            }
            catch (IllegalAccessException e) {
                log.info("\u4ece\u914d\u7f6e\u6587\u4ef6\u5e38\u91cf\u4e2d\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6key\u5f02\u5e38\uff1a" + e);
            }
        }
        return keySet;
    }
}

