/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.confige.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class EsToolThreadPollManager {
    private static final Logger log = LoggerFactory.getLogger(EsToolThreadPollManager.class);
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final int KEEP_ALIVE_TIME = 10;
    private static final int QUEUE_CAPACITY = 200;
    private static final String THREAD_NAME_PREFIX = "ES-TOOL-ASYNC-";
    @Value(value="${search.executor.corePoolSize:5}")
    private int corePoolSize;
    @Value(value="${search.executor.maximumPoolSize:100}")
    private int maximumPoolSize;
    @Value(value="${search.executor.keepAliveTime:5}")
    private long keepAliveTime;
    @Value(value="${search.executor.queueCapacity:1000}")
    private int queueCapacity;
    @Value(value="${search.sort.executor.corePoolSize:5}")
    private int sortCorePoolSize;
    @Value(value="${search.sort.executor.maximumPoolSize:100}")
    private int sortMaximumPoolSize;
    @Value(value="${search.sort.executor.keepAliveTime:5}")
    private long sortKeepAliveTime;
    @Value(value="${search.sort.executor.queueCapacity:1000}")
    private int sortQueueCapacity;
    @Value(value="${search.esb.executor.corePoolSize:10}")
    private int esbCorePoolSize;
    @Value(value="${search.esb.executor.maximumPoolSize:100}")
    private int esbMaximumPoolSize;
    @Value(value="${search.esb.executor.keepAliveTime:5}")
    private long esbKeepAliveTime;
    @Value(value="${search.esb.executor.queueCapacity:1000}")
    private int esbQueueCapacity;

    @Bean(value={"EsToolAsyncExecutor"})
    public Executor payAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(PROCESSORS * 2);
        executor.setMaxPoolSize(PROCESSORS * 4);
        executor.setQueueCapacity(200);
        executor.setKeepAliveSeconds(10);
        executor.setThreadNamePrefix(THREAD_NAME_PREFIX);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(120);
        executor.initialize();
        return executor;
    }

    @Bean(value={"searchExecutorService"})
    public ExecutorService searchExecutorService() {
        log.info("initialization searchExecutorService");
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.queueCapacity), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("SEARCH_RECALL_THREAD-NO_" + this.sn.incrementAndGet());
                return t;
            }
        });
    }

    @Bean(value={"sortExecutorService"})
    public ExecutorService sortExecutorService() {
        log.info("initialization sortExecutorService");
        return new ThreadPoolExecutor(this.sortCorePoolSize, this.sortMaximumPoolSize, this.sortKeepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.sortQueueCapacity), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(@NotNull Runnable runnable) {
                if (runnable == null) {
                    2.$$$reportNull$$$0(0);
                }
                Thread t = new Thread(runnable);
                t.setName("SEARCH_SORT_THREAD-NO_" + this.sn.incrementAndGet());
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/tydic/se/es/confige/thread/EsToolThreadPollManager$2", "newThread"));
            }
        });
    }

    @Bean(value={"esbSearchExecutorService"})
    public ExecutorService executorService() {
        log.info("initialization esbSearchExecutorService");
        return new ThreadPoolExecutor(this.esbCorePoolSize, this.esbMaximumPoolSize, this.esbKeepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.esbQueueCapacity), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("ESB_SEARCH_THREAD-NO_" + this.sn.incrementAndGet());
                return t;
            }
        });
    }
}

