/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.syncable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.se.base.dao.UccCatRCommdTypeMapper;
import com.tydic.se.base.dao.UccCatalogDealMapper;
import com.tydic.se.base.dao.UccChannelDealMapper;
import com.tydic.se.base.dao.UccCommodityLabelMapper;
import com.tydic.se.base.dao.UccCommodityMapper;
import com.tydic.se.base.dao.UccCommodityTypeMapper;
import com.tydic.se.base.dao.UccMallBrandRelMapper;
import com.tydic.se.base.dao.UccRelChannelPoolMapper;
import com.tydic.se.base.dao.UccRelCommodityLabelPoolMapper;
import com.tydic.se.base.dao.UccRelPoolCommodityMapper;
import com.tydic.se.base.dao.UccSaleNumMapper;
import com.tydic.se.base.dao.UccSkuMapper;
import com.tydic.se.base.dao.UccSkuPicMapper;
import com.tydic.se.base.dao.UccSpuSpecMapper;
import com.tydic.se.base.dao.po.UccCatalogLevelPo;
import com.tydic.se.base.dao.po.UccChannelDealPo;
import com.tydic.se.base.dao.po.UccCommodityLabelPo;
import com.tydic.se.base.dao.po.UccMallBrandRelPO;
import com.tydic.se.base.dao.po.UccQrySkuStateInfoPo;
import com.tydic.se.base.dao.po.UccRelChannelPoolPo;
import com.tydic.se.base.dao.po.UccRelCommodityLabelPoolPo;
import com.tydic.se.base.dao.po.UccRelPoolCommodityPo;
import com.tydic.se.base.dao.po.UccSaleNumPo;
import com.tydic.se.base.dao.po.UccSkuPicPo;
import com.tydic.se.base.dao.po.UccSkuPo;
import com.tydic.se.es.confige.restClient.EsConfig;
import com.tydic.se.es.constants.SeEsConstant;
import com.tydic.se.es.data.SeEsDataBo;
import com.tydic.se.es.data.SeSyncEsCommodityDataBo;
import com.tydic.se.es.data.SeSyncEsCommodityPropDataBo;
import com.tydic.se.es.data.SeSyncEsPoolsLabelDataBo;
import com.tydic.se.es.data.SeSyncEsSkuDataBo;
import com.tydic.se.es.data.SeSyncEsSkuSupplierDataBo;
import com.tydic.se.es.data.SeSyncSkuAttrDataBo;
import com.tydic.se.es.exception.BusinessException;
import com.tydic.se.es.syncable.SyncAble;
import com.tydic.se.es.syncable.bo.SyncAbleReqBo;
import com.tydic.se.es.util.ElasticsearchUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSyncAble
implements SyncAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncAble.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccRelCommodityLabelPoolMapper uccRelCommodityLabelPoolMapper;
    @Autowired
    private UccCommodityLabelMapper uccCommodityLabelMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    protected List<SeSyncEsCommodityDataBo> qryCommodityInfos(SyncAbleReqBo reqBo) {
        List commodityTypeIds;
        List<Object> commodityInfos = new ArrayList<SeSyncEsCommodityDataBo>();
        List commodityPos = null;
        if (SeEsConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBo.getSyncType())) {
            commodityPos = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBo.getCommodityIds(), reqBo.getSupplierId(), reqBo.getSceneId());
        }
        if (SeEsConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBo.getSyncType())) {
            commodityTypeIds = this.uccCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBo.getCategoryIds());
            if (CollectionUtils.isEmpty((Collection)commodityTypeIds)) {
                throw new BusinessException("5001", "\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a\u6839\u636e\u4f20\u5165\u7684\u7c7b\u76eeID\u5217\u8868\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u5546\u54c1\u6570\u636e");
            }
            commodityPos = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBo.getRootOrgIdIn(), reqBo.getSceneId());
        }
        if (SeEsConstant.SYNC_TYPE_BY_GUI_CATEGORY_ID.equals(reqBo.getSyncType())) {
            commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(reqBo.getGuiCategoryIds());
            if (CollectionUtils.isEmpty((Collection)commodityTypeIds)) {
                throw new BusinessException("5001", "\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a\u6839\u636e\u4f20\u5165\u7684\u524d\u53f0\u5bfc\u8d2d\u7c7b\u76eeID\u5217\u8868\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u5546\u54c1\u6570\u636e");
            }
            commodityPos = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBo.getSupplierId(), reqBo.getSceneId());
        }
        if (SeEsConstant.SYNC_TYPE_BY_SKU_ID.equals(reqBo.getSyncType())) {
            List skuPos = this.uccSkuMapper.queryBatchSkusLessCloum(reqBo.getSkuIds(), reqBo.getSupplierId());
            if (CollectionUtils.isEmpty((Collection)skuPos)) {
                throw new BusinessException("5001", "\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a\u6839\u636e\u4f20\u5165\u7684\u5355\u54c1ID\u5217\u8868\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
            List commodityIds = skuPos.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList());
            commodityPos = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, commodityIds, reqBo.getSupplierId(), reqBo.getSceneId());
        }
        if (CollectionUtils.isEmpty((Collection)commodityPos)) {
            log.error("\u6839\u636e\u5165\u53c2\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u5546\u54c1\u4fe1\u606f\u5217\u8868");
            return commodityInfos;
        }
        commodityInfos = JSON.parseArray((String)JSON.toJSONString((Object)commodityPos), SeSyncEsCommodityDataBo.class);
        if (CollectionUtils.isEmpty(commodityInfos)) {
            log.error("\u5546\u54c1\u4fe1\u606f\u5217\u8868\u8d4b\u503c\u5931\u8d25");
            return commodityInfos;
        }
        HashMap<Long, SeSyncEsCommodityDataBo> tempInfoMap = new HashMap<Long, SeSyncEsCommodityDataBo>(16);
        for (SeSyncEsCommodityDataBo seSyncEsCommodityDataBo : commodityInfos) {
            if (null == seSyncEsCommodityDataBo.getGuideCataLogId()) {
                tempInfoMap.put(seSyncEsCommodityDataBo.getCommodityId(), seSyncEsCommodityDataBo);
                continue;
            }
            if (tempInfoMap.containsKey(seSyncEsCommodityDataBo.getCommodityId())) {
                ((SeSyncEsCommodityDataBo)tempInfoMap.get(seSyncEsCommodityDataBo.getCommodityId())).getGuideCataLogIds().add(seSyncEsCommodityDataBo.getGuideCataLogId());
                continue;
            }
            seSyncEsCommodityDataBo.setGuideCataLogIds(new ArrayList<Long>(Collections.singletonList(seSyncEsCommodityDataBo.getGuideCataLogId())));
            tempInfoMap.put(seSyncEsCommodityDataBo.getCommodityId(), seSyncEsCommodityDataBo);
        }
        commodityInfos = new ArrayList(tempInfoMap.values());
        return commodityInfos;
    }

    protected List<SeEsDataBo> assembleEsSkuInfo(SyncAbleReqBo reqBo, List<Long> commodityIds) {
        List brandRelPos;
        List skuInfoPos = this.uccSkuMapper.qrySkuAndLowPriceList(reqBo.getSupplierId(), commodityIds);
        if (CollectionUtils.isEmpty((Collection)skuInfoPos)) {
            log.error("\u6839\u636e\u5546\u54c1ID\u5217\u8868\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        List skuInfos = JSON.parseArray((String)JSON.toJSONString((Object)skuInfoPos), SeSyncEsSkuDataBo.class);
        skuInfos.forEach(skuInfo -> {
            skuInfo.setOriginBrandId(skuInfo.getBrandId());
            skuInfo.setOriginBrandName(skuInfo.getBrandName());
        });
        List brandIds = skuInfos.stream().map(SeSyncEsSkuDataBo::getBrandId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(brandIds) && !CollectionUtils.isEmpty((Collection)(brandRelPos = this.uccMallBrandRelMapper.getRelByBrandList(brandIds)))) {
            Map<Long, UccMallBrandRelPO> brandInfoMap = brandRelPos.stream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, uccMallBrandRelPo -> uccMallBrandRelPo));
            for (SeSyncEsSkuDataBo skuInfo2 : skuInfos) {
                UccMallBrandRelPO brandRelPo;
                if (null == skuInfo2.getBrandId() || null == (brandRelPo = brandInfoMap.get(skuInfo2.getBrandId()))) continue;
                skuInfo2.setBrandId(brandRelPo.getMallBrandId());
                skuInfo2.setBrandName(brandRelPo.getMallBrandName());
            }
        }
        List skuIds = skuInfos.stream().map(SeSyncEsSkuDataBo::getSkuId).collect(Collectors.toList());
        List saleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
        Map<Long, UccSaleNumPo> saleNumMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSaleId, uccSaleNumPo -> uccSaleNumPo));
        List skuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skuIds);
        Map<Long, UccSkuPicPo> skuPicMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, uccSkuPicPo -> uccSkuPicPo));
        return this.buildEsData(skuInfos, saleNumMap, skuPicMap);
    }

    private List<SeEsDataBo> buildEsData(List<SeSyncEsSkuDataBo> skuInfos, Map<Long, UccSaleNumPo> saleNumMap, Map<Long, UccSkuPicPo> skuPicMap) {
        ArrayList<SeEsDataBo> seEsDataBos = new ArrayList<SeEsDataBo>();
        for (SeSyncEsSkuDataBo skuInfo : skuInfos) {
            UccSkuPicPo uccSkuPicPo;
            UccSaleNumPo uccSaleNumPo;
            SeEsDataBo esDataBo = new SeEsDataBo();
            esDataBo.setCommodity_id(skuInfo.getCommodityId());
            esDataBo.setSku_id(skuInfo.getSkuId());
            esDataBo.setSku_name(skuInfo.getSkuName());
            esDataBo.setSearch_name(skuInfo.getSkuName());
            esDataBo.setExt_sku_id(skuInfo.getExtSkuId());
            esDataBo.setBrand_id(skuInfo.getBrandId());
            esDataBo.setBrand_name(skuInfo.getBrandName());
            esDataBo.setSku_status(skuInfo.getSkuStatus());
            esDataBo.setSku_source(skuInfo.getSkuSource());
            esDataBo.setMfgsku(skuInfo.getMfgsku());
            esDataBo.setUpc(skuInfo.getUpcCode());
            esDataBo.setType_id(skuInfo.getCommodityTypeId());
            esDataBo.setType_name(skuInfo.getCommodityTypeName());
            if (skuInfo.getOnShelveTime() != null) {
                esDataBo.setOn_shelve_time(Long.valueOf(DateUtils.strToDateLong((String)skuInfo.getOnShelveTime()).getTime()));
            }
            esDataBo.setAgreement_id(skuInfo.getAgreementId());
            esDataBo.setSale_price(Double.valueOf(null == skuInfo.getSalePrice() ? 0L : skuInfo.getSalePrice()));
            esDataBo.setAgreement_price(Double.valueOf(null == skuInfo.getAgreementPrice() ? 0L : skuInfo.getAgreementPrice()));
            esDataBo.setMarket_price(Double.valueOf(null == skuInfo.getMarketPrice() ? 0L : skuInfo.getMarketPrice()));
            esDataBo.setMember_price1(Double.valueOf(null == skuInfo.getMemberPrice1() ? 0L : skuInfo.getMemberPrice1()));
            esDataBo.setMember_price2(Double.valueOf(null == skuInfo.getMemberPrice2() ? 0L : skuInfo.getMemberPrice2()));
            esDataBo.setMember_price3(Double.valueOf(null == skuInfo.getMemberPrice3() ? 0L : skuInfo.getMemberPrice3()));
            esDataBo.setMember_price4(Double.valueOf(null == skuInfo.getMemberPrice4() ? 0L : skuInfo.getMemberPrice4()));
            esDataBo.setMember_price5(Double.valueOf(null == skuInfo.getMemberPrice5() ? 0L : skuInfo.getMemberPrice5()));
            esDataBo.setSupplier_id(skuInfo.getSupplierId());
            esDataBo.setSupplier_shop_id(skuInfo.getSupplierShopId());
            esDataBo.setShop_name(skuInfo.getShopName());
            esDataBo.setSupplier_name(skuInfo.getSupplierName());
            String discount = "0";
            if (null != skuInfo.getSalePrice() && null != skuInfo.getMarketPrice() && 0L != skuInfo.getMarketPrice()) {
                discount = String.format("%.2f", (double)skuInfo.getSalePrice().longValue() / (double)skuInfo.getMarketPrice().longValue());
            }
            esDataBo.setDiscounts(Double.valueOf(discount));
            esDataBo.setComment_number(null);
            esDataBo.setSold_number(null);
            esDataBo.setEcommerce_sale(null);
            if (CollectionUtils.isEmpty(saleNumMap) && (uccSaleNumPo = saleNumMap.get(skuInfo.getSkuId())) != null) {
                if (uccSaleNumPo.getSoldNumber() != null) {
                    esDataBo.setSold_number(Long.valueOf(uccSaleNumPo.getSoldNumber().longValue()));
                }
                if (uccSaleNumPo.getEcommerceSale() != null) {
                    esDataBo.setEcommerce_sale(Long.valueOf(uccSaleNumPo.getEcommerceSale().longValue()));
                }
            }
            if (CollectionUtils.isEmpty(skuPicMap) && (uccSkuPicPo = skuPicMap.get(skuInfo.getSkuId())) != null) {
                esDataBo.setPicture_url(uccSkuPicPo.getSkuPicUrl());
            }
            esDataBo.setChannel_id(null);
            esDataBo.setBrand_id_name(null);
            esDataBo.setDescription(null);
            esDataBo.setSupplier_id_name(null);
            esDataBo.setProperties(null);
            esDataBo.setL4mg_category_id(skuInfo.getMgCatalogId());
            esDataBo.setL4mg_category_name(skuInfo.getMgCatalogName());
            esDataBo.setMaterial_id(skuInfo.getMaterialId());
            esDataBo.setMaterial_name(skuInfo.getMaterialName());
            esDataBo.setMaterial_code(skuInfo.getMaterialCode());
            esDataBo.setModel(skuInfo.getModel());
            esDataBo.setSpec(skuInfo.getSpec());
            esDataBo.setMeasure_name(skuInfo.getMeasure());
            esDataBo.setOrigin_brand_id(skuInfo.getOriginBrandId());
            esDataBo.setOrigin_brand_name(skuInfo.getOriginBrandName());
            esDataBo.setInsert_time(Long.valueOf(System.currentTimeMillis()));
            esDataBo.setSku_code(skuInfo.getSkuCode());
            esDataBo.setSku_approval_status(skuInfo.getApprovalStatus());
            esDataBo.setSupplier_org_id(skuInfo.getSupplierOrgId());
            esDataBo.setSupplier_org_name(skuInfo.getSupplierOrgName());
            esDataBo.setCreate_oper_id(skuInfo.getCreateOperId());
            esDataBo.setCreate_oper_name(skuInfo.getCreateOperName());
            esDataBo.setUpdate_oper_id(skuInfo.getUpdateOperId());
            esDataBo.setUpdate_oper_name(skuInfo.getUpdateOperName());
            if (skuInfo.getCreateTime() != null) {
                esDataBo.setCreate_time(Long.valueOf(DateUtils.strToDateLong((String)skuInfo.getCreateTime()).getTime()));
            }
            seEsDataBos.add(esDataBo);
        }
        return seEsDataBos;
    }

    protected void assembleCommodityAndCategory(SyncAbleReqBo reqBo, List<Long> commodityIds, List<SeEsDataBo> esDataBos, List<SeSyncEsCommodityDataBo> commodityDataBos) {
        Map<Long, SeSyncEsCommodityDataBo> commodityDataMap = commodityDataBos.stream().collect(Collectors.toMap(SeSyncEsCommodityDataBo::getCommodityId, seSyncEsCommodityDataBo -> seSyncEsCommodityDataBo));
        ArrayList guiCatalog = new ArrayList();
        for (SeSyncEsCommodityDataBo commodityDataBo : commodityDataBos) {
            if (CollectionUtils.isEmpty((Collection)commodityDataBo.getGuideCataLogIds())) continue;
            guiCatalog.addAll(commodityDataBo.getGuideCataLogIds());
        }
        if (!CollectionUtils.isEmpty(guiCatalog)) {
            guiCatalog = new ArrayList(new LinkedHashSet(guiCatalog));
        }
        List catalogInfoPos = new ArrayList();
        if (!CollectionUtils.isEmpty(guiCatalog)) {
            catalogInfoPos = this.uccCatalogDealMapper.quryCatalogLevel(reqBo.getSceneId(), null, guiCatalog);
        }
        List commodityProps = new ArrayList();
        List commodityPropPos = this.uccSpuSpecMapper.qrySpuSpecList(commodityIds, reqBo.getSupplierId());
        if (!CollectionUtils.isEmpty((Collection)commodityPropPos)) {
            commodityProps = JSON.parseArray((String)JSON.toJSONString((Object)commodityPropPos), SeSyncEsCommodityPropDataBo.class);
        }
        Map<Long, SeSyncEsCommodityPropDataBo> commodityPropMap = commodityProps.stream().collect(Collectors.toMap(SeSyncEsCommodityPropDataBo::getCommodityId, commodityProp -> commodityProp));
        for (SeEsDataBo esDataBo : esDataBos) {
            SeSyncEsCommodityPropDataBo commodityPropData;
            SeSyncEsCommodityDataBo commodityDataBo = commodityDataMap.get(esDataBo.getCommodity_id());
            esDataBo.setScene_id(reqBo.getSceneId());
            esDataBo.setCommodity_name(commodityDataBo.getCommodityName());
            esDataBo.setCommd_pic_url(commodityDataBo.getCommodityPicUrl());
            if (!CollectionUtils.isEmpty((Collection)commodityDataBo.getGuideCataLogIds())) {
                esDataBo.setL3_category_id(commodityDataBo.getGuideCataLogIds().stream().map(String::valueOf).collect(Collectors.toList()));
            }
            esDataBo.setVendor_id(commodityDataBo.getVendorId());
            esDataBo.setVendor_name(commodityDataBo.getVendorName());
            if (StringUtils.isEmpty((Object)esDataBo.getPicture_url())) {
                esDataBo.setPicture_url(commodityDataBo.getCommodityPicUrl());
            }
            esDataBo.setView_order(commodityDataBo.getViewOrder());
            esDataBo.setOther_source_name(commodityDataBo.getOtherSourceName());
            esDataBo.setOther_source_id(commodityDataBo.getOtherSourceId());
            esDataBo.setOther_source_code(commodityDataBo.getOtherSourceCode());
            esDataBo.setTaxRate(commodityDataBo.getTaxRate());
            esDataBo.setTaxCode(commodityDataBo.getTaxCatCode());
            esDataBo.setSpu_approval_status(commodityDataBo.getApprovalStatus());
            esDataBo.setCommodity_code(commodityDataBo.getCommodityCode());
            esDataBo.setShow_prop_json(null);
            if (!CollectionUtils.isEmpty(catalogInfoPos) && !CollectionUtils.isEmpty((Collection)esDataBo.getL3_category_id())) {
                for (UccCatalogLevelPo uccCatalogLevelPo : catalogInfoPos) {
                    for (String l3_category_id : esDataBo.getL3_category_id()) {
                        if (!uccCatalogLevelPo.getL3GuideCatalogId().equals(Long.valueOf(l3_category_id))) continue;
                        if (uccCatalogLevelPo.getL1GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty((Collection)esDataBo.getL1_category_id())) {
                                esDataBo.setL1_category_id((List)Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1GuideCatalogId().toString()}));
                            } else if (!esDataBo.getL1_category_id().contains(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()))) {
                                esDataBo.getL1_category_id().add(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()));
                            }
                        }
                        if (uccCatalogLevelPo.getL2GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty((Collection)esDataBo.getL2_category_id())) {
                                esDataBo.setL2_category_id((List)Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2GuideCatalogId().toString()}));
                            } else if (!esDataBo.getL2_category_id().contains(String.valueOf(uccCatalogLevelPo.getL2GuideCatalogId()))) {
                                esDataBo.getL2_category_id().add(uccCatalogLevelPo.getL2GuideCatalogId().toString());
                            }
                        }
                        if (!StringUtils.isEmpty((Object)uccCatalogLevelPo.getL1CatalogName())) {
                            if (CollectionUtils.isEmpty((Collection)esDataBo.getL1_category_name())) {
                                esDataBo.setL1_category_name((List)Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1CatalogName()}));
                            } else if (!esDataBo.getL1_category_name().contains(uccCatalogLevelPo.getL1CatalogName())) {
                                esDataBo.getL1_category_name().add(uccCatalogLevelPo.getL1CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((Object)uccCatalogLevelPo.getL2CatalogName())) {
                            if (CollectionUtils.isEmpty((Collection)esDataBo.getL2_category_name())) {
                                esDataBo.setL2_category_name((List)Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2CatalogName()}));
                            } else if (!esDataBo.getL2_category_name().contains(uccCatalogLevelPo.getL2CatalogName())) {
                                esDataBo.getL2_category_name().add(uccCatalogLevelPo.getL2CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((Object)uccCatalogLevelPo.getL3CatalogName())) {
                            if (CollectionUtils.isEmpty((Collection)esDataBo.getL3_category_name())) {
                                esDataBo.setL3_category_name((List)Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL3CatalogName()}));
                            } else if (!esDataBo.getL3_category_name().contains(uccCatalogLevelPo.getL3CatalogName())) {
                                esDataBo.getL3_category_name().add(uccCatalogLevelPo.getL3CatalogName());
                            }
                        }
                        if (uccCatalogLevelPo.getChannelId() == null) continue;
                        if (CollectionUtils.isEmpty((Collection)esDataBo.getChannel_id())) {
                            esDataBo.setChannel_id((List)Lists.newArrayList((Object[])new Long[]{uccCatalogLevelPo.getChannelId()}));
                            esDataBo.setChannel_Name((List)Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getChannelName()}));
                            continue;
                        }
                        if (!esDataBo.getChannel_id().contains(uccCatalogLevelPo.getChannelId())) {
                            esDataBo.getChannel_id().add(uccCatalogLevelPo.getChannelId());
                        }
                        if (esDataBo.getChannel_Name().contains(uccCatalogLevelPo.getChannelName())) continue;
                        esDataBo.getChannel_Name().add(uccCatalogLevelPo.getChannelName());
                    }
                }
            }
            if (commodityPropMap.size() > 0 && (commodityPropData = commodityPropMap.get(esDataBo.getCommodity_id())) != null) {
                esDataBo.setShow_prop_json(commodityPropData.getPropJson());
            }
            String properties = this.uccSpuSpecMapper.getSpuSpecProperties(esDataBo.getSku_id());
            esDataBo.setProperties(properties);
            esDataBo.setUnuse_suppliershop_list(null);
        }
    }

    protected void assembleSkuPool(SyncAbleReqBo reqBo, List<Long> commodityIds, List<SeEsDataBo> esDataBos) {
        if (CollectionUtils.isEmpty(commodityIds) || CollectionUtils.isEmpty(esDataBos)) {
            return;
        }
        List uccSkuPos = this.uccSkuMapper.batchQrySkuForPool(reqBo.getSupplierId(), commodityIds);
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            throw new BusinessException("5001", "\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e");
        }
        ArrayList skuIds = new ArrayList();
        ArrayList agrIds = new ArrayList();
        ArrayList vendorIds = new ArrayList();
        ArrayList typeIds = new ArrayList();
        uccSkuPos.forEach(each -> {
            if (!skuIds.contains(each.getSkuId())) {
                skuIds.add(each.getSkuId());
            }
            if (!agrIds.contains(each.getAgreementId())) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId())) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId())) {
                typeIds.add(each.getCommodityTypeId());
            }
        });
        List relPoolsBySku = this.uccRelPoolCommodityMapper.queryPools(skuIds, SeEsConstant.REL_BY_SKU);
        List relPoolsByType = this.uccRelPoolCommodityMapper.queryPools(typeIds, SeEsConstant.REL_BY_COMMODITY_TYPE);
        List relPoolsByVendor = this.uccRelPoolCommodityMapper.queryPools(vendorIds, SeEsConstant.REL_BY_VENDOR);
        List relPoolsByAgr = this.uccRelPoolCommodityMapper.queryPools(agrIds, SeEsConstant.REL_BY_AGR);
        for (SeEsDataBo dataBo : esDataBos) {
            this.setPoolId(relPoolsBySku, dataBo);
            this.setPoolId(relPoolsByType, dataBo);
            this.setPoolId(relPoolsByVendor, dataBo);
            this.setPoolId(relPoolsByAgr, dataBo);
        }
    }

    private void setPoolId(List<UccRelPoolCommodityPo> relPools, SeEsDataBo dataBo) {
        if (!CollectionUtils.isEmpty(relPools)) {
            for (UccRelPoolCommodityPo relPoolByType : relPools) {
                if (!relPoolByType.getSource().equals(dataBo.getType_id())) continue;
                if (CollectionUtils.isEmpty((Collection)dataBo.getSkuPoolIds())) {
                    dataBo.setSkuPoolIds((List)Lists.newArrayList((Object[])new Long[]{relPoolByType.getPoolId()}));
                    continue;
                }
                dataBo.getSkuPoolIds().add(relPoolByType.getPoolId());
            }
        }
    }

    protected void assembleChannel(List<SeEsDataBo> esDataBos) {
        if (CollectionUtils.isEmpty(esDataBos)) {
            return;
        }
        for (SeEsDataBo esDataBo : esDataBos) {
            List relChannelPoolPos;
            if (CollectionUtils.isEmpty((Collection)esDataBo.getChannel_id())) {
                List relChannelPoolPos2;
                if (CollectionUtils.isEmpty((Collection)esDataBo.getSkuPoolIds()) || CollectionUtils.isEmpty((Collection)(relChannelPoolPos2 = this.uccRelChannelPoolMapper.getRelListByPools(esDataBo.getSkuPoolIds())))) continue;
                List channelIds = relChannelPoolPos2.stream().map(UccRelChannelPoolPo::getChannelId).collect(Collectors.toList());
                List channelNames = relChannelPoolPos2.stream().map(UccRelChannelPoolPo::getChannelName).collect(Collectors.toList());
                esDataBo.setChannel_id(channelIds);
                esDataBo.setChannel_Name(channelNames);
                continue;
            }
            ArrayList<Long> channelIds = new ArrayList<Long>(esDataBo.getChannel_id());
            ArrayList<String> channelNames = new ArrayList<String>(esDataBo.getChannel_Name());
            for (Long channelId : esDataBo.getChannel_id()) {
                UccChannelDealPo uccChannelDealPO = new UccChannelDealPo();
                uccChannelDealPO.setChannelId(channelId);
                uccChannelDealPO.setRelatedType(Integer.valueOf(1));
                List channelDealPos = this.uccChannelDealMapper.selectByChannelCode(uccChannelDealPO);
                if (CollectionUtils.isEmpty((Collection)channelDealPos)) continue;
                if (CollectionUtils.isEmpty((Collection)esDataBo.getSkuPoolIds())) {
                    channelIds.remove(channelId);
                    channelNames.remove(((UccChannelDealPo)channelDealPos.get(0)).getChannelName());
                    continue;
                }
                List relChannelPoolPos3 = this.uccRelChannelPoolMapper.getRelListByChannelIds((List)Lists.newArrayList((Object[])new Long[]{((UccChannelDealPo)channelDealPos.get(0)).getChannelId()}));
                if (CollectionUtils.isEmpty((Collection)relChannelPoolPos3)) {
                    channelIds.remove(channelId);
                    channelNames.remove(((UccChannelDealPo)channelDealPos.get(0)).getChannelName());
                    continue;
                }
                boolean contain = false;
                for (UccRelChannelPoolPo relChannelPoolPo : relChannelPoolPos3) {
                    if (!esDataBo.getSkuPoolIds().contains(relChannelPoolPo.getPoolId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                channelIds.remove(channelId);
                channelNames.remove(((UccChannelDealPo)channelDealPos.get(0)).getChannelName());
            }
            if (!CollectionUtils.isEmpty((Collection)esDataBo.getSkuPoolIds()) && !CollectionUtils.isEmpty((Collection)(relChannelPoolPos = this.uccRelChannelPoolMapper.getRelListByPools(esDataBo.getSkuPoolIds())))) {
                List channelIdList = relChannelPoolPos.stream().map(UccRelChannelPoolPo::getChannelId).collect(Collectors.toList());
                Map<Long, String> channelMap = relChannelPoolPos.stream().collect(Collectors.toMap(UccRelChannelPoolPo::getChannelId, UccRelChannelPoolPo::getChannelName));
                for (Long channelId : channelIdList) {
                    if (esDataBo.getChannel_id().contains(channelId)) continue;
                    channelIds.add(channelId);
                    channelNames.add(channelMap.get(channelId));
                }
            }
            esDataBo.setChannel_id(channelIds);
            esDataBo.setChannel_Name(channelNames);
        }
    }

    protected void assembleLabel(List<SeEsDataBo> esDataBos) {
        if (CollectionUtils.isEmpty(esDataBos)) {
            return;
        }
        ArrayList skuPools = new ArrayList();
        esDataBos.stream().filter(a -> !CollectionUtils.isEmpty((Collection)a.getSkuPoolIds())).forEach(item -> skuPools.addAll(item.getSkuPoolIds()));
        if (CollectionUtils.isEmpty(skuPools)) {
            return;
        }
        List relLabelPoolPos = this.uccRelCommodityLabelPoolMapper.queryAllInfoByPoolList(skuPools);
        if (CollectionUtils.isEmpty((Collection)relLabelPoolPos)) {
            return;
        }
        HashSet labelIdSet = new HashSet();
        relLabelPoolPos.stream().forEach(item -> labelIdSet.add(item.getLabelId()));
        List labelPos = this.uccCommodityLabelMapper.selectLabel(null, new ArrayList(skuPools));
        if (CollectionUtils.isEmpty((Collection)labelPos)) {
            log.error("\u6570\u636e\u540c\u6b65 \uff0c\u6807\u7b7e\u4e0d\u5b58\u5728" + labelIdSet);
            return;
        }
        Map<Long, UccCommodityLabelPo> labelMap = labelPos.stream().collect(Collectors.toMap(UccCommodityLabelPo::getLabelId, labelPo -> labelPo, (a, b) -> a));
        Map<Long, List<UccRelCommodityLabelPoolPo>> groupByPoolLabelMap = relLabelPoolPos.stream().collect(Collectors.groupingBy(UccRelCommodityLabelPoolPo::getPoolId));
        HashMap<Long, SeSyncEsPoolsLabelDataBo> poolsLabelDetailMap = new HashMap<Long, SeSyncEsPoolsLabelDataBo>();
        Iterator<Map.Entry<Long, List<UccRelCommodityLabelPoolPo>>> iterator = groupByPoolLabelMap.entrySet().iterator();
        HashSet<Long> labelIds = new HashSet<Long>();
        HashSet<Long> showLabelIds = new HashSet<Long>();
        HashSet<String> labelNames = new HashSet<String>();
        HashSet<String> showLabelNames = new HashSet<String>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<UccRelCommodityLabelPoolPo>> entry = iterator.next();
            labelIds.clear();
            labelNames.clear();
            showLabelIds.clear();
            showLabelNames.clear();
            SeSyncEsPoolsLabelDataBo poolsLabelDetail = new SeSyncEsPoolsLabelDataBo();
            poolsLabelDetail.setPoolId(entry.getKey());
            for (UccRelCommodityLabelPoolPo relLabelPoolPo : entry.getValue()) {
                if (!labelMap.containsKey(relLabelPoolPo.getLabelId())) continue;
                labelIds.add(relLabelPoolPo.getLabelId());
                labelNames.add(labelMap.get(relLabelPoolPo.getLabelId()).getLabelName());
                if (relLabelPoolPo.getIsShow() != 1) continue;
                showLabelIds.add(relLabelPoolPo.getLabelId());
                showLabelNames.add(labelMap.get(relLabelPoolPo.getLabelId()).getLabelName());
            }
            poolsLabelDetail.setLabelIds(new ArrayList(labelIds));
            poolsLabelDetail.setLabelNames(new ArrayList(labelNames));
            poolsLabelDetail.setShowLabelIds(new ArrayList(showLabelIds));
            poolsLabelDetail.setShowLabelNames(new ArrayList(showLabelNames));
            poolsLabelDetailMap.put(entry.getKey(), poolsLabelDetail);
        }
        for (SeEsDataBo esDataBo : esDataBos) {
            if (CollectionUtils.isEmpty((Collection)esDataBo.getSkuPoolIds())) continue;
            labelIds.clear();
            labelNames.clear();
            showLabelIds.clear();
            showLabelNames.clear();
            for (Long pool : esDataBo.getSkuPoolIds()) {
                if (poolsLabelDetailMap.containsKey(pool)) {
                    labelIds.addAll(((SeSyncEsPoolsLabelDataBo)poolsLabelDetailMap.get(pool)).getLabelIds());
                    labelNames.addAll(((SeSyncEsPoolsLabelDataBo)poolsLabelDetailMap.get(pool)).getLabelNames());
                    showLabelIds.addAll(((SeSyncEsPoolsLabelDataBo)poolsLabelDetailMap.get(pool)).getShowLabelIds());
                    showLabelNames.addAll(((SeSyncEsPoolsLabelDataBo)poolsLabelDetailMap.get(pool)).getShowLabelNames());
                    continue;
                }
                log.error("\u672a\u5339\u914d\u5230\u5546\u54c1\u6c60\u8be6\u60c5\u6570\u636e\uff1a" + pool);
            }
            esDataBo.setLabelIds(new ArrayList(labelIds));
            esDataBo.setLabelNames(new ArrayList(labelNames));
            esDataBo.setShowLabelIds(new ArrayList(showLabelIds));
            esDataBo.setShowLabelNames(new ArrayList(showLabelNames));
        }
    }

    protected void assembleApproval(List<SeEsDataBo> esDataBos) {
        ArrayList skuSupplierDatas = new ArrayList();
        esDataBos.forEach(esDataBo -> {
            SeSyncEsSkuSupplierDataBo skuState = new SeSyncEsSkuSupplierDataBo();
            skuState.setSkuId(esDataBo.getSku_id());
            skuState.setSupplierShopId(esDataBo.getSupplier_shop_id());
            skuSupplierDatas.add(skuState);
        });
        List qrySkuStatePos = JSON.parseArray((String)JSON.toJSONString(skuSupplierDatas), UccQrySkuStateInfoPo.class);
        List skuPoList = this.uccSkuMapper.qerySkuStatusList(qrySkuStatePos);
        HashMap operateIdMap = new HashMap(16);
        skuPoList.forEach(skuPo -> {
            List operateIds;
            if (skuPo.getSkuStatus().equals(1) && !CollectionUtils.isEmpty((Collection)(operateIds = this.uccCommodityMapper.qryUocOperIds(skuPo.getCommodityId())))) {
                operateIdMap.put(skuPo.getCommodityId(), operateIds);
            }
        });
        esDataBos.forEach(esDataBo -> {
            if (operateIdMap.containsKey(esDataBo.getCommodity_id())) {
                esDataBo.setOperIds((List)operateIdMap.get(esDataBo.getCommodity_id()));
            }
        });
    }

    protected void syncToEs(List<SeEsDataBo> esDataBos, String indexName) {
        if (CollectionUtils.isEmpty(esDataBos)) {
            log.error("=====\u540c\u6b65\u6570\u636e\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        ArrayList<Map<String, JSONObject>> esDataSource = new ArrayList<Map<String, JSONObject>>();
        for (SeEsDataBo esDataBo : esDataBos) {
            HashMap<String, JSONObject> sourceMap = new HashMap<String, JSONObject>(16);
            JSONObject esDataJson = JSON.parseObject((String)JSON.toJSONString((Object)esDataBo));
            String skuId = String.valueOf(esDataBo.getSku_id());
            String documentId = null == esDataBo.getScene_id() ? skuId : esDataBo.getScene_id() + skuId;
            sourceMap.put(documentId, esDataJson);
            esDataSource.add(sourceMap);
        }
        this.elasticsearchUtil.addDocumentBatch(indexName, esDataSource);
    }

    protected void syncAttrToEs(List<Long> commodityIds) {
        if (CollectionUtils.isEmpty(commodityIds)) {
            return;
        }
        List spuAttrPos = this.uccSpuSpecMapper.qryEsAttrList(commodityIds);
        if (CollectionUtils.isEmpty((Collection)spuAttrPos)) {
            return;
        }
        List skuAttrDataBos = JSON.parseArray((String)JSON.toJSONString((Object)spuAttrPos), SeSyncSkuAttrDataBo.class);
        ArrayList<Map<String, JSONObject>> sourceList = new ArrayList<Map<String, JSONObject>>();
        for (SeSyncSkuAttrDataBo skuAttrData : skuAttrDataBos) {
            HashMap<String, JSONObject> sourceMap = new HashMap<String, JSONObject>(16);
            JSONObject source = JSON.parseObject((String)JSON.toJSONString((Object)skuAttrData));
            String specId = String.valueOf(source.remove((Object)"spec_id"));
            specId = StringUtils.isEmpty((Object)specId) ? String.valueOf(UUID.randomUUID()) : specId;
            sourceMap.put(specId, source);
            sourceList.add(sourceMap);
        }
        this.elasticsearchUtil.addDocumentBatch(this.esConfig.getPropIndexName(), sourceList);
    }
}

