/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.impl;

import com.tydic.se.nlp.alu.corpus.document.CorpusLoader;
import com.tydic.se.nlp.alu.corpus.document.HandlerThreadExecute;
import com.tydic.se.nlp.alu.dictionary.NatureDictionaryMaker;
import com.tydic.se.nlp.alu.intfs.MakeDictionaryService;
import com.tydic.se.nlp.alu.req.MakeDictionaryReqBo;
import com.tydic.se.nlp.alu.rsp.MakeDictionaryRspBo;
import com.tydic.se.nlp.alu.util.CorpusUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="makeCustomerDictionaryService")
public class MakeCustomerDictionaryServiceImpl
implements MakeDictionaryService {
    private static final Logger log = LoggerFactory.getLogger(MakeCustomerDictionaryServiceImpl.class);
    private int threadNum = 5;

    public MakeDictionaryRspBo makeDictionary(MakeDictionaryReqBo reqBo) {
        log.info("\u5f00\u59cb\u5236\u4f5c\u8bcd\u5178,\u6307\u5b9a\u7ebf\u7a0b\u6570\u91cf\uff1a" + reqBo.getThreadNum());
        if (StringUtils.isEmpty((Object)reqBo.getThreadNum())) {
            return this.makeBySingletonCustomer(reqBo);
        }
        this.threadNum = reqBo.getThreadNum();
        MakeDictionaryRspBo rspBo = new MakeDictionaryRspBo();
        NatureDictionaryMaker dictionaryMaker = new NatureDictionaryMaker();
        CorpusLoader.HandlerThread[] threadArray = new CorpusLoader.HandlerThread[this.threadNum];
        for (int i = 0; i < this.threadNum; ++i) {
            HandlerThreadExecute execute = new HandlerThreadExecute("Thread" + i);
            execute.setDictionaryMaker(dictionaryMaker);
            threadArray[i] = execute;
        }
        CorpusLoader.walk((String)reqBo.getCorpusPath(), (CorpusLoader.HandlerThread[])threadArray);
        dictionaryMaker.saveTxtTo(reqBo.getDicOutPath());
        log.info("\u5236\u4f5c\u8bcd\u5178\u5b8c\u6210,\u8bcd\u5178\u8def\u5f84\uff1a" + reqBo.getDicOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private MakeDictionaryRspBo makeBySingletonCustomer(MakeDictionaryReqBo reqBo) {
        MakeDictionaryRspBo rspBo = new MakeDictionaryRspBo();
        NatureDictionaryMaker dictionaryMaker = new NatureDictionaryMaker();
        CorpusLoader.walk((String)reqBo.getCorpusPath(), document -> dictionaryMaker.compute(CorpusUtil.convert2CompatibleList((List)document.getSimpleSentenceList(true))));
        dictionaryMaker.saveTxtTo(reqBo.getDicOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }
}

