/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.impl;

import com.tydic.se.nlp.alu.collection.io.IOUtil;
import com.tydic.se.nlp.alu.intfs.NewWordDiscoverService;
import com.tydic.se.nlp.alu.mining.word.NewWordDiscover;
import com.tydic.se.nlp.alu.mining.word.WordInfo;
import com.tydic.se.nlp.alu.req.NewWordDiscoverReqBo;
import com.tydic.se.nlp.alu.rsp.NewWordDiscoverRspBo;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NewWordDiscoverServiceImpl
implements NewWordDiscoverService {
    private static final Logger log = LoggerFactory.getLogger(NewWordDiscoverServiceImpl.class);

    public NewWordDiscoverRspBo discoverWord(NewWordDiscoverReqBo reqBo) {
        log.info("\u5f00\u59cb\u53d1\u73b0\u65b0\u8bcd,\u8f93\u5165\u7684\u8bed\u6599\u6587\u4ef6\uff1a" + reqBo.getCorpusPath());
        NewWordDiscoverRspBo rspBo = new NewWordDiscoverRspBo();
        try {
            FileOutputStream fos = new FileOutputStream(reqBo.getWordOutPath());
            try (OutputStreamWriter writer = new OutputStreamWriter(fos);){
                BufferedReader br = IOUtil.newBufferedReader((String)reqBo.getCorpusPath());
                NewWordDiscover discover = new NewWordDiscover(6, 0.0f, 0.5f, 100.0f, reqBo.getNewWordsOnly().booleanValue());
                List wordInfoList = discover.discover(br, reqBo.getSize().intValue());
                for (WordInfo wordInfo : wordInfoList) {
                    writer.write(wordInfo.text);
                    writer.append("\r\n");
                }
                fos.close();
                log.info("\u65b0\u8bcd\u63d0\u53d6\u5b8c\u6210,\u8f93\u51fa\u8def\u5f84:" + reqBo.getWordOutPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }
}

