/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.utils;

public class ChineseSymbolUtil {
    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChinese(String str) {
        char[] ch;
        for (char c : ch = str.toCharArray()) {
            if (!ChineseSymbolUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static String dealSpecialSymbols(String msg) {
        String line = msg.replaceAll("\\{", "").replaceAll("}", "").replaceAll("\\[", "").replaceAll("]", "").replaceAll("\u3010", "").replaceAll("\u3011", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\uff08", "").replaceAll("\uff09", "");
        return line;
    }
}

