/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.data;

import com.tydic.nlp.util.SentencesUtil;
import com.tydic.se.nlp.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.service.constant.CountSqlEnum;
import com.tydic.se.nlp.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.service.data.DataBaseUtils;
import com.tydic.se.nlp.service.utils.ReadTxtUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryVendorService")
public class QueryVendorService
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryVendorService.class);
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "vendor";
    private final String preTxtUrl = "/basic/ignore-prefix-vendor.txt";
    private final String sufTxtUrl = "/basic/ignore-suffix-vendor.txt";
    private static final int pageSize = 50000;
    List<String> nameList = new ArrayList<String>();
    List<String> dicList = new ArrayList<String>();

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String txtFile = reqBo.getOutPath() + "vendor" + ".txt";
        String dicFile = reqBo.getOutPath() + "vendor" + ".dic";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = 0;
        Statement stmt = null;
        try {
            stmt = DataBaseUtils.getConn().createStatement();
            ResultSet rs = stmt.executeQuery(CountSqlEnum.VENDOR.getSql());
            while (rs.next()) {
                counter = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        try {
            stmt.close();
            DataBaseUtils.getConn().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DataBaseUtils.writeContent(this.nameList, txtFile, true);
        DataBaseUtils.writeContent(this.dicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.VENDOR.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            PreparedStatement prepareStatement = DataBaseUtils.getConn().prepareStatement(querySql);
            ResultSet rs = prepareStatement.executeQuery(querySql);
            while (rs.next()) {
                String dealName;
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)(dealName = this.dealMatches(name))) || this.nameList.contains(dealName)) continue;
                this.nameList.add(dealName);
                this.dicList.addAll(SentencesUtil.toSentenceList((String)dealName));
            }
            rs.close();
            prepareStatement.close();
            DataBaseUtils.getConn().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealMatches(String msg) throws IOException {
        String line = msg;
        line = line.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\uff08", "").replaceAll("\uff09", "");
        List<String> prefixList = ReadTxtUtil.readLine(this.getClass().getResource("/basic/ignore-prefix-vendor.txt").getPath());
        List<String> suffixList = ReadTxtUtil.readLine(this.getClass().getResource("/basic/ignore-suffix-vendor.txt").getPath());
        for (String s : prefixList) {
            line = line.replaceAll(s, "");
        }
        for (String s : suffixList) {
            line = line.replaceAll(s, "");
        }
        return line;
    }
}

