/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.data;

import com.tydic.nlp.util.SentencesUtil;
import com.tydic.se.nlp.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.service.constant.CountSqlEnum;
import com.tydic.se.nlp.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.service.data.DataBaseUtils;
import com.tydic.se.nlp.service.utils.ReadTxtUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryCatalogService")
public class QueryCatalogService
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryCatalogService.class);
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "catalog";
    private static final int pageSize = 50000;
    private final String txtUrl = "/basic/exclusion-catalog.txt";
    private List<String> nameList = new ArrayList<String>();
    private List<String> dicList = new ArrayList<String>();

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String txtFile = reqBo.getOutPath() + "catalog" + ".txt";
        String dicFile = reqBo.getOutPath() + "catalog" + ".dic";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = 0;
        Statement stmt = null;
        try {
            stmt = DataBaseUtils.getConn().createStatement();
            ResultSet rs = stmt.executeQuery(CountSqlEnum.CATALOG.getSql());
            while (rs.next()) {
                counter = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        try {
            stmt.close();
            DataBaseUtils.getConn().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DataBaseUtils.writeContent(this.nameList, txtFile, true);
        DataBaseUtils.writeContent(this.dicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.CATALOG.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            PreparedStatement prepareStatement = DataBaseUtils.getConn().prepareStatement(querySql);
            ResultSet rs = prepareStatement.executeQuery(querySql);
            while (rs.next()) {
                String dealName;
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)(dealName = this.dealMatches(name)))) continue;
                this.nameList.add(dealName);
                this.dicList.addAll(SentencesUtil.toSentenceList((String)dealName));
            }
            rs.close();
            prepareStatement.close();
            DataBaseUtils.getConn().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealMatches(String msg) throws IOException {
        List<String> list = ReadTxtUtil.readLine(this.getClass().getResource("/basic/exclusion-catalog.txt").getPath());
        if (msg.matches("[\\u4e00-\\u9fa5]{2,4}")) {
            for (String exclusionStr : list) {
                if (!msg.contains(exclusionStr)) continue;
                return null;
            }
            return msg;
        }
        return null;
    }
}

