/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.data;

import com.tydic.se.nlp.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.service.data.DataBaseUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryNewCommodityService")
public class QueryNewCommodityService
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryNewCommodityService.class);
    private final String suffix_txt = ".txt";
    private final String fileName = "commodity-bd";
    private static final int pageSize = 1000;

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = 0;
        Statement stmt = null;
        String countSql = "SELECT COUNT(0) from ucc_brand";
        try {
            stmt = DataBaseUtils.getConn().createStatement();
            ResultSet rs = stmt.executeQuery(countSql);
            while (rs.next()) {
                counter = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int totalPage = counter % 1000 == 0 ? counter / 1000 : counter / 1000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i, reqBo.getOutPath());
        }
        try {
            stmt.close();
            DataBaseUtils.getConn().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage, String outPath) {
        String txtFile = outPath + "commodity-bd" + startPage + ".txt";
        String querySql = "SELECT brand_id from ucc_brand LIMIT " + startPage * 1000 + "," + 1000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u751f\u6210\u6587\u4ef6:" + txtFile + "," + querySql);
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            PreparedStatement prepareStatement = DataBaseUtils.getConn().prepareStatement(querySql);
            ResultSet rs = prepareStatement.executeQuery(querySql);
            Statement gstatement = null;
            ResultSet crs = null;
            while (rs.next()) {
                String brandId = rs.getString(1);
                if (StringUtils.isEmpty((Object)brandId)) continue;
                String goodsQuery = "SELECT COMMODITY_NAME from ucc_commodity where brand_id = " + brandId + " LIMIT 1";
                gstatement = DataBaseUtils.getConn().prepareStatement(goodsQuery);
                crs = gstatement.executeQuery(goodsQuery);
                while (crs.next()) {
                    String name = crs.getString(1);
                    if (StringUtils.isEmpty((Object)name)) continue;
                    String dealName = this.dealSpecialSymbols(name);
                    nameList.add(dealName);
                }
            }
            DataBaseUtils.writeContent(nameList, txtFile, true);
            rs.close();
            crs.close();
            gstatement.close();
            prepareStatement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealSpecialSymbols(String msg) {
        String line = msg.replaceAll("\\{", "").replaceAll("}", "").replaceAll("\\[", "").replaceAll("]", "").replaceAll("\u3010", "").replaceAll("\u3011", "");
        return line;
    }
}

