/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.config;

import com.tydic.nlp.config.Config;
import com.tydic.se.nlp.common.WordTypeEnum;
import com.tydic.se.nlp.service.component.AddToDictionaryComponent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

public class InitDictionaryConfig
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(InitDictionaryConfig.class);
    private static Map<String, String> pathMap = new ConcurrentHashMap<String, String>();
    @Autowired
    private AddToDictionaryComponent addToDictionaryComponent;
    @Autowired
    private ThreadPoolTaskExecutor asyncServiceExecutor;

    public void run(String ... strings) throws Exception {
        log.info("start executeAsync");
        for (WordTypeEnum typeEnum : WordTypeEnum.values()) {
            InitDictionaryWorker worker = new InitDictionaryWorker(typeEnum);
            this.asyncServiceExecutor.execute((Runnable)worker);
        }
    }

    static {
        pathMap.put(WordTypeEnum.brand.getCode(), Config.brandResDictionaryPath);
        pathMap.put(WordTypeEnum.category.getCode(), Config.categoryResDictionaryPath);
        pathMap.put(WordTypeEnum.vendor.getCode(), Config.vendorResDictionaryPath);
        pathMap.put(WordTypeEnum.model.getCode(), Config.modelResDictionaryPath);
        pathMap.put(WordTypeEnum.specs.getCode(), Config.specsResDictionaryPath);
        pathMap.put(WordTypeEnum.color.getCode(), Config.colorResDictionaryPath);
    }

    class InitDictionaryWorker
    implements Runnable {
        private WordTypeEnum typeEnum;

        InitDictionaryWorker(WordTypeEnum typeEnum) {
            this.typeEnum = typeEnum;
        }

        @Override
        public void run() {
            String code = this.typeEnum.getCode();
            log.info("\u5f00\u59cb\u521d\u59cb\u5316\u4e2a\u6027\u8bcd\u5178:" + code);
            String path = (String)pathMap.get(code);
            if (!StringUtils.isEmpty((Object)path)) {
                InitDictionaryConfig.this.addToDictionaryComponent.addToDic(path, this.typeEnum);
            } else {
                log.info("\u672a\u8bbe\u7f6e\u8bcd\u5178\uff0c\u672c\u6b21\u4e0d\u52a0\u8f7d\u6570\u636e\uff1a" + code);
            }
            log.info("\u521d\u59cb\u5316\u4e2a\u6027\u8bcd\u5178\u5b8c\u6210\uff1a" + code);
        }
    }
}

