/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.participle;

import com.tydic.nlp.corpus.tag.Nature;
import com.tydic.nlp.util.SentencesUtil;
import com.tydic.se.nlp.rsp.ParticipleRspBo;
import com.tydic.se.nlp.service.constant.InitialParticipleSqlEnum;
import com.tydic.se.nlp.service.participle.IParticipleService;
import com.tydic.se.nlp.service.utils.ChineseSymbolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ParticipleServiceImpl
implements IParticipleService {
    private static final Logger log = LoggerFactory.getLogger(ParticipleServiceImpl.class);
    private static String numberReg = "^[+-]?\\d+\\.?\\d*$";
    private static String pattern = "^[\\u4e00-\\u9fa5_a-zA-Z0-9]+$";
    private static String modelReg = "^[0-9A-Z-]{1,}$";
    private static Integer maxLen = 10;
    private static Integer minLen = 1;
    private List<String> symbols = new ArrayList<String>();
    private static String leftBracket = "(";
    private static String rightBracket = ")";
    static final int PAGE_SIZE = 50000;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @PostConstruct
    public void initSymbols() {
        this.symbols.add("\\|");
        this.symbols.add("\\/");
        this.symbols.add("\\-");
        this.symbols.add("\\(");
        this.symbols.add(leftBracket);
        this.symbols.add("\u7cfb\u5217");
    }

    String constructQueryCount(String vendorCode) {
        return InitialParticipleSqlEnum.COMMODITY_COUNT_BY_VENDOR.getSql() + vendorCode + "')";
    }

    String constructQuery(int startPage, String vendorCode) {
        return InitialParticipleSqlEnum.COMMODITY_QUERY_BY_VENDOR.getSql() + vendorCode + "') limit " + startPage * 50000 + "," + 50000;
    }

    Integer calcTotalPage(Integer count) {
        Integer totalPage = count % 50000 == 0 ? Integer.valueOf(count / 50000) : Integer.valueOf(count / 50000 + 1);
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + count + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        return totalPage;
    }

    @Override
    public ParticipleRspBo participle(String vendorCode) {
        ParticipleRspBo rspBo = new ParticipleRspBo();
        Integer counter = (Integer)this.jdbcTemplate.queryForObject(this.constructQueryCount(vendorCode), Integer.class);
        Integer totalPage = this.calcTotalPage(counter);
        for (int i = 0; i < totalPage; ++i) {
            this.participleCommodity(i, vendorCode);
        }
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void participleCommodity(int startPage, String vendorCode) {
        HashSet<String> dicSet = new HashSet<String>();
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(this.constructQuery(startPage, vendorCode));
        while (rs.next()) {
            String name = rs.getString(1);
            if (StringUtils.isEmpty((Object)name)) continue;
            Set<String> words = this.participleName(name);
            dicSet.addAll(words);
        }
        this.doInsertDic(dicSet, vendorCode);
    }

    private void doInsertDic(Set<String> dicSet, String vendorCode) {
        ArrayList nclList = new ArrayList();
        ArrayList nmdList = new ArrayList();
        ArrayList nszList = new ArrayList();
        dicSet.stream().forEach(word -> {
            Object[] seDicBo = new Object[3];
            seDicBo[0] = this.dealWord((String)word);
            seDicBo[2] = vendorCode;
            if (ChineseSymbolUtil.isChinese(word)) {
                seDicBo[1] = Nature.ncl.toString();
                nclList.add(seDicBo);
            } else if (Pattern.compile(modelReg).matcher((CharSequence)word).matches()) {
                seDicBo[1] = Nature.nmd.toString();
                nmdList.add(seDicBo);
            } else {
                seDicBo[1] = Nature.nsz.toString();
                nszList.add(seDicBo);
            }
        });
        this.jdbcTemplate.batchUpdate(InitialParticipleSqlEnum.DIC_INSERT.getSql(), nclList);
        log.info("\u4f9b\u5e94\u5546{},\u63d2\u5165\u6570\u636e\u7c7b\u578b{},\u6761\u6570{}", new Object[]{vendorCode, Nature.ncl.toString(), nclList.size()});
        this.jdbcTemplate.batchUpdate(InitialParticipleSqlEnum.DIC_INSERT.getSql(), nmdList);
        log.info("\u4f9b\u5e94\u5546{},\u63d2\u5165\u6570\u636e\u7c7b\u578b{},\u6761\u6570{}", new Object[]{vendorCode, Nature.nmd.toString(), nmdList.size()});
        this.jdbcTemplate.batchUpdate(InitialParticipleSqlEnum.DIC_INSERT.getSql(), nszList);
        log.info("\u4f9b\u5e94\u5546{},\u63d2\u5165\u6570\u636e\u7c7b\u578b{},\u6761\u6570{}", new Object[]{vendorCode, Nature.nsz.toString(), nszList.size()});
    }

    private String dealWord(String word) {
        if (!word.contains(leftBracket) && word.indexOf(rightBracket) > -1) {
            word = ChineseSymbolUtil.dealSpecialSymbols(word);
        }
        return word;
    }

    private Set<String> participleName(String name) {
        HashSet<String> words = new HashSet<String>();
        List phrases = SentencesUtil.toSentenceList((String)name);
        Set<String> tempSet = new HashSet<String>(phrases);
        do {
            tempSet = this.divisionTerms(tempSet);
            words.addAll(tempSet);
        } while (this.isDivisible(tempSet));
        ArrayList longWord = new ArrayList();
        words.forEach(word -> {
            if (word.length() > maxLen && Pattern.compile(modelReg).matcher((CharSequence)word).matches()) {
                longWord.add(word);
            }
        });
        Set<String> collect = words.stream().filter(word -> !StringUtils.isEmpty((Object)word)).filter(word -> word.length() > minLen).filter(word -> word.length() < maxLen).filter(word -> Pattern.compile(pattern).matcher(String.valueOf(word.charAt(0))).matches()).filter(word -> !Pattern.compile(numberReg).matcher((CharSequence)word).matches()).collect(Collectors.toSet());
        collect.addAll(longWord);
        return collect;
    }

    private Set<String> divisionTerms(Set<String> tempSet) {
        HashSet<String> retSet = new HashSet<String>();
        tempSet.forEach(phrase -> {
            if (ChineseSymbolUtil.isChinese(phrase)) {
                String symbol = this.getContainsSymbol((String)phrase);
                if (!StringUtils.isEmpty((Object)symbol)) {
                    List<String> splits = Arrays.asList(phrase.split(symbol));
                    splits.forEach(split -> retSet.add(ChineseSymbolUtil.dealSpecialSymbols(split)));
                } else {
                    retSet.add(ChineseSymbolUtil.dealSpecialSymbols(phrase));
                }
            } else {
                retSet.add((String)phrase);
            }
        });
        return retSet;
    }

    private boolean isDivisible(Set<String> set) {
        boolean[] divisible = new boolean[]{false};
        set.stream().forEach(s -> {
            if (ChineseSymbolUtil.isChinese(s)) {
                this.symbols.forEach(symbol -> {
                    if (s.contains(symbol = StringEscapeUtils.unescapeJava((String)symbol))) {
                        divisible[0] = true;
                    }
                });
            }
        });
        return divisible[0];
    }

    private String getContainsSymbol(String phrase) {
        for (String sbl : this.symbols) {
            if (!phrase.contains(StringEscapeUtils.unescapeJava((String)sbl))) continue;
            return sbl;
        }
        return null;
    }
}

