/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.impl;

import com.tydic.nlp.model.crf.CRFNERecognizer;
import com.tydic.nlp.model.crf.CRFPOSTagger;
import com.tydic.nlp.model.crf.CRFSegmenter;
import com.tydic.se.nlp.intfs.CRFTrainService;
import com.tydic.se.nlp.req.CRFTrainReqBo;
import com.tydic.se.nlp.rsp.CRFTrainRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CRFTrainServiceImpl
implements CRFTrainService {
    private static final Logger log = LoggerFactory.getLogger(CRFTrainServiceImpl.class);

    public CRFTrainRspBo trainCws(CRFTrainReqBo reqBo) {
        log.info("\u5f00\u59cbcrf\u8bad\u7ec3cws\u6a21\u578b...");
        CRFTrainRspBo rspBo = new CRFTrainRspBo();
        try {
            CRFSegmenter segmenter = new CRFSegmenter(null);
            segmenter.train(reqBo.getCorpusPath(), reqBo.getModelOutPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBo.setCode("1");
            rspBo.setMessage(e.getMessage());
            return rspBo;
        }
        log.info("crf\u8bad\u7ec3cws\u6a21\u578b\u5b8c\u6210\uff0c\u8f93\u51fa\u6587\u4ef6\uff1a" + reqBo.getModelOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public CRFTrainRspBo trainPos(CRFTrainReqBo reqBo) {
        log.info("crf\u5f00\u59cb\u8bad\u7ec3pos\u6a21\u578b...");
        CRFTrainRspBo rspBo = new CRFTrainRspBo();
        try {
            CRFPOSTagger posTagger = new CRFPOSTagger(null);
            posTagger.train(reqBo.getCorpusPath(), reqBo.getModelOutPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBo.setCode("1");
            rspBo.setMessage(e.getMessage());
            return rspBo;
        }
        log.info("crf\u8bad\u7ec3pos\u6a21\u578b\u5b8c\u6210\uff0c\u8f93\u51fa\u6587\u4ef6\uff1a" + reqBo.getModelOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public CRFTrainRspBo trainNer(CRFTrainReqBo reqBo) {
        log.info("crf\u5f00\u59cb\u8bad\u7ec3ner\u6a21\u578b...");
        CRFTrainRspBo rspBo = new CRFTrainRspBo();
        try {
            CRFNERecognizer neRecognizer = new CRFNERecognizer(null);
            neRecognizer.train(reqBo.getCorpusPath(), reqBo.getModelOutPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBo.setCode("1");
            rspBo.setMessage(e.getMessage());
            return rspBo;
        }
        log.info("crf\u8bad\u7ec3ner\u6a21\u578b\u5b8c\u6210\uff0c\u8f93\u51fa\u6587\u4ef6\uff1a" + reqBo.getModelOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }
}

