/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.impl;

import com.tydic.nlp.model.perceptron.CWSTrainer;
import com.tydic.nlp.model.perceptron.NerTrainer;
import com.tydic.nlp.model.perceptron.POSTrainer;
import com.tydic.nlp.model.perceptron.PerceptronTrainer;
import com.tydic.se.nlp.intfs.PerceptronTrainService;
import com.tydic.se.nlp.req.PerceptronTrainReqBo;
import com.tydic.se.nlp.rsp.PerceptronTrainRspBo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PerceptronTrainServiceImpl
implements PerceptronTrainService {
    private static final Logger log = LoggerFactory.getLogger(PerceptronTrainServiceImpl.class);

    public PerceptronTrainRspBo trainCws(PerceptronTrainReqBo reqBo) {
        log.info("perceptron\u5f00\u59cb\u8bad\u7ec3cws\u6a21\u578b...");
        PerceptronTrainRspBo rspBo = new PerceptronTrainRspBo();
        CWSTrainer trainer = new CWSTrainer();
        try {
            PerceptronTrainer.Result result = trainer.train(reqBo.getCorpusPath(), reqBo.getModelOutPath());
            log.info("\u51c6\u786e\u7387F1:{}", (Object)result.getAccuracy());
        }
        catch (IOException e) {
            rspBo.setCode("1");
            rspBo.setMessage(e.getMessage());
            return rspBo;
        }
        log.info("perceptron\u8bad\u7ec3cws\u6a21\u578b\u5b8c\u6210\uff0c\u8f93\u51fa\u6587\u4ef6\uff1a" + reqBo.getModelOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public PerceptronTrainRspBo trainPos(PerceptronTrainReqBo reqBo) {
        log.info("perceptron\u5f00\u59cb\u8bad\u7ec3pos\u6a21\u578b...");
        PerceptronTrainRspBo rspBo = new PerceptronTrainRspBo();
        POSTrainer trainer = new POSTrainer();
        try {
            PerceptronTrainer.Result result = trainer.train(reqBo.getCorpusPath(), reqBo.getModelOutPath());
            log.info("\u51c6\u786e\u7387F1:{}", (Object)result.getAccuracy());
        }
        catch (IOException e) {
            e.printStackTrace();
            rspBo.setCode("1");
            rspBo.setMessage(e.getMessage());
            return rspBo;
        }
        log.info("perceptron\u8bad\u7ec3pos\u6a21\u578b\u5b8c\u6210\uff0c\u8f93\u51fa\u6587\u4ef6\uff1a" + reqBo.getModelOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public PerceptronTrainRspBo trainNer(PerceptronTrainReqBo reqBo) {
        log.info("perceptron\u5f00\u59cb\u8bad\u7ec3ner\u6a21\u578b...");
        PerceptronTrainRspBo rspBo = new PerceptronTrainRspBo();
        NerTrainer trainer = new NerTrainer();
        try {
            PerceptronTrainer.Result result = trainer.train(reqBo.getCorpusPath(), reqBo.getModelOutPath());
            log.info("\u51c6\u786e\u7387F1:F1:{}", (Object)result.getAccuracy());
        }
        catch (IOException e) {
            e.printStackTrace();
            rspBo.setCode("1");
            rspBo.setMessage(e.getMessage());
            return rspBo;
        }
        log.info("perceptron\u8bad\u7ec3ner\u6a21\u578b\u5b8c\u6210\uff0c\u8f93\u51fa\u6587\u4ef6\uff1a" + reqBo.getModelOutPath());
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }
}

