/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.impl;

import com.tydic.nlp.collection.io.IOUtil;
import com.tydic.nlp.corpus.document.CorpusLoader;
import com.tydic.nlp.corpus.document.Document;
import com.tydic.nlp.corpus.document.sentence.Sentence;
import com.tydic.nlp.tokenizer.NlpTokenizer;
import com.tydic.nlp.tokenizer.StandardTokenizer;
import com.tydic.se.nlp.intfs.TokenizerService;
import com.tydic.se.nlp.req.TokenizerReqBo;
import com.tydic.se.nlp.rsp.TokenizerRspBo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TokenizerServiceImpl
implements TokenizerService {
    private static final Logger log = LoggerFactory.getLogger(TokenizerServiceImpl.class);

    public TokenizerRspBo standTokenizer(TokenizerReqBo reqBo) {
        TokenizerRspBo rspBo = new TokenizerRspBo();
        ArrayList lists = new ArrayList();
        List termList = StandardTokenizer.segment((String)reqBo.getText());
        lists.addAll(termList);
        rspBo.setTerms(lists);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public TokenizerRspBo nlpTokenizer(TokenizerReqBo reqBo) {
        TokenizerRspBo rspBo = new TokenizerRspBo();
        ArrayList lists = new ArrayList();
        List termList = NlpTokenizer.segment((String)reqBo.getText());
        lists.addAll(termList);
        rspBo.setTerms(lists);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public TokenizerRspBo tokenizerCorpus(TokenizerReqBo reqBo) {
        TokenizerRspBo rspBo = new TokenizerRspBo();
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            List fileList = IOUtil.fileList((String)reqBo.getInPath());
            for (File file : fileList) {
                String outFile = reqBo.getOutPath() + file.getName();
                log.info("\u5f00\u59cb\u5236\u4f5c\u8bed\u6599\u6587\u4ef6\uff1a" + outFile);
                fos = new FileOutputStream(outFile);
                writer = new OutputStreamWriter(fos);
                Document document = CorpusLoader.convert2Document((File)file);
                List sentences = document.sentenceList;
                for (Sentence sentence : sentences) {
                    List termList = NlpTokenizer.segment((String)sentence.text());
                    String lineWord = termList.toString().replaceAll("(?:\\[|null|\\]| +)", "");
                    try {
                        if (StringUtils.isEmpty((Object)lineWord.trim())) continue;
                        writer.write(lineWord);
                        writer.append("\r\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            writer.close();
            fos.close();
            log.info("\u5236\u4f5c\u8bed\u6599\u6587\u4ef6\u5b8c\u6210!");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }
}

