/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.ner;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.alinlp.model.v20200629.GetNerChEcomRequest;
import com.aliyuncs.alinlp.model.v20200629.GetNerChEcomResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.tydic.se.nlp.req.EntityRecognitionReqBo;
import com.tydic.se.nlp.rsp.EntityRecognitionRspBo;
import com.tydic.se.nlp.service.bo.AliNerRspBo;
import com.tydic.se.nlp.service.ner.INerPolicy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="sys.nlp", name={"type"}, havingValue="AliYun")
public class AliYunNerService
implements INerPolicy {
    private static final String SERVICE_CODE = "alinlp";
    private static final String LEXERID = "ECOM";
    @Value(value="${sys.nlp.region}")
    private String regionId;
    @Value(value="${sys.nlp.accessKey}")
    private String accessKeyId;
    @Value(value="${sys.nlp.secret}")
    private String secret;

    @Override
    public EntityRecognitionRspBo doNer(EntityRecognitionReqBo reqBo) {
        EntityRecognitionRspBo rspBo = new EntityRecognitionRspBo();
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)this.regionId, (String)this.accessKeyId, (String)this.secret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)defaultProfile);
        GetNerChEcomRequest request = new GetNerChEcomRequest();
        request.setServiceCode(SERVICE_CODE);
        request.setText(reqBo.getQueryStr().trim());
        request.setLexerId(LEXERID);
        try {
            GetNerChEcomResponse response = (GetNerChEcomResponse)client.getAcsResponse((AcsRequest)request);
            AliNerRspBo nerRspBo = (AliNerRspBo)JSONObject.parseObject((String)response.getData(), AliNerRspBo.class);
            rspBo.setNerList(nerRspBo.getResult());
            rspBo.setCode("0");
            rspBo.setMessage("\u6210\u529f");
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return rspBo;
    }
}

