/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.ner;

import com.tydic.nlp.seg.common.Term;
import com.tydic.se.nlp.common.NerTypeEnum;
import com.tydic.se.nlp.intfs.TokenizerService;
import com.tydic.se.nlp.req.EntityRecognitionReqBo;
import com.tydic.se.nlp.req.TokenizerReqBo;
import com.tydic.se.nlp.rsp.EntityRecognitionRspBo;
import com.tydic.se.nlp.rsp.NerDataRspBo;
import com.tydic.se.nlp.rsp.TokenizerRspBo;
import com.tydic.se.nlp.service.ner.INerPolicy;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="sys.nlp", name={"type"}, havingValue="tydic")
public class SelfNerService
implements INerPolicy {
    @Autowired
    private TokenizerService tokenizerService;

    @Override
    public EntityRecognitionRspBo doNer(EntityRecognitionReqBo erReqBo) {
        EntityRecognitionRspBo rspBo = new EntityRecognitionRspBo();
        TokenizerReqBo reqBo = new TokenizerReqBo();
        reqBo.setText(erReqBo.getQueryStr().trim());
        TokenizerRspBo tokenizerRspBo = this.tokenizerService.nlpTokenizer(reqBo);
        rspBo.setNerList(this.convertRspBo(tokenizerRspBo.getTerms()));
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private List<NerDataRspBo> convertRspBo(List<Term> terms) {
        ArrayList<NerDataRspBo> nerDataRspBos = new ArrayList<NerDataRspBo>();
        for (Term term : terms) {
            NerDataRspBo rspBo = new NerDataRspBo();
            rspBo.setWord(term.word);
            NerTypeEnum typeEnum = NerTypeEnum.getNerTypeByCode((String)term.nature.toString());
            rspBo.setTag(typeEnum.getName());
            nerDataRspBos.add(rspBo);
        }
        return nerDataRspBos;
    }
}

