/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.component;

import com.tydic.nlp.collection.io.IOUtil;
import com.tydic.nlp.corpus.document.CorpusLoader;
import com.tydic.nlp.corpus.document.Document;
import com.tydic.nlp.corpus.document.sentence.Sentence;
import com.tydic.nlp.corpus.tag.Nature;
import com.tydic.nlp.dictionary.CustomDictionary;
import com.tydic.nlp.util.LexiconUtil;
import com.tydic.se.nlp.common.WordTypeEnum;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AddToDictionaryComponent {
    public void addToDic(String path, WordTypeEnum wordTypeEnum) {
        List fileList = IOUtil.fileList((String)path);
        Nature nature = Nature.fromString((String)wordTypeEnum.getCode());
        for (File file : fileList) {
            Document document = CorpusLoader.convert2Document((File)file);
            List sentenceList = document.sentenceList;
            for (Sentence sentence : sentenceList) {
                String word = sentence.toString().trim();
                if (StringUtils.isEmpty((Object)word)) continue;
                if (Nature.nbd.equals((Object)nature)) {
                    List<String> terms = AddToDictionaryComponent.extractWordByRegular(word);
                    for (String term : terms) {
                        CustomDictionary.insert((String)term.trim(), (String)wordTypeEnum.toString());
                    }
                    continue;
                }
                CustomDictionary.insert((String)word, (String)wordTypeEnum.toString());
            }
        }
    }

    public void addToDic(List<String> terms, WordTypeEnum wordTypeEnum) {
        if (CollectionUtils.isEmpty(terms)) {
            return;
        }
        for (String term : terms) {
            LexiconUtil.setAttribute((String)term.trim(), (String)wordTypeEnum.toString());
        }
    }

    private static List<String> extractWordByRegular(String msg) {
        String[] words = msg.replaceAll("\uff08", "/").replaceAll("\uff09", "").replaceAll("\\(", "/").replaceAll("\\)", "").split("/");
        return Arrays.asList(words);
    }
}

