/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.data;

import com.tydic.nlp.corpus.tag.Nature;
import com.tydic.nlp.util.SentencesUtil;
import com.tydic.se.nlp.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.service.constant.CountSqlEnum;
import com.tydic.se.nlp.service.constant.InitialParticipleSqlEnum;
import com.tydic.se.nlp.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.service.utils.TxtFileUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="queryBrandService")
public class QueryBrandServiceImpl
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryBrandServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "brand";
    private static final int PAGE_SIZE = 50000;
    private List<String> nameList = new ArrayList<String>();
    List<String> dicList = new ArrayList<String>();

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.BRAND.getSql(), Integer.class);
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        String txtFile = reqBo.getOutPath() + "brand" + ".txt";
        String dicFile = reqBo.getOutPath() + "brand" + ".dic";
        log.info("\u5f00\u59cb\u751f\u6210\u8bed\u6599\u6587\u4ef6");
        TxtFileUtil.writeContent(this.nameList, txtFile, true);
        log.info("\u5f00\u59cb\u751f\u6210\u8bcd\u5178\u6587\u4ef6");
        this.doInsertDic();
        TxtFileUtil.writeContent(this.dicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setFileName(dicFile);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.BRAND.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
            while (rs.next()) {
                Object[] dealName;
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name) || ObjectUtils.isEmpty((Object[])(dealName = this.dealBrandMatches(name)))) continue;
                for (Object s : dealName) {
                    this.nameList.add((String)s);
                    this.dicList.addAll(SentencesUtil.toSentenceList((String)s));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doInsertDic() {
        ArrayList dicObjectList = new ArrayList();
        this.dicList.forEach(dic -> {
            Object[] seDicBo = new Object[]{dic, Nature.nbd.toString(), Nature.nbd.toString()};
            dicObjectList.add(seDicBo);
        });
        this.jdbcTemplate.batchUpdate(InitialParticipleSqlEnum.DIC_INSERT.getSql(), dicObjectList);
        log.info("\u63d2\u5165\u54c1\u724c\u6570\u636e\u7c7b\u578b{},\u6761\u6570{}", (Object)Nature.nbd.toString(), (Object)dicObjectList.size());
    }

    private String[] dealBrandMatches(String msg) throws UnsupportedEncodingException {
        String line = msg.replaceAll("\uff08", "").replaceAll("\uff09", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("/", "").replaceAll("-", "").replaceAll(";", "").replaceAll("\uff1b", "").replaceAll("\\+", "").replaceAll(":", "").replaceAll("\\*", "").replaceAll(" ", "").replaceAll("\u00b7", "");
        if (line.matches("[A-Za-z]{2,7}[\\u4e00-\\u9fa5]{2,5}|[\\u4e00-\\u9fa5]{2,5}[A-Za-z]{2,7}")) {
            for (int i = 1; i < line.length() - 3; ++i) {
                if (line.substring(i, i + 1).getBytes("UTF-8").length == line.substring(i + 1, i + 2).getBytes("UTF-8").length) continue;
                String[] str = new String[]{line.substring(0, i + 1), line.substring(i + 1, line.length())};
                return str;
            }
        }
        return null;
    }
}

