/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class TxtFileUtil {
    public static List<String> readLine(String fileUrl) throws IOException {
        ArrayList<String> nameList = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(new File(fileUrl));
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String str;
            while ((str = br.readLine()) != null) {
                nameList.add(str);
            }
        }
        return nameList;
    }

    public static boolean writeContent(List<String> words, String outPath, boolean isAppend) {
        try {
            FileOutputStream fos = new FileOutputStream(outPath, isAppend);
            OutputStreamWriter writer = new OutputStreamWriter(fos);
            for (String word : words) {
                writer.write(word);
                writer.append("\r\n");
            }
            writer.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNameToTxt(String content, String path) {
        OutputStreamWriter writer = null;
        try {
            boolean mkdir;
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            file.createNewFile();
            writer = new FileWriter(file);
            if (null != content) {
                writer.write(content);
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

