/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.config;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ObjectUtils;
import org.springframework.util.concurrent.ListenableFuture;

@Primary
public class VisibleThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(VisibleThreadPoolTaskExecutor.class);
    private static final long serialVersionUID = 8782155982988308307L;

    private void showThreadPoolInfo(String prefix) {
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (ObjectUtils.isEmpty((Object)threadPoolExecutor)) {
            return;
        }
        log.info("{}, {},taskCount [{}], completedTaskCount [{}], activeCount [{}], queueSize [{}]", new Object[]{this.getThreadNamePrefix(), prefix, threadPoolExecutor.getTaskCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getActiveCount(), threadPoolExecutor.getQueue().size()});
    }

    public void execute(Runnable task) {
        this.showThreadPoolInfo("1. do execute");
        super.execute(task);
    }

    public void execute(Runnable task, long startTimeout) {
        this.showThreadPoolInfo("2. do execute timeout");
        super.execute(task, startTimeout);
    }

    public Future<?> submit(Runnable task) {
        this.showThreadPoolInfo("1. do submit");
        return super.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        this.showThreadPoolInfo("2. do submit");
        return super.submit(task);
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        this.showThreadPoolInfo("1. do submitListenable");
        return super.submitListenable(task);
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        this.showThreadPoolInfo("2. do submitListenable");
        return super.submitListenable(task);
    }

    public String toString() {
        return "VisibleThreadPoolTaskExecutor()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VisibleThreadPoolTaskExecutor)) {
            return false;
        }
        VisibleThreadPoolTaskExecutor other = (VisibleThreadPoolTaskExecutor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof VisibleThreadPoolTaskExecutor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

