/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job.bo;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.search.job.bo.AggregationBO;
import com.tydic.se.search.job.bo.DarticipleQueryReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JSONType(orders={"from", "size", "query", "sort", "collapse"})
public class DarticipleQueryBO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(serialize=false)
    private DarticipleQueryReader darticipleQueryReader;
    private Integer from;
    private Integer size;
    private Query query;
    private List<Map<String, Map<String, String>>> sort;
    private AggregationBO aggs;

    public void init(DarticipleQueryReader darticipleQueryReader) {
        this.darticipleQueryReader = darticipleQueryReader;
        this.from = this.darticipleQueryReader.getFrom();
        this.size = this.darticipleQueryReader.getSize();
        this.sort = this.darticipleQueryReader.getSort();
        this.query = new Query();
        this.query.init();
        if (darticipleQueryReader.getIsAggregation().booleanValue()) {
            this.aggs = new AggregationBO();
        }
    }

    public DarticipleQueryReader getDarticipleQueryReader() {
        return this.darticipleQueryReader;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getSize() {
        return this.size;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<Map<String, Map<String, String>>> getSort() {
        return this.sort;
    }

    public AggregationBO getAggs() {
        return this.aggs;
    }

    public void setDarticipleQueryReader(DarticipleQueryReader darticipleQueryReader) {
        this.darticipleQueryReader = darticipleQueryReader;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setSort(List<Map<String, Map<String, String>>> sort) {
        this.sort = sort;
    }

    public void setAggs(AggregationBO aggs) {
        this.aggs = aggs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DarticipleQueryBO)) {
            return false;
        }
        DarticipleQueryBO other = (DarticipleQueryBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DarticipleQueryReader this$darticipleQueryReader = this.getDarticipleQueryReader();
        DarticipleQueryReader other$darticipleQueryReader = other.getDarticipleQueryReader();
        if (this$darticipleQueryReader == null ? other$darticipleQueryReader != null : !((Object)this$darticipleQueryReader).equals(other$darticipleQueryReader)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Query this$query = this.getQuery();
        Query other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        List<Map<String, Map<String, String>>> this$sort = this.getSort();
        List<Map<String, Map<String, String>>> other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        AggregationBO this$aggs = this.getAggs();
        AggregationBO other$aggs = other.getAggs();
        return !(this$aggs == null ? other$aggs != null : !((Object)this$aggs).equals(other$aggs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DarticipleQueryBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DarticipleQueryReader $darticipleQueryReader = this.getDarticipleQueryReader();
        result = result * 59 + ($darticipleQueryReader == null ? 43 : ((Object)$darticipleQueryReader).hashCode());
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Query $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        List<Map<String, Map<String, String>>> $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        AggregationBO $aggs = this.getAggs();
        result = result * 59 + ($aggs == null ? 43 : ((Object)$aggs).hashCode());
        return result;
    }

    public String toString() {
        return "DarticipleQueryBO(darticipleQueryReader=" + this.getDarticipleQueryReader() + ", from=" + this.getFrom() + ", size=" + this.getSize() + ", query=" + this.getQuery() + ", sort=" + this.getSort() + ", aggs=" + this.getAggs() + ")";
    }

    @JSONType(orders={"function_score"})
    public class Query {
        private FunctionScore function_score;

        public void init() {
            this.function_score = new FunctionScore();
            this.function_score.init();
        }

        public FunctionScore getFunction_score() {
            return this.function_score;
        }

        public void setFunction_score(FunctionScore function_score) {
            this.function_score = function_score;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FunctionScore this$function_score = this.getFunction_score();
            FunctionScore other$function_score = other.getFunction_score();
            return !(this$function_score == null ? other$function_score != null : !((Object)this$function_score).equals(other$function_score));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Query;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionScore $function_score = this.getFunction_score();
            result = result * 59 + ($function_score == null ? 43 : ((Object)$function_score).hashCode());
            return result;
        }

        public String toString() {
            return "DarticipleQueryBO.Query(function_score=" + this.getFunction_score() + ")";
        }

        @JSONType(orders={"functions", "score_mode", "boost", "max_boost", "min_score"})
        public class FunctionScore {
            private List<String> functions;
            private String score_mode;
            private InQuery query;
            private Double boost;
            private Double max_boost;
            private Double min_score;

            public void init() {
                this.functions = DarticipleQueryBO.this.darticipleQueryReader.getFunctions();
                this.score_mode = DarticipleQueryBO.this.darticipleQueryReader.getScore_mode();
                this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                this.max_boost = DarticipleQueryBO.this.darticipleQueryReader.getMax_boost();
                this.min_score = DarticipleQueryBO.this.darticipleQueryReader.getMin_score();
                this.query = new InQuery();
                this.query.init();
            }

            public List<String> getFunctions() {
                return this.functions;
            }

            public String getScore_mode() {
                return this.score_mode;
            }

            public InQuery getQuery() {
                return this.query;
            }

            public Double getBoost() {
                return this.boost;
            }

            public Double getMax_boost() {
                return this.max_boost;
            }

            public Double getMin_score() {
                return this.min_score;
            }

            public void setFunctions(List<String> functions) {
                this.functions = functions;
            }

            public void setScore_mode(String score_mode) {
                this.score_mode = score_mode;
            }

            public void setQuery(InQuery query) {
                this.query = query;
            }

            public void setBoost(Double boost) {
                this.boost = boost;
            }

            public void setMax_boost(Double max_boost) {
                this.max_boost = max_boost;
            }

            public void setMin_score(Double min_score) {
                this.min_score = min_score;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FunctionScore)) {
                    return false;
                }
                FunctionScore other = (FunctionScore)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$functions = this.getFunctions();
                List<String> other$functions = other.getFunctions();
                if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
                    return false;
                }
                String this$score_mode = this.getScore_mode();
                String other$score_mode = other.getScore_mode();
                if (this$score_mode == null ? other$score_mode != null : !this$score_mode.equals(other$score_mode)) {
                    return false;
                }
                InQuery this$query = this.getQuery();
                InQuery other$query = other.getQuery();
                if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
                    return false;
                }
                Double this$boost = this.getBoost();
                Double other$boost = other.getBoost();
                if (this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost)) {
                    return false;
                }
                Double this$max_boost = this.getMax_boost();
                Double other$max_boost = other.getMax_boost();
                if (this$max_boost == null ? other$max_boost != null : !((Object)this$max_boost).equals(other$max_boost)) {
                    return false;
                }
                Double this$min_score = this.getMin_score();
                Double other$min_score = other.getMin_score();
                return !(this$min_score == null ? other$min_score != null : !((Object)this$min_score).equals(other$min_score));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FunctionScore;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $functions = this.getFunctions();
                result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
                String $score_mode = this.getScore_mode();
                result = result * 59 + ($score_mode == null ? 43 : $score_mode.hashCode());
                InQuery $query = this.getQuery();
                result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
                Double $boost = this.getBoost();
                result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                Double $max_boost = this.getMax_boost();
                result = result * 59 + ($max_boost == null ? 43 : ((Object)$max_boost).hashCode());
                Double $min_score = this.getMin_score();
                result = result * 59 + ($min_score == null ? 43 : ((Object)$min_score).hashCode());
                return result;
            }

            public String toString() {
                return "DarticipleQueryBO.Query.FunctionScore(functions=" + this.getFunctions() + ", score_mode=" + this.getScore_mode() + ", query=" + this.getQuery() + ", boost=" + this.getBoost() + ", max_boost=" + this.getMax_boost() + ", min_score=" + this.getMin_score() + ")";
            }

            public class InQuery {
                private Bool bool;

                public void init() {
                    this.bool = new Bool();
                    this.bool.init();
                }

                public Bool getBool() {
                    return this.bool;
                }

                public void setBool(Bool bool) {
                    this.bool = bool;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof InQuery)) {
                        return false;
                    }
                    InQuery other = (InQuery)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Bool this$bool = this.getBool();
                    Bool other$bool = other.getBool();
                    return !(this$bool == null ? other$bool != null : !((Object)this$bool).equals(other$bool));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof InQuery;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Bool $bool = this.getBool();
                    result = result * 59 + ($bool == null ? 43 : ((Object)$bool).hashCode());
                    return result;
                }

                public String toString() {
                    return "DarticipleQueryBO.Query.FunctionScore.InQuery(bool=" + this.getBool() + ")";
                }

                public class Bool {
                    private Boolean adjust_pure_negative;
                    private List<Map<String, Object>> must;
                    private List<Map<String, Object>> must_not;
                    private Double boost;

                    public void init() {
                        Terms terms;
                        HashMap<String, Terms> termsMap;
                        this.adjust_pure_negative = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                        this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                        this.must = new ArrayList<Map<String, Object>>();
                        this.must_not = new ArrayList<Map<String, Object>>();
                        if (DarticipleQueryBO.this.darticipleQueryReader.getTermsList() != null) {
                            for (SeTermsBO termsBO : DarticipleQueryBO.this.darticipleQueryReader.getTermsList()) {
                                termsMap = new HashMap<String, Terms>();
                                terms = this.parseTerms(termsBO);
                                if (terms == null) continue;
                                termsMap.put("terms", terms);
                                this.must.add(termsMap);
                            }
                        }
                        if (DarticipleQueryBO.this.darticipleQueryReader.getNotTermsList() != null) {
                            for (SeTermsBO termsBO : DarticipleQueryBO.this.darticipleQueryReader.getNotTermsList()) {
                                termsMap = new HashMap();
                                terms = this.parseTerms(termsBO);
                                if (terms == null) continue;
                                termsMap.put("terms", terms);
                                this.must_not.add(termsMap);
                            }
                        }
                        HashMap<String, InBool> boolMap = new HashMap<String, InBool>();
                        InBool inBool = new InBool();
                        inBool.init();
                        boolMap.put("bool", inBool);
                        this.must.add(boolMap);
                        if (StringUtils.isNotBlank((CharSequence)DarticipleQueryBO.this.darticipleQueryReader.getProperties())) {
                            HashMap<String, PropertiesBool> propertiesBoolMap = new HashMap<String, PropertiesBool>();
                            PropertiesBool propertiesBool = new PropertiesBool();
                            propertiesBool.init();
                            propertiesBoolMap.put("bool", propertiesBool);
                            this.must.add(propertiesBoolMap);
                        }
                    }

                    private Terms parseTerms(SeTermsBO termsBO) {
                        Terms terms = new Terms();
                        terms.init();
                        List<String> values = termsBO.getValueList();
                        if (values != null && values.size() == 1 && values.get(0) instanceof String) {
                            values = Arrays.asList(((String)values.get(0)).split(","));
                        }
                        String lv1CategoryId = "l1_category_id";
                        String lv2CategoryId = "l2_category_id";
                        String lv3CategoryId = "l3_category_id";
                        String lv4CategoryId = "l4mg_category_id";
                        String brandId = "brand_id";
                        String vendorId = "vendor_id";
                        if ("sku_status".equals(termsBO.getName())) {
                            terms.setSku_status(values);
                        } else if ("channel_id".equals(termsBO.getName())) {
                            terms.setChannel_id(values);
                        } else if (vendorId.equals(termsBO.getName())) {
                            terms.setVendor_id(values);
                        } else if (brandId.equals(termsBO.getName())) {
                            terms.setBrand_id(values);
                        } else if (lv1CategoryId.equals(termsBO.getName())) {
                            terms.setL1_category_id(values);
                        } else if (lv2CategoryId.equals(termsBO.getName())) {
                            terms.setL2_category_id(values);
                        } else if (lv3CategoryId.equals(termsBO.getName())) {
                            terms.setL3_category_id(values);
                        } else if (lv4CategoryId.equals(termsBO.getName())) {
                            terms.setL4mg_category_id(values);
                        } else if ("type_id".equals(termsBO.getName())) {
                            terms.setType_id(values);
                        } else if ("type_name".equals(termsBO.getName())) {
                            terms.setType_name(values);
                        } else if ("supplier_shop_id".equals(termsBO.getName())) {
                            terms.setSupplier_shop_id(values);
                        } else if ("supplier_id".equals(termsBO.getName())) {
                            terms.setSupplier_id(values);
                        } else if ("agreement_id".equals(termsBO.getName())) {
                            terms.setAgreement_id(values);
                        } else if ("ext_sku_id".equals(termsBO.getName())) {
                            terms.setExt_sku_id(values);
                        } else if ("upc".equals(termsBO.getName())) {
                            terms.setUpc(values);
                        } else if ("commodity_id".equals(termsBO.getName())) {
                            terms.setCommodity_id(values);
                        } else if ("brand_name".equals(termsBO.getName())) {
                            terms.setBrand_name(values);
                        } else if ("vendor_name".equals(termsBO.getName())) {
                            terms.setVendor_name(values);
                        } else if ("l3_category_name".equals(termsBO.getName())) {
                            terms.setL3_category_name(values);
                        } else if ("properties".equals(termsBO.getName())) {
                            terms.setProperties(values);
                        } else {
                            return null;
                        }
                        return terms;
                    }

                    public Boolean getAdjust_pure_negative() {
                        return this.adjust_pure_negative;
                    }

                    public List<Map<String, Object>> getMust() {
                        return this.must;
                    }

                    public List<Map<String, Object>> getMust_not() {
                        return this.must_not;
                    }

                    public Double getBoost() {
                        return this.boost;
                    }

                    public void setAdjust_pure_negative(Boolean adjust_pure_negative) {
                        this.adjust_pure_negative = adjust_pure_negative;
                    }

                    public void setMust(List<Map<String, Object>> must) {
                        this.must = must;
                    }

                    public void setMust_not(List<Map<String, Object>> must_not) {
                        this.must_not = must_not;
                    }

                    public void setBoost(Double boost) {
                        this.boost = boost;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Bool)) {
                            return false;
                        }
                        Bool other = (Bool)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Boolean this$adjust_pure_negative = this.getAdjust_pure_negative();
                        Boolean other$adjust_pure_negative = other.getAdjust_pure_negative();
                        if (this$adjust_pure_negative == null ? other$adjust_pure_negative != null : !((Object)this$adjust_pure_negative).equals(other$adjust_pure_negative)) {
                            return false;
                        }
                        List<Map<String, Object>> this$must = this.getMust();
                        List<Map<String, Object>> other$must = other.getMust();
                        if (this$must == null ? other$must != null : !((Object)this$must).equals(other$must)) {
                            return false;
                        }
                        List<Map<String, Object>> this$must_not = this.getMust_not();
                        List<Map<String, Object>> other$must_not = other.getMust_not();
                        if (this$must_not == null ? other$must_not != null : !((Object)this$must_not).equals(other$must_not)) {
                            return false;
                        }
                        Double this$boost = this.getBoost();
                        Double other$boost = other.getBoost();
                        return !(this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Bool;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Boolean $adjust_pure_negative = this.getAdjust_pure_negative();
                        result = result * 59 + ($adjust_pure_negative == null ? 43 : ((Object)$adjust_pure_negative).hashCode());
                        List<Map<String, Object>> $must = this.getMust();
                        result = result * 59 + ($must == null ? 43 : ((Object)$must).hashCode());
                        List<Map<String, Object>> $must_not = this.getMust_not();
                        result = result * 59 + ($must_not == null ? 43 : ((Object)$must_not).hashCode());
                        Double $boost = this.getBoost();
                        result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                        return result;
                    }

                    public String toString() {
                        return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool(adjust_pure_negative=" + this.getAdjust_pure_negative() + ", must=" + this.getMust() + ", must_not=" + this.getMust_not() + ", boost=" + this.getBoost() + ")";
                    }

                    @JSONType(orders={"adjust_pure_negative", "should", "boost"})
                    public class PropertiesBool {
                        private Boolean adjust_pure_negative;
                        private List<Map> should;
                        private Double boost;

                        public void init() {
                            this.adjust_pure_negative = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                            this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                            Match match = new Match();
                            match.init();
                            HashMap<String, Match> shouldMap = new HashMap<String, Match>();
                            shouldMap.put("match", match);
                            this.should = new ArrayList<Map>();
                            this.should.add(shouldMap);
                        }

                        public Boolean getAdjust_pure_negative() {
                            return this.adjust_pure_negative;
                        }

                        public List<Map> getShould() {
                            return this.should;
                        }

                        public Double getBoost() {
                            return this.boost;
                        }

                        public void setAdjust_pure_negative(Boolean adjust_pure_negative) {
                            this.adjust_pure_negative = adjust_pure_negative;
                        }

                        public void setShould(List<Map> should) {
                            this.should = should;
                        }

                        public void setBoost(Double boost) {
                            this.boost = boost;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof PropertiesBool)) {
                                return false;
                            }
                            PropertiesBool other = (PropertiesBool)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Boolean this$adjust_pure_negative = this.getAdjust_pure_negative();
                            Boolean other$adjust_pure_negative = other.getAdjust_pure_negative();
                            if (this$adjust_pure_negative == null ? other$adjust_pure_negative != null : !((Object)this$adjust_pure_negative).equals(other$adjust_pure_negative)) {
                                return false;
                            }
                            List<Map> this$should = this.getShould();
                            List<Map> other$should = other.getShould();
                            if (this$should == null ? other$should != null : !((Object)this$should).equals(other$should)) {
                                return false;
                            }
                            Double this$boost = this.getBoost();
                            Double other$boost = other.getBoost();
                            return !(this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof PropertiesBool;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Boolean $adjust_pure_negative = this.getAdjust_pure_negative();
                            result = result * 59 + ($adjust_pure_negative == null ? 43 : ((Object)$adjust_pure_negative).hashCode());
                            List<Map> $should = this.getShould();
                            result = result * 59 + ($should == null ? 43 : ((Object)$should).hashCode());
                            Double $boost = this.getBoost();
                            result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.PropertiesBool(adjust_pure_negative=" + this.getAdjust_pure_negative() + ", should=" + this.getShould() + ", boost=" + this.getBoost() + ")";
                        }

                        @JSONType(orders={"properties"})
                        public class Match {
                            private String properties;

                            public void init() {
                                this.properties = DarticipleQueryBO.this.darticipleQueryReader.getProperties();
                            }

                            public String getProperties() {
                                return this.properties;
                            }

                            public void setProperties(String properties) {
                                this.properties = properties;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Match)) {
                                    return false;
                                }
                                Match other = (Match)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$properties = this.getProperties();
                                String other$properties = other.getProperties();
                                return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Match;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $properties = this.getProperties();
                                result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.PropertiesBool.Match(properties=" + this.getProperties() + ")";
                            }
                        }
                    }

                    @JSONType(orders={"adjust_pure_negative", "should", "boost"})
                    public class InBool {
                        private Boolean adjust_pure_negative;
                        private List<Map> should;
                        private Double boost;

                        public void init() {
                            this.adjust_pure_negative = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                            this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                            MultiMatch multiMatch = new MultiMatch();
                            multiMatch.init();
                            HashMap<String, MultiMatch> shouldMap = new HashMap<String, MultiMatch>();
                            shouldMap.put("multi_match", multiMatch);
                            this.should = new ArrayList<Map>();
                            this.should.add(shouldMap);
                        }

                        public Boolean getAdjust_pure_negative() {
                            return this.adjust_pure_negative;
                        }

                        public List<Map> getShould() {
                            return this.should;
                        }

                        public Double getBoost() {
                            return this.boost;
                        }

                        public void setAdjust_pure_negative(Boolean adjust_pure_negative) {
                            this.adjust_pure_negative = adjust_pure_negative;
                        }

                        public void setShould(List<Map> should) {
                            this.should = should;
                        }

                        public void setBoost(Double boost) {
                            this.boost = boost;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof InBool)) {
                                return false;
                            }
                            InBool other = (InBool)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Boolean this$adjust_pure_negative = this.getAdjust_pure_negative();
                            Boolean other$adjust_pure_negative = other.getAdjust_pure_negative();
                            if (this$adjust_pure_negative == null ? other$adjust_pure_negative != null : !((Object)this$adjust_pure_negative).equals(other$adjust_pure_negative)) {
                                return false;
                            }
                            List<Map> this$should = this.getShould();
                            List<Map> other$should = other.getShould();
                            if (this$should == null ? other$should != null : !((Object)this$should).equals(other$should)) {
                                return false;
                            }
                            Double this$boost = this.getBoost();
                            Double other$boost = other.getBoost();
                            return !(this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof InBool;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Boolean $adjust_pure_negative = this.getAdjust_pure_negative();
                            result = result * 59 + ($adjust_pure_negative == null ? 43 : ((Object)$adjust_pure_negative).hashCode());
                            List<Map> $should = this.getShould();
                            result = result * 59 + ($should == null ? 43 : ((Object)$should).hashCode());
                            Double $boost = this.getBoost();
                            result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.InBool(adjust_pure_negative=" + this.getAdjust_pure_negative() + ", should=" + this.getShould() + ", boost=" + this.getBoost() + ")";
                        }

                        @JSONType(orders={"auto_generate_synonyms_phrase_query", "query", "minimum_should_match", "fuzzy_transpositions", "type", "operator", "slop", "max_expansions", "analyzer", "zero_terms_query", "boost", "prefix_length", "fields"})
                        public class MultiMatch {
                            private Boolean auto_generate_synonyms_phrase_query;
                            private String query;
                            private String minimum_should_match;
                            private Boolean fuzzy_transpositions;
                            private String type;
                            private String operator;
                            private Integer slop;
                            private Integer max_expansions;
                            private String analyzer;
                            private String zero_terms_query;
                            private Double boost;
                            private Integer prefix_length;
                            private List<String> fields;

                            public void init() {
                                this.auto_generate_synonyms_phrase_query = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                                this.query = DarticipleQueryBO.this.darticipleQueryReader.getQuery();
                                this.minimum_should_match = DarticipleQueryBO.this.darticipleQueryReader.getMinimum_should_match();
                                this.type = DarticipleQueryBO.this.darticipleQueryReader.getType();
                                this.operator = DarticipleQueryBO.this.darticipleQueryReader.getOperator();
                                this.slop = DarticipleQueryBO.this.darticipleQueryReader.getSlop();
                                this.max_expansions = DarticipleQueryBO.this.darticipleQueryReader.getMax_expansions();
                                this.analyzer = DarticipleQueryBO.this.darticipleQueryReader.getAnalyzer();
                                this.zero_terms_query = DarticipleQueryBO.this.darticipleQueryReader.getZero_terms_query();
                                this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                                this.prefix_length = DarticipleQueryBO.this.darticipleQueryReader.getPrefix_length();
                                this.fields = DarticipleQueryBO.this.darticipleQueryReader.getFields();
                            }

                            public Boolean getAuto_generate_synonyms_phrase_query() {
                                return this.auto_generate_synonyms_phrase_query;
                            }

                            public String getQuery() {
                                return this.query;
                            }

                            public String getMinimum_should_match() {
                                return this.minimum_should_match;
                            }

                            public Boolean getFuzzy_transpositions() {
                                return this.fuzzy_transpositions;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public String getOperator() {
                                return this.operator;
                            }

                            public Integer getSlop() {
                                return this.slop;
                            }

                            public Integer getMax_expansions() {
                                return this.max_expansions;
                            }

                            public String getAnalyzer() {
                                return this.analyzer;
                            }

                            public String getZero_terms_query() {
                                return this.zero_terms_query;
                            }

                            public Double getBoost() {
                                return this.boost;
                            }

                            public Integer getPrefix_length() {
                                return this.prefix_length;
                            }

                            public List<String> getFields() {
                                return this.fields;
                            }

                            public void setAuto_generate_synonyms_phrase_query(Boolean auto_generate_synonyms_phrase_query) {
                                this.auto_generate_synonyms_phrase_query = auto_generate_synonyms_phrase_query;
                            }

                            public void setQuery(String query) {
                                this.query = query;
                            }

                            public void setMinimum_should_match(String minimum_should_match) {
                                this.minimum_should_match = minimum_should_match;
                            }

                            public void setFuzzy_transpositions(Boolean fuzzy_transpositions) {
                                this.fuzzy_transpositions = fuzzy_transpositions;
                            }

                            public void setType(String type) {
                                this.type = type;
                            }

                            public void setOperator(String operator) {
                                this.operator = operator;
                            }

                            public void setSlop(Integer slop) {
                                this.slop = slop;
                            }

                            public void setMax_expansions(Integer max_expansions) {
                                this.max_expansions = max_expansions;
                            }

                            public void setAnalyzer(String analyzer) {
                                this.analyzer = analyzer;
                            }

                            public void setZero_terms_query(String zero_terms_query) {
                                this.zero_terms_query = zero_terms_query;
                            }

                            public void setBoost(Double boost) {
                                this.boost = boost;
                            }

                            public void setPrefix_length(Integer prefix_length) {
                                this.prefix_length = prefix_length;
                            }

                            public void setFields(List<String> fields) {
                                this.fields = fields;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof MultiMatch)) {
                                    return false;
                                }
                                MultiMatch other = (MultiMatch)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Boolean this$auto_generate_synonyms_phrase_query = this.getAuto_generate_synonyms_phrase_query();
                                Boolean other$auto_generate_synonyms_phrase_query = other.getAuto_generate_synonyms_phrase_query();
                                if (this$auto_generate_synonyms_phrase_query == null ? other$auto_generate_synonyms_phrase_query != null : !((Object)this$auto_generate_synonyms_phrase_query).equals(other$auto_generate_synonyms_phrase_query)) {
                                    return false;
                                }
                                String this$query = this.getQuery();
                                String other$query = other.getQuery();
                                if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                                    return false;
                                }
                                String this$minimum_should_match = this.getMinimum_should_match();
                                String other$minimum_should_match = other.getMinimum_should_match();
                                if (this$minimum_should_match == null ? other$minimum_should_match != null : !this$minimum_should_match.equals(other$minimum_should_match)) {
                                    return false;
                                }
                                Boolean this$fuzzy_transpositions = this.getFuzzy_transpositions();
                                Boolean other$fuzzy_transpositions = other.getFuzzy_transpositions();
                                if (this$fuzzy_transpositions == null ? other$fuzzy_transpositions != null : !((Object)this$fuzzy_transpositions).equals(other$fuzzy_transpositions)) {
                                    return false;
                                }
                                String this$type = this.getType();
                                String other$type = other.getType();
                                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                                    return false;
                                }
                                String this$operator = this.getOperator();
                                String other$operator = other.getOperator();
                                if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                                    return false;
                                }
                                Integer this$slop = this.getSlop();
                                Integer other$slop = other.getSlop();
                                if (this$slop == null ? other$slop != null : !((Object)this$slop).equals(other$slop)) {
                                    return false;
                                }
                                Integer this$max_expansions = this.getMax_expansions();
                                Integer other$max_expansions = other.getMax_expansions();
                                if (this$max_expansions == null ? other$max_expansions != null : !((Object)this$max_expansions).equals(other$max_expansions)) {
                                    return false;
                                }
                                String this$analyzer = this.getAnalyzer();
                                String other$analyzer = other.getAnalyzer();
                                if (this$analyzer == null ? other$analyzer != null : !this$analyzer.equals(other$analyzer)) {
                                    return false;
                                }
                                String this$zero_terms_query = this.getZero_terms_query();
                                String other$zero_terms_query = other.getZero_terms_query();
                                if (this$zero_terms_query == null ? other$zero_terms_query != null : !this$zero_terms_query.equals(other$zero_terms_query)) {
                                    return false;
                                }
                                Double this$boost = this.getBoost();
                                Double other$boost = other.getBoost();
                                if (this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost)) {
                                    return false;
                                }
                                Integer this$prefix_length = this.getPrefix_length();
                                Integer other$prefix_length = other.getPrefix_length();
                                if (this$prefix_length == null ? other$prefix_length != null : !((Object)this$prefix_length).equals(other$prefix_length)) {
                                    return false;
                                }
                                List<String> this$fields = this.getFields();
                                List<String> other$fields = other.getFields();
                                return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof MultiMatch;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Boolean $auto_generate_synonyms_phrase_query = this.getAuto_generate_synonyms_phrase_query();
                                result = result * 59 + ($auto_generate_synonyms_phrase_query == null ? 43 : ((Object)$auto_generate_synonyms_phrase_query).hashCode());
                                String $query = this.getQuery();
                                result = result * 59 + ($query == null ? 43 : $query.hashCode());
                                String $minimum_should_match = this.getMinimum_should_match();
                                result = result * 59 + ($minimum_should_match == null ? 43 : $minimum_should_match.hashCode());
                                Boolean $fuzzy_transpositions = this.getFuzzy_transpositions();
                                result = result * 59 + ($fuzzy_transpositions == null ? 43 : ((Object)$fuzzy_transpositions).hashCode());
                                String $type = this.getType();
                                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                                String $operator = this.getOperator();
                                result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
                                Integer $slop = this.getSlop();
                                result = result * 59 + ($slop == null ? 43 : ((Object)$slop).hashCode());
                                Integer $max_expansions = this.getMax_expansions();
                                result = result * 59 + ($max_expansions == null ? 43 : ((Object)$max_expansions).hashCode());
                                String $analyzer = this.getAnalyzer();
                                result = result * 59 + ($analyzer == null ? 43 : $analyzer.hashCode());
                                String $zero_terms_query = this.getZero_terms_query();
                                result = result * 59 + ($zero_terms_query == null ? 43 : $zero_terms_query.hashCode());
                                Double $boost = this.getBoost();
                                result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                                Integer $prefix_length = this.getPrefix_length();
                                result = result * 59 + ($prefix_length == null ? 43 : ((Object)$prefix_length).hashCode());
                                List<String> $fields = this.getFields();
                                result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.InBool.MultiMatch(auto_generate_synonyms_phrase_query=" + this.getAuto_generate_synonyms_phrase_query() + ", query=" + this.getQuery() + ", minimum_should_match=" + this.getMinimum_should_match() + ", fuzzy_transpositions=" + this.getFuzzy_transpositions() + ", type=" + this.getType() + ", operator=" + this.getOperator() + ", slop=" + this.getSlop() + ", max_expansions=" + this.getMax_expansions() + ", analyzer=" + this.getAnalyzer() + ", zero_terms_query=" + this.getZero_terms_query() + ", boost=" + this.getBoost() + ", prefix_length=" + this.getPrefix_length() + ", fields=" + this.getFields() + ")";
                            }
                        }
                    }

                    public class Terms {
                        private Double boost;
                        private List<String> sku_status;
                        private List<String> channel_id;
                        private List<String> vendor_id;
                        private List<String> brand_id;
                        private List<String> l1_category_id;
                        private List<String> l2_category_id;
                        private List<String> l3_category_id;
                        private List<String> l4mg_category_id;
                        private List<String> type_id;
                        private List<String> type_name;
                        private List<String> supplier_shop_id;
                        private List<String> supplier_id;
                        private List<String> agreement_id;
                        private List<String> ext_sku_id;
                        private List<String> upc;
                        private List<String> commodity_id;
                        private List<String> brand_name;
                        private List<String> vendor_name;
                        private List<String> l3_category_name;
                        private List<String> properties;

                        public void init() {
                            this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                        }

                        public Double getBoost() {
                            return this.boost;
                        }

                        public List<String> getSku_status() {
                            return this.sku_status;
                        }

                        public List<String> getChannel_id() {
                            return this.channel_id;
                        }

                        public List<String> getVendor_id() {
                            return this.vendor_id;
                        }

                        public List<String> getBrand_id() {
                            return this.brand_id;
                        }

                        public List<String> getL1_category_id() {
                            return this.l1_category_id;
                        }

                        public List<String> getL2_category_id() {
                            return this.l2_category_id;
                        }

                        public List<String> getL3_category_id() {
                            return this.l3_category_id;
                        }

                        public List<String> getL4mg_category_id() {
                            return this.l4mg_category_id;
                        }

                        public List<String> getType_id() {
                            return this.type_id;
                        }

                        public List<String> getType_name() {
                            return this.type_name;
                        }

                        public List<String> getSupplier_shop_id() {
                            return this.supplier_shop_id;
                        }

                        public List<String> getSupplier_id() {
                            return this.supplier_id;
                        }

                        public List<String> getAgreement_id() {
                            return this.agreement_id;
                        }

                        public List<String> getExt_sku_id() {
                            return this.ext_sku_id;
                        }

                        public List<String> getUpc() {
                            return this.upc;
                        }

                        public List<String> getCommodity_id() {
                            return this.commodity_id;
                        }

                        public List<String> getBrand_name() {
                            return this.brand_name;
                        }

                        public List<String> getVendor_name() {
                            return this.vendor_name;
                        }

                        public List<String> getL3_category_name() {
                            return this.l3_category_name;
                        }

                        public List<String> getProperties() {
                            return this.properties;
                        }

                        public void setBoost(Double boost) {
                            this.boost = boost;
                        }

                        public void setSku_status(List<String> sku_status) {
                            this.sku_status = sku_status;
                        }

                        public void setChannel_id(List<String> channel_id) {
                            this.channel_id = channel_id;
                        }

                        public void setVendor_id(List<String> vendor_id) {
                            this.vendor_id = vendor_id;
                        }

                        public void setBrand_id(List<String> brand_id) {
                            this.brand_id = brand_id;
                        }

                        public void setL1_category_id(List<String> l1_category_id) {
                            this.l1_category_id = l1_category_id;
                        }

                        public void setL2_category_id(List<String> l2_category_id) {
                            this.l2_category_id = l2_category_id;
                        }

                        public void setL3_category_id(List<String> l3_category_id) {
                            this.l3_category_id = l3_category_id;
                        }

                        public void setL4mg_category_id(List<String> l4mg_category_id) {
                            this.l4mg_category_id = l4mg_category_id;
                        }

                        public void setType_id(List<String> type_id) {
                            this.type_id = type_id;
                        }

                        public void setType_name(List<String> type_name) {
                            this.type_name = type_name;
                        }

                        public void setSupplier_shop_id(List<String> supplier_shop_id) {
                            this.supplier_shop_id = supplier_shop_id;
                        }

                        public void setSupplier_id(List<String> supplier_id) {
                            this.supplier_id = supplier_id;
                        }

                        public void setAgreement_id(List<String> agreement_id) {
                            this.agreement_id = agreement_id;
                        }

                        public void setExt_sku_id(List<String> ext_sku_id) {
                            this.ext_sku_id = ext_sku_id;
                        }

                        public void setUpc(List<String> upc) {
                            this.upc = upc;
                        }

                        public void setCommodity_id(List<String> commodity_id) {
                            this.commodity_id = commodity_id;
                        }

                        public void setBrand_name(List<String> brand_name) {
                            this.brand_name = brand_name;
                        }

                        public void setVendor_name(List<String> vendor_name) {
                            this.vendor_name = vendor_name;
                        }

                        public void setL3_category_name(List<String> l3_category_name) {
                            this.l3_category_name = l3_category_name;
                        }

                        public void setProperties(List<String> properties) {
                            this.properties = properties;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Terms)) {
                                return false;
                            }
                            Terms other = (Terms)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Double this$boost = this.getBoost();
                            Double other$boost = other.getBoost();
                            if (this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost)) {
                                return false;
                            }
                            List<String> this$sku_status = this.getSku_status();
                            List<String> other$sku_status = other.getSku_status();
                            if (this$sku_status == null ? other$sku_status != null : !((Object)this$sku_status).equals(other$sku_status)) {
                                return false;
                            }
                            List<String> this$channel_id = this.getChannel_id();
                            List<String> other$channel_id = other.getChannel_id();
                            if (this$channel_id == null ? other$channel_id != null : !((Object)this$channel_id).equals(other$channel_id)) {
                                return false;
                            }
                            List<String> this$vendor_id = this.getVendor_id();
                            List<String> other$vendor_id = other.getVendor_id();
                            if (this$vendor_id == null ? other$vendor_id != null : !((Object)this$vendor_id).equals(other$vendor_id)) {
                                return false;
                            }
                            List<String> this$brand_id = this.getBrand_id();
                            List<String> other$brand_id = other.getBrand_id();
                            if (this$brand_id == null ? other$brand_id != null : !((Object)this$brand_id).equals(other$brand_id)) {
                                return false;
                            }
                            List<String> this$l1_category_id = this.getL1_category_id();
                            List<String> other$l1_category_id = other.getL1_category_id();
                            if (this$l1_category_id == null ? other$l1_category_id != null : !((Object)this$l1_category_id).equals(other$l1_category_id)) {
                                return false;
                            }
                            List<String> this$l2_category_id = this.getL2_category_id();
                            List<String> other$l2_category_id = other.getL2_category_id();
                            if (this$l2_category_id == null ? other$l2_category_id != null : !((Object)this$l2_category_id).equals(other$l2_category_id)) {
                                return false;
                            }
                            List<String> this$l3_category_id = this.getL3_category_id();
                            List<String> other$l3_category_id = other.getL3_category_id();
                            if (this$l3_category_id == null ? other$l3_category_id != null : !((Object)this$l3_category_id).equals(other$l3_category_id)) {
                                return false;
                            }
                            List<String> this$l4mg_category_id = this.getL4mg_category_id();
                            List<String> other$l4mg_category_id = other.getL4mg_category_id();
                            if (this$l4mg_category_id == null ? other$l4mg_category_id != null : !((Object)this$l4mg_category_id).equals(other$l4mg_category_id)) {
                                return false;
                            }
                            List<String> this$type_id = this.getType_id();
                            List<String> other$type_id = other.getType_id();
                            if (this$type_id == null ? other$type_id != null : !((Object)this$type_id).equals(other$type_id)) {
                                return false;
                            }
                            List<String> this$type_name = this.getType_name();
                            List<String> other$type_name = other.getType_name();
                            if (this$type_name == null ? other$type_name != null : !((Object)this$type_name).equals(other$type_name)) {
                                return false;
                            }
                            List<String> this$supplier_shop_id = this.getSupplier_shop_id();
                            List<String> other$supplier_shop_id = other.getSupplier_shop_id();
                            if (this$supplier_shop_id == null ? other$supplier_shop_id != null : !((Object)this$supplier_shop_id).equals(other$supplier_shop_id)) {
                                return false;
                            }
                            List<String> this$supplier_id = this.getSupplier_id();
                            List<String> other$supplier_id = other.getSupplier_id();
                            if (this$supplier_id == null ? other$supplier_id != null : !((Object)this$supplier_id).equals(other$supplier_id)) {
                                return false;
                            }
                            List<String> this$agreement_id = this.getAgreement_id();
                            List<String> other$agreement_id = other.getAgreement_id();
                            if (this$agreement_id == null ? other$agreement_id != null : !((Object)this$agreement_id).equals(other$agreement_id)) {
                                return false;
                            }
                            List<String> this$ext_sku_id = this.getExt_sku_id();
                            List<String> other$ext_sku_id = other.getExt_sku_id();
                            if (this$ext_sku_id == null ? other$ext_sku_id != null : !((Object)this$ext_sku_id).equals(other$ext_sku_id)) {
                                return false;
                            }
                            List<String> this$upc = this.getUpc();
                            List<String> other$upc = other.getUpc();
                            if (this$upc == null ? other$upc != null : !((Object)this$upc).equals(other$upc)) {
                                return false;
                            }
                            List<String> this$commodity_id = this.getCommodity_id();
                            List<String> other$commodity_id = other.getCommodity_id();
                            if (this$commodity_id == null ? other$commodity_id != null : !((Object)this$commodity_id).equals(other$commodity_id)) {
                                return false;
                            }
                            List<String> this$brand_name = this.getBrand_name();
                            List<String> other$brand_name = other.getBrand_name();
                            if (this$brand_name == null ? other$brand_name != null : !((Object)this$brand_name).equals(other$brand_name)) {
                                return false;
                            }
                            List<String> this$vendor_name = this.getVendor_name();
                            List<String> other$vendor_name = other.getVendor_name();
                            if (this$vendor_name == null ? other$vendor_name != null : !((Object)this$vendor_name).equals(other$vendor_name)) {
                                return false;
                            }
                            List<String> this$l3_category_name = this.getL3_category_name();
                            List<String> other$l3_category_name = other.getL3_category_name();
                            if (this$l3_category_name == null ? other$l3_category_name != null : !((Object)this$l3_category_name).equals(other$l3_category_name)) {
                                return false;
                            }
                            List<String> this$properties = this.getProperties();
                            List<String> other$properties = other.getProperties();
                            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Terms;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Double $boost = this.getBoost();
                            result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                            List<String> $sku_status = this.getSku_status();
                            result = result * 59 + ($sku_status == null ? 43 : ((Object)$sku_status).hashCode());
                            List<String> $channel_id = this.getChannel_id();
                            result = result * 59 + ($channel_id == null ? 43 : ((Object)$channel_id).hashCode());
                            List<String> $vendor_id = this.getVendor_id();
                            result = result * 59 + ($vendor_id == null ? 43 : ((Object)$vendor_id).hashCode());
                            List<String> $brand_id = this.getBrand_id();
                            result = result * 59 + ($brand_id == null ? 43 : ((Object)$brand_id).hashCode());
                            List<String> $l1_category_id = this.getL1_category_id();
                            result = result * 59 + ($l1_category_id == null ? 43 : ((Object)$l1_category_id).hashCode());
                            List<String> $l2_category_id = this.getL2_category_id();
                            result = result * 59 + ($l2_category_id == null ? 43 : ((Object)$l2_category_id).hashCode());
                            List<String> $l3_category_id = this.getL3_category_id();
                            result = result * 59 + ($l3_category_id == null ? 43 : ((Object)$l3_category_id).hashCode());
                            List<String> $l4mg_category_id = this.getL4mg_category_id();
                            result = result * 59 + ($l4mg_category_id == null ? 43 : ((Object)$l4mg_category_id).hashCode());
                            List<String> $type_id = this.getType_id();
                            result = result * 59 + ($type_id == null ? 43 : ((Object)$type_id).hashCode());
                            List<String> $type_name = this.getType_name();
                            result = result * 59 + ($type_name == null ? 43 : ((Object)$type_name).hashCode());
                            List<String> $supplier_shop_id = this.getSupplier_shop_id();
                            result = result * 59 + ($supplier_shop_id == null ? 43 : ((Object)$supplier_shop_id).hashCode());
                            List<String> $supplier_id = this.getSupplier_id();
                            result = result * 59 + ($supplier_id == null ? 43 : ((Object)$supplier_id).hashCode());
                            List<String> $agreement_id = this.getAgreement_id();
                            result = result * 59 + ($agreement_id == null ? 43 : ((Object)$agreement_id).hashCode());
                            List<String> $ext_sku_id = this.getExt_sku_id();
                            result = result * 59 + ($ext_sku_id == null ? 43 : ((Object)$ext_sku_id).hashCode());
                            List<String> $upc = this.getUpc();
                            result = result * 59 + ($upc == null ? 43 : ((Object)$upc).hashCode());
                            List<String> $commodity_id = this.getCommodity_id();
                            result = result * 59 + ($commodity_id == null ? 43 : ((Object)$commodity_id).hashCode());
                            List<String> $brand_name = this.getBrand_name();
                            result = result * 59 + ($brand_name == null ? 43 : ((Object)$brand_name).hashCode());
                            List<String> $vendor_name = this.getVendor_name();
                            result = result * 59 + ($vendor_name == null ? 43 : ((Object)$vendor_name).hashCode());
                            List<String> $l3_category_name = this.getL3_category_name();
                            result = result * 59 + ($l3_category_name == null ? 43 : ((Object)$l3_category_name).hashCode());
                            List<String> $properties = this.getProperties();
                            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.Terms(boost=" + this.getBoost() + ", sku_status=" + this.getSku_status() + ", channel_id=" + this.getChannel_id() + ", vendor_id=" + this.getVendor_id() + ", brand_id=" + this.getBrand_id() + ", l1_category_id=" + this.getL1_category_id() + ", l2_category_id=" + this.getL2_category_id() + ", l3_category_id=" + this.getL3_category_id() + ", l4mg_category_id=" + this.getL4mg_category_id() + ", type_id=" + this.getType_id() + ", type_name=" + this.getType_name() + ", supplier_shop_id=" + this.getSupplier_shop_id() + ", supplier_id=" + this.getSupplier_id() + ", agreement_id=" + this.getAgreement_id() + ", ext_sku_id=" + this.getExt_sku_id() + ", upc=" + this.getUpc() + ", commodity_id=" + this.getCommodity_id() + ", brand_name=" + this.getBrand_name() + ", vendor_name=" + this.getVendor_name() + ", l3_category_name=" + this.getL3_category_name() + ", properties=" + this.getProperties() + ")";
                        }
                    }
                }
            }
        }
    }
}

