/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.config;

import com.tydic.se.search.sort.SearchSortWeightCalculation;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchSortConfig
implements CommandLineRunner {
    private static final Logger LOGGER = LogManager.getLogger(SearchSortConfig.class);
    private File file;
    private Map<String, Double> idf = new HashMap<String, Double>();
    private Map<String, Double> iwf = new HashMap<String, Double>();
    private int wordTotal = 0;
    private int docTotal = 0;
    @Value(value="${search.sort.redisCacheTime:10}")
    private String redisCacheTime;
    @Value(value="${search.sort.redisCacheNumber:3}")
    private String redisCacheNumber;
    @Value(value="${search.sort.irrelevantRatioLowest:0.25}")
    private String irrelevantRatioLowest;
    @Value(value="${search.sort.irrelevantRatioPass:0.75}")
    private String irrelevantRatioPass;
    @Value(value="${search.sort.trainDataPath:null}")
    private String trainDataPath;
    @Value(value="${search.sort.weightWay:default}")
    private String weightWay;
    @Value(value="${search.sort.segLength:50}")
    private String segLength;
    @Value(value="${search.sort.startSortThreshold:0}")
    private String startSortThreshold;
    @Value(value="${search.sort.humanInterventionValue:0.2}")
    private Double humanInterventionValue;
    @Value(value="${search.sort.bitwiseCorrelationWeight:0.9}")
    private Double bitwiseCorrelationWeight;
    @Value(value="${search.sort.redisUse:false}")
    private Boolean redisUse;
    @Value(value="${search.sort.relevanceFieldMatching:null}")
    private String relevanceFieldMatching;
    @Value(value="${search.sort.relevanceChineseFieldMatching:null}")
    private String relevanceChineseFieldMatching;
    @Value(value="${search.sort.SearchRowSize:10}")
    private int searchRowSize;
    @Autowired
    SearchSortWeightCalculation weightCalculation;

    private void initData() {
        this.weightCalculation.TF_IDF(this.file);
        this.idf = this.weightCalculation.getIdf();
        this.iwf = this.weightCalculation.getIwf();
        this.wordTotal = this.weightCalculation.getWordTotal();
        this.docTotal = this.weightCalculation.getDocTotal();
    }

    public void run(String ... args) throws SearchSortException {
        try {
            this.file = new File(this.trainDataPath);
            if ("null".equals(this.trainDataPath) || !this.file.exists()) {
                LOGGER.error("\u521d\u59cb\u5316\u6392\u5e8f\u6743\u503c\u8ba1\u7b97\u9519\u8bef\uff0c\u8def\u5f84\u4e3a{}\uff0c\u6743\u503c\u8ba1\u7b97\u65b9\u5f0f\u88ab\u52a8\u5207\u6362\u4e3adefault", (Object)this.trainDataPath);
                this.weightWay = "default";
            } else {
                this.initData();
            }
        }
        catch (SearchSortException e) {
            throw new SearchSortException("9990", "\u6570\u636e\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public Map<String, Double> getIdf() {
        return this.idf;
    }

    public Map<String, Double> getIwf() {
        return this.iwf;
    }

    public int getWordTotal() {
        return this.wordTotal;
    }

    public int getDocTotal() {
        return this.docTotal;
    }

    public String getRedisCacheTime() {
        return this.redisCacheTime;
    }

    public String getRedisCacheNumber() {
        return this.redisCacheNumber;
    }

    public String getIrrelevantRatioLowest() {
        return this.irrelevantRatioLowest;
    }

    public String getIrrelevantRatioPass() {
        return this.irrelevantRatioPass;
    }

    public String getTrainDataPath() {
        return this.trainDataPath;
    }

    public String getWeightWay() {
        return this.weightWay;
    }

    public String getSegLength() {
        return this.segLength;
    }

    public String getStartSortThreshold() {
        return this.startSortThreshold;
    }

    public Double getHumanInterventionValue() {
        return this.humanInterventionValue;
    }

    public Double getBitwiseCorrelationWeight() {
        return this.bitwiseCorrelationWeight;
    }

    public Boolean getRedisUse() {
        return this.redisUse;
    }

    public String getRelevanceFieldMatching() {
        return this.relevanceFieldMatching;
    }

    public String getRelevanceChineseFieldMatching() {
        return this.relevanceChineseFieldMatching;
    }

    public int getSearchRowSize() {
        return this.searchRowSize;
    }

    public SearchSortWeightCalculation getWeightCalculation() {
        return this.weightCalculation;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setIdf(Map<String, Double> idf) {
        this.idf = idf;
    }

    public void setIwf(Map<String, Double> iwf) {
        this.iwf = iwf;
    }

    public void setWordTotal(int wordTotal) {
        this.wordTotal = wordTotal;
    }

    public void setDocTotal(int docTotal) {
        this.docTotal = docTotal;
    }

    public void setRedisCacheTime(String redisCacheTime) {
        this.redisCacheTime = redisCacheTime;
    }

    public void setRedisCacheNumber(String redisCacheNumber) {
        this.redisCacheNumber = redisCacheNumber;
    }

    public void setIrrelevantRatioLowest(String irrelevantRatioLowest) {
        this.irrelevantRatioLowest = irrelevantRatioLowest;
    }

    public void setIrrelevantRatioPass(String irrelevantRatioPass) {
        this.irrelevantRatioPass = irrelevantRatioPass;
    }

    public void setTrainDataPath(String trainDataPath) {
        this.trainDataPath = trainDataPath;
    }

    public void setWeightWay(String weightWay) {
        this.weightWay = weightWay;
    }

    public void setSegLength(String segLength) {
        this.segLength = segLength;
    }

    public void setStartSortThreshold(String startSortThreshold) {
        this.startSortThreshold = startSortThreshold;
    }

    public void setHumanInterventionValue(Double humanInterventionValue) {
        this.humanInterventionValue = humanInterventionValue;
    }

    public void setBitwiseCorrelationWeight(Double bitwiseCorrelationWeight) {
        this.bitwiseCorrelationWeight = bitwiseCorrelationWeight;
    }

    public void setRedisUse(Boolean redisUse) {
        this.redisUse = redisUse;
    }

    public void setRelevanceFieldMatching(String relevanceFieldMatching) {
        this.relevanceFieldMatching = relevanceFieldMatching;
    }

    public void setRelevanceChineseFieldMatching(String relevanceChineseFieldMatching) {
        this.relevanceChineseFieldMatching = relevanceChineseFieldMatching;
    }

    public void setSearchRowSize(int searchRowSize) {
        this.searchRowSize = searchRowSize;
    }

    public void setWeightCalculation(SearchSortWeightCalculation weightCalculation) {
        this.weightCalculation = weightCalculation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchSortConfig)) {
            return false;
        }
        SearchSortConfig other = (SearchSortConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        Map<String, Double> this$idf = this.getIdf();
        Map<String, Double> other$idf = other.getIdf();
        if (this$idf == null ? other$idf != null : !((Object)this$idf).equals(other$idf)) {
            return false;
        }
        Map<String, Double> this$iwf = this.getIwf();
        Map<String, Double> other$iwf = other.getIwf();
        if (this$iwf == null ? other$iwf != null : !((Object)this$iwf).equals(other$iwf)) {
            return false;
        }
        if (this.getWordTotal() != other.getWordTotal()) {
            return false;
        }
        if (this.getDocTotal() != other.getDocTotal()) {
            return false;
        }
        String this$redisCacheTime = this.getRedisCacheTime();
        String other$redisCacheTime = other.getRedisCacheTime();
        if (this$redisCacheTime == null ? other$redisCacheTime != null : !this$redisCacheTime.equals(other$redisCacheTime)) {
            return false;
        }
        String this$redisCacheNumber = this.getRedisCacheNumber();
        String other$redisCacheNumber = other.getRedisCacheNumber();
        if (this$redisCacheNumber == null ? other$redisCacheNumber != null : !this$redisCacheNumber.equals(other$redisCacheNumber)) {
            return false;
        }
        String this$irrelevantRatioLowest = this.getIrrelevantRatioLowest();
        String other$irrelevantRatioLowest = other.getIrrelevantRatioLowest();
        if (this$irrelevantRatioLowest == null ? other$irrelevantRatioLowest != null : !this$irrelevantRatioLowest.equals(other$irrelevantRatioLowest)) {
            return false;
        }
        String this$irrelevantRatioPass = this.getIrrelevantRatioPass();
        String other$irrelevantRatioPass = other.getIrrelevantRatioPass();
        if (this$irrelevantRatioPass == null ? other$irrelevantRatioPass != null : !this$irrelevantRatioPass.equals(other$irrelevantRatioPass)) {
            return false;
        }
        String this$trainDataPath = this.getTrainDataPath();
        String other$trainDataPath = other.getTrainDataPath();
        if (this$trainDataPath == null ? other$trainDataPath != null : !this$trainDataPath.equals(other$trainDataPath)) {
            return false;
        }
        String this$weightWay = this.getWeightWay();
        String other$weightWay = other.getWeightWay();
        if (this$weightWay == null ? other$weightWay != null : !this$weightWay.equals(other$weightWay)) {
            return false;
        }
        String this$segLength = this.getSegLength();
        String other$segLength = other.getSegLength();
        if (this$segLength == null ? other$segLength != null : !this$segLength.equals(other$segLength)) {
            return false;
        }
        String this$startSortThreshold = this.getStartSortThreshold();
        String other$startSortThreshold = other.getStartSortThreshold();
        if (this$startSortThreshold == null ? other$startSortThreshold != null : !this$startSortThreshold.equals(other$startSortThreshold)) {
            return false;
        }
        Double this$humanInterventionValue = this.getHumanInterventionValue();
        Double other$humanInterventionValue = other.getHumanInterventionValue();
        if (this$humanInterventionValue == null ? other$humanInterventionValue != null : !((Object)this$humanInterventionValue).equals(other$humanInterventionValue)) {
            return false;
        }
        Double this$bitwiseCorrelationWeight = this.getBitwiseCorrelationWeight();
        Double other$bitwiseCorrelationWeight = other.getBitwiseCorrelationWeight();
        if (this$bitwiseCorrelationWeight == null ? other$bitwiseCorrelationWeight != null : !((Object)this$bitwiseCorrelationWeight).equals(other$bitwiseCorrelationWeight)) {
            return false;
        }
        Boolean this$redisUse = this.getRedisUse();
        Boolean other$redisUse = other.getRedisUse();
        if (this$redisUse == null ? other$redisUse != null : !((Object)this$redisUse).equals(other$redisUse)) {
            return false;
        }
        String this$relevanceFieldMatching = this.getRelevanceFieldMatching();
        String other$relevanceFieldMatching = other.getRelevanceFieldMatching();
        if (this$relevanceFieldMatching == null ? other$relevanceFieldMatching != null : !this$relevanceFieldMatching.equals(other$relevanceFieldMatching)) {
            return false;
        }
        String this$relevanceChineseFieldMatching = this.getRelevanceChineseFieldMatching();
        String other$relevanceChineseFieldMatching = other.getRelevanceChineseFieldMatching();
        if (this$relevanceChineseFieldMatching == null ? other$relevanceChineseFieldMatching != null : !this$relevanceChineseFieldMatching.equals(other$relevanceChineseFieldMatching)) {
            return false;
        }
        if (this.getSearchRowSize() != other.getSearchRowSize()) {
            return false;
        }
        SearchSortWeightCalculation this$weightCalculation = this.getWeightCalculation();
        SearchSortWeightCalculation other$weightCalculation = other.getWeightCalculation();
        return !(this$weightCalculation == null ? other$weightCalculation != null : !this$weightCalculation.equals(other$weightCalculation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchSortConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        Map<String, Double> $idf = this.getIdf();
        result = result * 59 + ($idf == null ? 43 : ((Object)$idf).hashCode());
        Map<String, Double> $iwf = this.getIwf();
        result = result * 59 + ($iwf == null ? 43 : ((Object)$iwf).hashCode());
        result = result * 59 + this.getWordTotal();
        result = result * 59 + this.getDocTotal();
        String $redisCacheTime = this.getRedisCacheTime();
        result = result * 59 + ($redisCacheTime == null ? 43 : $redisCacheTime.hashCode());
        String $redisCacheNumber = this.getRedisCacheNumber();
        result = result * 59 + ($redisCacheNumber == null ? 43 : $redisCacheNumber.hashCode());
        String $irrelevantRatioLowest = this.getIrrelevantRatioLowest();
        result = result * 59 + ($irrelevantRatioLowest == null ? 43 : $irrelevantRatioLowest.hashCode());
        String $irrelevantRatioPass = this.getIrrelevantRatioPass();
        result = result * 59 + ($irrelevantRatioPass == null ? 43 : $irrelevantRatioPass.hashCode());
        String $trainDataPath = this.getTrainDataPath();
        result = result * 59 + ($trainDataPath == null ? 43 : $trainDataPath.hashCode());
        String $weightWay = this.getWeightWay();
        result = result * 59 + ($weightWay == null ? 43 : $weightWay.hashCode());
        String $segLength = this.getSegLength();
        result = result * 59 + ($segLength == null ? 43 : $segLength.hashCode());
        String $startSortThreshold = this.getStartSortThreshold();
        result = result * 59 + ($startSortThreshold == null ? 43 : $startSortThreshold.hashCode());
        Double $humanInterventionValue = this.getHumanInterventionValue();
        result = result * 59 + ($humanInterventionValue == null ? 43 : ((Object)$humanInterventionValue).hashCode());
        Double $bitwiseCorrelationWeight = this.getBitwiseCorrelationWeight();
        result = result * 59 + ($bitwiseCorrelationWeight == null ? 43 : ((Object)$bitwiseCorrelationWeight).hashCode());
        Boolean $redisUse = this.getRedisUse();
        result = result * 59 + ($redisUse == null ? 43 : ((Object)$redisUse).hashCode());
        String $relevanceFieldMatching = this.getRelevanceFieldMatching();
        result = result * 59 + ($relevanceFieldMatching == null ? 43 : $relevanceFieldMatching.hashCode());
        String $relevanceChineseFieldMatching = this.getRelevanceChineseFieldMatching();
        result = result * 59 + ($relevanceChineseFieldMatching == null ? 43 : $relevanceChineseFieldMatching.hashCode());
        result = result * 59 + this.getSearchRowSize();
        SearchSortWeightCalculation $weightCalculation = this.getWeightCalculation();
        result = result * 59 + ($weightCalculation == null ? 43 : $weightCalculation.hashCode());
        return result;
    }

    public String toString() {
        return "SearchSortConfig(file=" + this.getFile() + ", idf=" + this.getIdf() + ", iwf=" + this.getIwf() + ", wordTotal=" + this.getWordTotal() + ", docTotal=" + this.getDocTotal() + ", redisCacheTime=" + this.getRedisCacheTime() + ", redisCacheNumber=" + this.getRedisCacheNumber() + ", irrelevantRatioLowest=" + this.getIrrelevantRatioLowest() + ", irrelevantRatioPass=" + this.getIrrelevantRatioPass() + ", trainDataPath=" + this.getTrainDataPath() + ", weightWay=" + this.getWeightWay() + ", segLength=" + this.getSegLength() + ", startSortThreshold=" + this.getStartSortThreshold() + ", humanInterventionValue=" + this.getHumanInterventionValue() + ", bitwiseCorrelationWeight=" + this.getBitwiseCorrelationWeight() + ", redisUse=" + this.getRedisUse() + ", relevanceFieldMatching=" + this.getRelevanceFieldMatching() + ", relevanceChineseFieldMatching=" + this.getRelevanceChineseFieldMatching() + ", searchRowSize=" + this.getSearchRowSize() + ", weightCalculation=" + this.getWeightCalculation() + ")";
    }
}

