/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.impl;

import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.ability.bo.SeEntityCacheBO;
import com.tydic.se.search.ability.bo.SeEntityCacheRspBO;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.SeQueryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="seQueryService")
public class SeQueryServiceImpl
implements SeQueryService {
    @Autowired
    private SeQueryBuilder seQueryBuilder;
    @Autowired
    private SeEntityCache seEntityCache;

    public ExecuteSearchRspBO search(ExecuteSearchReqBO executeSearchReqBO) {
        return this.seQueryBuilder.executeSearch(executeSearchReqBO);
    }

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        return this.seQueryBuilder.simpleSearch(executeSearchReqBO);
    }

    public SeEntityCacheRspBO refreshCache() {
        SeEntityCacheBO seEntityCacheBO = this.seEntityCache.init();
        SeEntityCacheRspBO rspBO = new SeEntityCacheRspBO();
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        rspBO.setData(seEntityCacheBO);
        return rspBO;
    }

    public ExecuteSearchRspBO categoryList(ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setIsAggregation(Boolean.valueOf(true));
        ExecuteSearchRspBO executeSearchRspBO = this.search(executeSearchReqBO);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        executeSearchRspBO.setResult(null);
        executeSearchRspBO.setQueryBody(null);
        List<SeQueryFilterBO> queryFilterList = this.parseQueryFilterList(esResultBO);
        executeSearchRspBO.setQueryFilterList(queryFilterList);
        List<SeQueryPropertyBO> queryPropertyList = this.parseQueryPropertyList(esResultBO);
        executeSearchRspBO.setQueryPropertyList(queryPropertyList);
        return executeSearchRspBO;
    }

    private SeQueryFilterBO parseQueryFilter(SeEsResultBO.Aggregations.Category category, String filterId, String filterName) {
        SeQueryFilterBO seQueryFilterBO = new SeQueryFilterBO();
        seQueryFilterBO.setFilterId(filterId);
        seQueryFilterBO.setFilterName(filterName);
        ArrayList<String> filterValues = new ArrayList<String>();
        for (SeEsResultBO.Aggregations.Category.Buckets buckets : category.getBuckets()) {
            filterValues.add(buckets.getKey());
        }
        seQueryFilterBO.setFilterValues(filterValues);
        return seQueryFilterBO;
    }

    private List<SeQueryFilterBO> parseQueryFilterList(SeEsResultBO esResultBO) {
        SeEsResultBO.Aggregations.Category group_by_vendor_name = esResultBO.getAggregations().getGroup_by_vendor_name();
        SeEsResultBO.Aggregations.Category group_by_l3_category_name = esResultBO.getAggregations().getGroup_by_l3_category_name();
        SeEsResultBO.Aggregations.Category group_by_brand_name = esResultBO.getAggregations().getGroup_by_brand_name();
        SeQueryFilterBO vendor_id_name = this.parseQueryFilter(group_by_vendor_name, "vendor_name", "\u4f9b\u5e94\u5546\u540d\u79f0");
        SeQueryFilterBO l3_category_id_name = this.parseQueryFilter(group_by_l3_category_name, "l3_category_name", "\u4e09\u7ea7\u7c7b\u76ee\u540d\u79f0");
        SeQueryFilterBO brand_id_name = this.parseQueryFilter(group_by_brand_name, "brand_name", "\u54c1\u724c\u540d\u79f0");
        ArrayList<SeQueryFilterBO> seQueryFilterBO = new ArrayList<SeQueryFilterBO>();
        seQueryFilterBO.add(vendor_id_name);
        seQueryFilterBO.add(l3_category_id_name);
        seQueryFilterBO.add(brand_id_name);
        return seQueryFilterBO;
    }

    private List<SeQueryPropertyBO> parseQueryPropertyList(SeEsResultBO esResultBO) {
        HashMap<String, Set<String>> queryPropertyMap = new HashMap<String, Set<String>>();
        for (SeEsResultBO.Hits.InHits inHits : esResultBO.getHits().getHits()) {
            Set propertyValues;
            SeQuerySkuBO seQuerySkuBO = inHits.get_source();
            if (StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getTexture())) {
                propertyValues = null;
                propertyValues = queryPropertyMap.containsKey("texture") ? (Set)queryPropertyMap.get("texture") : new HashSet();
                propertyValues.add(seQuerySkuBO.getTexture());
                queryPropertyMap.put("texture", propertyValues);
            }
            if (StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getModel())) {
                propertyValues = null;
                propertyValues = queryPropertyMap.containsKey("model") ? (Set)queryPropertyMap.get("model") : new HashSet();
                propertyValues.add(seQuerySkuBO.getModel());
                queryPropertyMap.put("model", propertyValues);
            }
            if (StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getSpec())) {
                propertyValues = null;
                propertyValues = queryPropertyMap.containsKey("spec") ? (Set)queryPropertyMap.get("spec") : new HashSet();
                propertyValues.add(seQuerySkuBO.getSpec());
                queryPropertyMap.put("spec", propertyValues);
            }
            if (!StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getMeasureName())) continue;
            propertyValues = null;
            propertyValues = queryPropertyMap.containsKey("measure_name") ? (Set)queryPropertyMap.get("measure_name") : new HashSet();
            propertyValues.add(seQuerySkuBO.getMeasureName());
            queryPropertyMap.put("measure_name", propertyValues);
        }
        ArrayList<SeQueryPropertyBO> queryPropertyList = new ArrayList<SeQueryPropertyBO>();
        for (String key : queryPropertyMap.keySet()) {
            SeQueryPropertyBO seQueryPropertyBO = new SeQueryPropertyBO();
            seQueryPropertyBO.setPropertyId(key);
            String propertyName = this.parseQueryPropertyName(key);
            seQueryPropertyBO.setPropertyName(propertyName);
            ArrayList propertyValues = new ArrayList((Collection)queryPropertyMap.get(key));
            seQueryPropertyBO.setPropertyValues(propertyValues);
            queryPropertyList.add(seQueryPropertyBO);
        }
        return queryPropertyList;
    }

    private String parseQueryPropertyName(String name) {
        if ("texture".equals(name)) {
            return "\u6750\u8d28";
        }
        if ("model".equals(name)) {
            return "\u578b\u53f7";
        }
        if ("spec".equals(name)) {
            return "\u8bf4\u660e";
        }
        if ("measure_name".equals(name)) {
            return "\u5355\u4f4d";
        }
        return "\u5176\u5b83";
    }
}

