/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.SeEsOldResultBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.nlp.intfs.EntityRecognitionService;
import com.tydic.se.nlp.req.EntityRecognitionReqBo;
import com.tydic.se.nlp.rsp.EntityRecognitionRspBo;
import com.tydic.se.nlp.rsp.NerDataRspBo;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.constants.SeSearchConstants;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.bo.DarticipleQueryBO;
import com.tydic.se.search.job.bo.DarticipleQueryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SeQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SeQueryBuilder.class);
    @Value(value="${es.index_name:commodity_index}")
    private String INDEX_NAME;
    @Value(value="${es.config.addresses}")
    private String ADDRESSES;
    @Value(value="${es.config.username}")
    private String USERNAME;
    @Value(value="${es.config.password}")
    private String PASSWORD;
    @Value(value="${es.fields:commodity_name^10.0,sku_name^10.0,brand_name^12.0,type_name^5.0,supplier_name^10.0,l2_category_name^7.0,l3_category_name^10.0,l4mg_category_name^1.0,sku_code^5.0,ext_sku_id^5.0,figure^1.0,manufacturer^1.0,material_name^1.0,model^1.0,properties^1.0}")
    private String FIELDS_STR;
    @Autowired
    private EntityRecognitionService entityRecognitionService;

    public RestClient getRestClient() {
        String[] addr = this.ADDRESSES.split(":");
        String hostname = addr[0];
        Integer port = 9200;
        if (addr.length > 1) {
            port = Integer.valueOf(addr[1]);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.USERNAME, this.PASSWORD));
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(hostname, port.intValue(), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
            final /* synthetic */ CredentialsProvider val$credentialsProvider;
            {
                this.val$credentialsProvider = credentialsProvider;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                return httpClientBuilder;
            }
        });
        RestClient restClient = builder.build();
        return restClient;
    }

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        if (executeSearchReqBO.getQueryStr() == null) {
            executeSearchReqBO.setQueryStr("");
        }
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        darticipleQueryReader.setQuery(executeSearchReqBO.getQueryStr());
        darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        darticipleQueryReader.setZero_terms_query("NONE");
        darticipleQueryReader.setMinimum_should_match("55%");
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        darticipleQueryBO.init(darticipleQueryReader);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = this.postEsSearch(esQueryBody);
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setResult(esResult);
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ExecuteSearchRspBO executeSearch(ExecuteSearchReqBO executeSearchReqBO) {
        return this.executeSearch(executeSearchReqBO, null);
    }

    private ExecuteSearchRspBO executeSearch(ExecuteSearchReqBO executeSearchReqBO, Map<String, String> entityMap) {
        if (executeSearchReqBO.getQueryStr() == null) {
            executeSearchReqBO.setQueryStr("");
        }
        entityMap = entityMap == null ? this.parseEntityMap(executeSearchReqBO.getQueryStr(), executeSearchReqBO.getMustTermsList()) : this.reduceEntityMap(entityMap);
        List<SeTermsBO> tempTermsList = this.parseTempTermsList(entityMap);
        entityMap = this.matchTerms(entityMap, tempTermsList);
        DarticipleQueryBO darticipleQueryBO = this.initDarticipleQueryBO(executeSearchReqBO, entityMap, tempTermsList);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = this.postEsSearch(esQueryBody);
        SeEsResultBO esResultBO = new SeEsResultBO();
        try {
            esResultBO = (SeEsResultBO)JSONObject.parseObject((String)esResult, SeEsResultBO.class);
        }
        catch (Exception e) {
            SeEsOldResultBO seEsOldResultBO = (SeEsOldResultBO)JSONObject.parseObject((String)esResult, SeEsOldResultBO.class);
            Integer totalValue = seEsOldResultBO.getHits().getTotal();
            seEsOldResultBO.getHits().setTotal(null);
            String newEsResult = JSON.toJSONString((Object)seEsOldResultBO);
            esResultBO = (SeEsResultBO)JSONObject.parseObject((String)newEsResult, SeEsResultBO.class);
            SeEsResultBO.Hits.Total total = new SeEsResultBO.Hits.Total(esResultBO.getHits());
            total.setValue(totalValue);
            esResultBO.getHits().setTotal(total);
        }
        if (this.queryAgain(esResultBO, entityMap)) {
            return this.executeSearch(executeSearchReqBO, entityMap);
        }
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setEsResultBO(esResultBO);
        rspBO.setResult(esResult);
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    private Map<String, String> parseEntityMap(String queryStr, List<SeTermsBO> mustTermsList) {
        EntityRecognitionReqBo entityRecognitionReqBo = new EntityRecognitionReqBo();
        entityRecognitionReqBo.setQueryStr(queryStr);
        EntityRecognitionRspBo entityRecognitionRspBo = this.entityRecognitionService.doNer(entityRecognitionReqBo);
        HashMap<String, String> entityMap = new HashMap<String, String>();
        String common = "common";
        entityMap.put(common, queryStr);
        if (entityRecognitionRspBo != null && entityRecognitionRspBo.getNerList() != null) {
            for (NerDataRspBo nerDataRspBo : entityRecognitionRspBo.getNerList()) {
                if (this.verifyEffectEntity(SeSearchConstants.EntityRecognition.CATEGORY_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) {
                    String lv2Category = "l2_category";
                    if (entityMap.containsKey(lv2Category)) {
                        entityMap.put(lv2Category, (String)entityMap.get(lv2Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv2Category, nerDataRspBo.getWord());
                    }
                    String lv3Category = "l3_category";
                    if (entityMap.containsKey(lv3Category)) {
                        entityMap.put(lv3Category, (String)entityMap.get(lv3Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv3Category, nerDataRspBo.getWord());
                    }
                    String lv4Category = "l4mg_category";
                    if (entityMap.containsKey(lv4Category)) {
                        entityMap.put(lv4Category, (String)entityMap.get(lv4Category) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(lv4Category, nerDataRspBo.getWord());
                    continue;
                }
                if (this.verifyEffectEntity(SeSearchConstants.EntityRecognition.BRAND_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) {
                    String brand = "brand";
                    if (entityMap.containsKey(brand)) {
                        entityMap.put(brand, (String)entityMap.get(brand) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(brand, nerDataRspBo.getWord());
                    continue;
                }
                if (!this.verifyEffectEntity(SeSearchConstants.EntityRecognition.VENDOR_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) continue;
                String vendor = "vendor";
                if (entityMap.containsKey(vendor)) {
                    entityMap.put(vendor, (String)entityMap.get(vendor) + "," + nerDataRspBo.getWord());
                    continue;
                }
                entityMap.put(vendor, nerDataRspBo.getWord());
            }
        }
        return entityMap;
    }

    private Boolean verifyEffectEntity(List<String> list, String tag, List<SeTermsBO> mustTermsList) {
        if (list.contains(tag)) {
            if (mustTermsList != null && this.containsName(mustTermsList, tag)) {
                return false;
            }
            return true;
        }
        return false;
    }

    private List<SeTermsBO> parseTempTermsList(Map<String, String> entityMap) {
        HashMap<String, SeTermsBO> termsBOMap = new HashMap<String, SeTermsBO>();
        for (String key : entityMap.keySet()) {
            SeTermsBO termsBO;
            String[] categoryArr = entityMap.get(key).split(",");
            Map<String, String> singleMap = SeEntityCache.getEntityCacheMap().get(key);
            if (categoryArr == null || singleMap == null || (termsBO = this.parseTerms(key, categoryArr, singleMap)) == null) continue;
            termsBOMap.put(key, termsBO);
        }
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        if (termsBOMap.containsKey(lv4Category)) {
            termsBOMap.remove(lv2Category);
            termsBOMap.remove(lv3Category);
        } else if (termsBOMap.containsKey(lv3Category)) {
            termsBOMap.remove(lv2Category);
        }
        ArrayList<SeTermsBO> termsBOList = new ArrayList<SeTermsBO>();
        for (SeTermsBO termsBO : termsBOMap.values()) {
            termsBOList.add(termsBO);
        }
        return termsBOList;
    }

    private SeTermsBO parseTerms(String key, String[] categoryArr, Map<String, String> cacheMap) {
        ArrayList<String> valueList = new ArrayList<String>();
        String valueStr = "";
        for (String category : categoryArr) {
            if (!cacheMap.containsKey(category)) continue;
            valueStr = StringUtils.isNotBlank((CharSequence)valueStr) ? valueStr + "," + cacheMap.get(category) : cacheMap.get(category);
        }
        valueList.add(valueStr);
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            SeTermsBO termsBO = new SeTermsBO(key + "_id", valueList);
            return termsBO;
        }
        return null;
    }

    private Map<String, String> matchTerms(Map<String, String> entityMap, List<SeTermsBO> tempTermsList) {
        String value;
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(lv3Category) && !this.containsName(tempTermsList, lv2Category) && !this.containsName(tempTermsList, lv3Category) && !this.containsName(tempTermsList, lv4Category)) {
            value = entityMap.get(lv3Category);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(brand) && !this.containsName(tempTermsList, brand)) {
            value = entityMap.get(brand);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(vendor) && !this.containsName(tempTermsList, vendor)) {
            value = entityMap.get(vendor);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        return entityMap;
    }

    private DarticipleQueryBO initDarticipleQueryBO(ExecuteSearchReqBO executeSearchReqBO, Map<String, String> entityMap, List<SeTermsBO> tempTermsList) {
        String[] fieldArr;
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        if (executeSearchReqBO.getFrom() != null) {
            darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        }
        if (executeSearchReqBO.getSize() != null) {
            darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        }
        darticipleQueryReader.setIsAggregation(executeSearchReqBO.getIsAggregation());
        List termsList = null;
        termsList = executeSearchReqBO.getMustTermsList() != null ? executeSearchReqBO.getMustTermsList() : darticipleQueryReader.getTermsList();
        termsList.addAll(tempTermsList);
        darticipleQueryReader.setTermsList(termsList);
        List notTermsList = null;
        notTermsList = executeSearchReqBO.getMustNotTermsList() != null ? executeSearchReqBO.getMustNotTermsList() : executeSearchReqBO.getMustNotTermsList();
        darticipleQueryReader.setNotTermsList(notTermsList);
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : fieldArr = this.FIELDS_STR.split(",")) {
            int lastIndex = field.lastIndexOf("_");
            String name = field;
            if (lastIndex > 0) {
                name = field.substring(0, lastIndex);
            }
            boolean notExistFlag = true;
            if (termsList != null) {
                for (SeTermsBO termsBO : termsList) {
                    if (!termsBO.getName().contains(name)) continue;
                    notExistFlag = false;
                    break;
                }
            }
            if (!notExistFlag) continue;
            fields.add(field);
        }
        darticipleQueryReader.setFields(fields);
        darticipleQueryReader.setQuery(entityMap.get("common"));
        darticipleQueryReader.setProperties(executeSearchReqBO.getProperties());
        darticipleQueryBO.init(darticipleQueryReader);
        return darticipleQueryBO;
    }

    private boolean containsName(List<SeTermsBO> tempTermsList, String name) {
        for (SeTermsBO termsBO : tempTermsList) {
            if (!termsBO.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> reduceEntityMap(Map<String, String> entityMap) {
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(brand)) {
            entityMap.remove(brand);
            return entityMap;
        }
        if (entityMap.containsKey(vendor)) {
            entityMap.remove(vendor);
            return entityMap;
        }
        if (entityMap.containsKey(lv4Category)) {
            entityMap.remove(lv4Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv3Category)) {
            entityMap.remove(lv3Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv2Category)) {
            entityMap.remove(lv2Category);
            return entityMap;
        }
        entityMap = new HashMap<String, String>();
        entityMap.put(common, "");
        return entityMap;
    }

    private boolean queryAgain(SeEsResultBO esResultBO, Map<String, String> entityMap) {
        if (esResultBO != null && esResultBO.getHits() != null && esResultBO.getHits().getTotal().getValue() == 0) {
            return entityMap != null && entityMap.size() > 1;
        }
        return false;
    }

    private String parseContent(DarticipleQueryBO darticipleQueryBO) {
        String content = JSON.toJSONString((Object)darticipleQueryBO);
        return content;
    }

    private String postEsSearch(String esQueryBody) {
        String esResult = "";
        String method = "POST";
        String endpoint = new StringBuffer().append("/").append(this.INDEX_NAME).append("/_search").toString();
        Request request = new Request(method, endpoint);
        request.setJsonEntity(esQueryBody);
        RestClient restClient = this.getRestClient();
        try {
            Response response = restClient.performRequest(request);
            esResult = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SeBusinessException("\u8c03\u7528es\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            try {
                restClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return esResult;
    }
}

