/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.nlp.intfs.EntityRecognitionService;
import com.tydic.se.nlp.req.EntityRecognitionReqBo;
import com.tydic.se.nlp.rsp.EntityRecognitionRspBo;
import com.tydic.se.nlp.rsp.NerDataRspBo;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.constants.SeSearchConstants;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.bo.DarticipleQueryBO;
import com.tydic.se.search.job.bo.DarticipleQueryReader;
import com.tydic.se.search.job.bo.EsResultBO;
import com.tydic.se.search.job.bo.TermsBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SeQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SeQueryBuilder.class);
    private static RestClient restClient;
    @Value(value="${es.index_name:commodity_index}")
    private String INDEX_NAME;
    @Value(value="${es.config.addresses}")
    private String ADDRESSES;
    @Value(value="${es.config.username}")
    private String USERNAME;
    @Value(value="${es.config.password}")
    private String PASSWORD;
    @Value(value="${es.fields}")
    private String FIELDS_STR;
    @Autowired
    private EntityRecognitionService entityRecognitionService;

    public RestClient getRestClient() {
        if (restClient == null) {
            String[] addr = this.ADDRESSES.split(":");
            String hostname = addr[0];
            Integer port = 9200;
            if (addr.length > 1) {
                port = Integer.valueOf(addr[1]);
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(hostname, port.intValue(), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(SeQueryBuilder.this.USERNAME, SeQueryBuilder.this.PASSWORD));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    return httpClientBuilder;
                }
            });
            restClient = builder.build();
        }
        return restClient;
    }

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        if (executeSearchReqBO.getQueryStr() == null) {
            executeSearchReqBO.setQueryStr("");
        }
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        darticipleQueryReader.setQuery(executeSearchReqBO.getQueryStr());
        darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        darticipleQueryReader.setZero_terms_query("NONE");
        darticipleQueryReader.setMinimum_should_match("55%");
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        darticipleQueryBO.init(darticipleQueryReader);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = this.postEsSearch(esQueryBody);
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setResult(esResult);
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ExecuteSearchRspBO executeSearch(ExecuteSearchReqBO executeSearchReqBO) {
        return this.executeSearch(executeSearchReqBO, null);
    }

    private ExecuteSearchRspBO executeSearch(ExecuteSearchReqBO executeSearchReqBO, Map<String, String> entityMap) {
        entityMap = entityMap == null ? this.parseEntityMap(executeSearchReqBO.getQueryStr()) : this.reduceEntityMap(entityMap);
        List<TermsBO> tempTermsList = this.parseTempTermsList(entityMap);
        DarticipleQueryBO darticipleQueryBO = this.initDarticipleQueryBO(executeSearchReqBO, entityMap = this.matchTerms(entityMap, tempTermsList), tempTermsList);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = this.postEsSearch(esQueryBody);
        if (this.queryAgain(esResult)) {
            return this.executeSearch(executeSearchReqBO, entityMap);
        }
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setResult(esResult);
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    private Map<String, String> parseEntityMap(String queryStr) {
        EntityRecognitionReqBo entityRecognitionReqBo = new EntityRecognitionReqBo();
        entityRecognitionReqBo.setQueryStr(queryStr);
        EntityRecognitionRspBo entityRecognitionRspBo = this.entityRecognitionService.doNer(entityRecognitionReqBo);
        HashMap<String, String> entityMap = new HashMap<String, String>();
        String common = "common";
        entityMap.put(common, "");
        if (entityRecognitionRspBo != null && entityRecognitionRspBo.getNerList() != null) {
            for (NerDataRspBo nerDataRspBo : entityRecognitionRspBo.getNerList()) {
                if (SeSearchConstants.EntityRecognition.CATEGORY_DESC_LIST.contains(nerDataRspBo.getTag())) {
                    String lv2Category = "l2_category";
                    if (entityMap.containsKey(lv2Category)) {
                        entityMap.put(lv2Category, (String)entityMap.get(lv2Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv2Category, nerDataRspBo.getWord());
                    }
                    String lv3Category = "l3_category";
                    if (entityMap.containsKey(lv3Category)) {
                        entityMap.put(lv3Category, (String)entityMap.get(lv3Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv3Category, nerDataRspBo.getWord());
                    }
                    String lv4Category = "l4mg_category";
                    if (entityMap.containsKey(lv4Category)) {
                        entityMap.put(lv4Category, (String)entityMap.get(lv4Category) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(lv4Category, nerDataRspBo.getWord());
                    continue;
                }
                if (SeSearchConstants.EntityRecognition.BRAND_DESC_LIST.contains(nerDataRspBo.getTag())) {
                    String brand = "brand";
                    if (entityMap.containsKey(brand)) {
                        entityMap.put(brand, (String)entityMap.get(brand) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(brand, nerDataRspBo.getWord());
                    continue;
                }
                if (SeSearchConstants.EntityRecognition.VENDOR_DESC_LIST.contains(nerDataRspBo.getTag())) {
                    String vendor = "vendor";
                    if (entityMap.containsKey(vendor)) {
                        entityMap.put(vendor, (String)entityMap.get(vendor) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(vendor, nerDataRspBo.getWord());
                    continue;
                }
                entityMap.put(common, (String)entityMap.get(common) + " " + nerDataRspBo.getWord());
            }
        } else {
            entityMap.put("common", queryStr);
        }
        return entityMap;
    }

    private List<TermsBO> parseTempTermsList(Map<String, String> entityMap) {
        HashMap<String, TermsBO> termsBOMap = new HashMap<String, TermsBO>();
        for (String key : entityMap.keySet()) {
            TermsBO termsBO;
            String[] categoryArr = entityMap.get(key).split(",");
            Map<String, String> singleMap = SeEntityCache.getEntityCacheMap().get(key);
            if (categoryArr == null || singleMap == null || (termsBO = this.parseTerms(key, categoryArr, singleMap)) == null) continue;
            termsBOMap.put(key, termsBO);
        }
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        if (termsBOMap.containsKey(lv4Category)) {
            termsBOMap.remove(lv2Category);
            termsBOMap.remove(lv3Category);
        } else if (termsBOMap.containsKey(lv3Category)) {
            termsBOMap.remove(lv2Category);
        }
        ArrayList<TermsBO> termsBOList = new ArrayList<TermsBO>();
        for (TermsBO termsBO : termsBOMap.values()) {
            termsBOList.add(termsBO);
        }
        return termsBOList;
    }

    private TermsBO parseTerms(String key, String[] categoryArr, Map<String, String> cacheMap) {
        ArrayList<String> valueList = new ArrayList<String>();
        String valueStr = "";
        for (String category : categoryArr) {
            if (!cacheMap.containsKey(category)) continue;
            valueStr = StringUtils.isNotBlank((CharSequence)valueStr) ? valueStr + "," + cacheMap.get(category) : cacheMap.get(category);
        }
        valueList.add(valueStr);
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            TermsBO termsBO = new TermsBO(key + "_id", valueList);
            return termsBO;
        }
        return null;
    }

    private Map<String, String> matchTerms(Map<String, String> entityMap, List<TermsBO> tempTermsList) {
        String value;
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(lv3Category) && !this.containsName(tempTermsList, lv2Category) && !this.containsName(tempTermsList, lv3Category) && !this.containsName(tempTermsList, lv4Category)) {
            value = entityMap.get(lv3Category);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(brand) && !this.containsName(tempTermsList, brand)) {
            value = entityMap.get(brand);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(vendor) && !this.containsName(tempTermsList, vendor)) {
            value = entityMap.get(vendor);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        return entityMap;
    }

    private DarticipleQueryBO initDarticipleQueryBO(ExecuteSearchReqBO executeSearchReqBO, Map<String, String> entityMap, List<TermsBO> tempTermsList) {
        String[] fieldArr;
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        if (executeSearchReqBO.getFrom() != null) {
            darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        }
        if (executeSearchReqBO.getSize() != null) {
            darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        }
        List termsList = darticipleQueryReader.getTermsList();
        termsList.addAll(tempTermsList);
        darticipleQueryReader.setTermsList(termsList);
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : fieldArr = this.FIELDS_STR.split(",")) {
            int lastIndex = field.lastIndexOf("_");
            String name = field;
            if (lastIndex > 0) {
                name = field.substring(0, lastIndex);
            }
            boolean notExistFlag = true;
            if (termsList != null) {
                for (TermsBO termsBO : termsList) {
                    if (!termsBO.getName().contains(name)) continue;
                    notExistFlag = false;
                    break;
                }
            }
            if (!notExistFlag) continue;
            fields.add(field);
        }
        darticipleQueryReader.setFields(fields);
        darticipleQueryReader.setQuery(entityMap.get("common"));
        darticipleQueryBO.init(darticipleQueryReader);
        return darticipleQueryBO;
    }

    private boolean containsName(List<TermsBO> tempTermsList, String name) {
        for (TermsBO termsBO : tempTermsList) {
            if (!termsBO.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> reduceEntityMap(Map<String, String> entityMap) {
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(brand)) {
            entityMap.remove(brand);
            return entityMap;
        }
        if (entityMap.containsKey(vendor)) {
            entityMap.remove(vendor);
            return entityMap;
        }
        if (entityMap.containsKey(lv4Category)) {
            entityMap.remove(lv4Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv3Category)) {
            entityMap.remove(lv3Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv2Category)) {
            entityMap.remove(lv2Category);
            return entityMap;
        }
        entityMap = new HashMap<String, String>();
        entityMap.put(common, "");
        return entityMap;
    }

    private boolean queryAgain(String esResult) {
        EsResultBO esResultBO = (EsResultBO)JSONObject.parseObject((String)esResult, EsResultBO.class);
        return esResultBO != null && esResultBO.getHits() != null && esResultBO.getHits().getTotal().getValue() == 0;
    }

    private String parseContent(DarticipleQueryBO darticipleQueryBO) {
        String content = JSON.toJSONString((Object)darticipleQueryBO);
        return content;
    }

    private String postEsSearch(String esQueryBody) {
        String esResult = "";
        String method = "POST";
        String endpoint = new StringBuffer().append("/").append(this.INDEX_NAME).append("/_search").toString();
        Request request = new Request(method, endpoint);
        request.setJsonEntity(esQueryBody);
        try {
            Response response = this.getRestClient().performRequest(request);
            esResult = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SeBusinessException("\u8c03\u7528es\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return esResult;
    }
}

