/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.normalized.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.normalized.TokensMatchIndexService;
import com.tydic.se.search.normalized.bo.AnalyzerTokensBo;
import com.tydic.se.search.normalized.bo.CatalogMatchResultBo;
import com.tydic.se.search.normalized.bo.ForecastCategoryInfoBO;
import com.tydic.se.search.normalized.bo.FrequencyHitBo;
import com.tydic.se.search.normalized.bo.TokensMatchIndexReqBO;
import com.tydic.se.search.normalized.bo.TokensMatchIndexRspBO;
import com.tydic.se.search.normalized.constant.FrequencyLinkHashMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="SearchSortForecastCategoryService")
public class SearchSortForecastCategoryServiceImpl
implements TokensMatchIndexService {
    private static final Logger log = LoggerFactory.getLogger(SearchSortForecastCategoryServiceImpl.class);

    public TokensMatchIndexRspBO match(TokensMatchIndexReqBO reqBO) {
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getResult())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        List searchBarEsBos = reqBO.getResult();
        ArrayList<ForecastCategoryInfoBO> forecastCategoryInfoBOS = new ArrayList<ForecastCategoryInfoBO>();
        searchBarEsBos.forEach(uccMallSearchBarEsRspInfo -> {
            List categoryIds = uccMallSearchBarEsRspInfo.getL3CategoryId();
            List categoryNames = uccMallSearchBarEsRspInfo.getL3CategoryName();
            if (!CollectionUtils.isEmpty((Collection)categoryIds) && !CollectionUtils.isEmpty((Collection)categoryNames)) {
                int size = Math.min(categoryIds.size(), categoryNames.size());
                for (int i = 0; i < size; ++i) {
                    ForecastCategoryInfoBO forecastCategoryInfoBO = new ForecastCategoryInfoBO();
                    FrequencyHitBo frequencyHitBo = this.getFrequency((SeQuerySkuBO)uccMallSearchBarEsRspInfo, reqBO);
                    forecastCategoryInfoBO.setFrequency(frequencyHitBo.getFrequency());
                    forecastCategoryInfoBO.setHitRate(frequencyHitBo.getHitRate());
                    forecastCategoryInfoBO.setTempL3CategoryId((Long)categoryIds.get(i));
                    forecastCategoryInfoBO.setTempL3CategoryName((String)categoryNames.get(i));
                    forecastCategoryInfoBOS.add(forecastCategoryInfoBO);
                }
            }
        });
        TokensMatchIndexRspBO tokensMatchIndexRspBO = this.forecastCateLog(forecastCategoryInfoBOS);
        List matchResultBos = tokensMatchIndexRspBO.getMatchBos();
        ArrayList<String> catLogList = new ArrayList<String>();
        for (CatalogMatchResultBo matchResultBo : matchResultBos) {
            catLogList.add(matchResultBo.getTagName());
        }
        tokensMatchIndexRspBO.setMatchBos(catLogList);
        return tokensMatchIndexRspBO;
    }

    private TokensMatchIndexRspBO forecastCateLog(List<ForecastCategoryInfoBO> forecastCategoryInfoBOS) {
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        Map<Long, ForecastCategoryInfoBO> frequencyMap = forecastCategoryInfoBOS.stream().filter(a -> a.getTempL3CategoryId() != null).collect(Collectors.groupingBy(ForecastCategoryInfoBO::getTempL3CategoryId, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(ForecastCategoryInfoBO::getHitRate)), Optional::get)));
        List frequencyList = frequencyMap.entrySet().stream().map(e -> (ForecastCategoryInfoBO)e.getValue()).collect(Collectors.toList());
        log.info("\u53bb\u91cd\u9891\u9053\u524d\u7684\u96c6\u5408\u5927\u5c0f\uff1a" + frequencyList.size());
        List uniqueCategoryList = frequencyList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ForecastCategoryInfoBO>(Comparator.comparing(ForecastCategoryInfoBO::getTempL3CategoryName))), ArrayList::new));
        log.info("\u53bb\u91cd\u9891\u9053\u540e\u7684\u96c6\u5408\u5927\u5c0f\uff1a" + uniqueCategoryList.size());
        Map<Long, Long> frequencyTotalMap = this.getFrequencyTotalMap(forecastCategoryInfoBOS);
        List<ForecastCategoryInfoBO> resultList = uniqueCategoryList.stream().filter(e -> frequencyTotalMap.get(e.getTempL3CategoryId()) != null).sorted(Comparator.comparing(ForecastCategoryInfoBO::getHitRate).thenComparing(ForecastCategoryInfoBO::getFrequency).reversed()).collect(Collectors.toList());
        ArrayList matchResultBos = new ArrayList();
        resultList.forEach(forecastCategoryInfoBO -> {
            CatalogMatchResultBo matchResultBo = new CatalogMatchResultBo();
            matchResultBo.setGuideCatalogId(forecastCategoryInfoBO.getTempL3CategoryId());
            matchResultBo.setCatalogLevel(Long.valueOf(3L));
            matchResultBo.setTagName(forecastCategoryInfoBO.getTempL3CategoryName());
            matchResultBos.add(matchResultBo);
        });
        rspBO.setMatchBos(matchResultBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FrequencyHitBo getFrequency(SeQuerySkuBO uccMallSearchBarEsRspInfo, TokensMatchIndexReqBO reqBO) {
        int i;
        List rows = reqBO.getRows();
        FrequencyHitBo frequencyHitBo = new FrequencyHitBo();
        long frequency = 0L;
        int hitCount = 0;
        long[] tokenCount = new long[rows.size()];
        StringBuilder sbName = new StringBuilder();
        sbName.append(uccMallSearchBarEsRspInfo.getSkuName());
        for (i = 0; i < rows.size(); ++i) {
            AnalyzerTokensBo tokensBo = (AnalyzerTokensBo)rows.get(i);
            long count = this.appearFrequency(sbName.toString(), tokensBo.getToken());
            if (count > 0L) {
                ++hitCount;
            }
            tokenCount[i] = count;
        }
        for (i = 0; i < tokenCount.length; ++i) {
            frequency += tokenCount[i] * (long)this.fibonacci(i);
        }
        frequencyHitBo.setFrequency(Long.valueOf(frequency));
        frequencyHitBo.setHitRate(Double.valueOf(BigDecimal.valueOf((float)hitCount / (float)rows.size()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        return frequencyHitBo;
    }

    private Long appearFrequency(String srcText, String findText) {
        Long count = 0L;
        Pattern p = Pattern.compile(findText.toUpperCase());
        Matcher m = p.matcher(srcText.toUpperCase());
        if (m.find()) {
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
        }
        return count;
    }

    private Map<Long, Long> getFrequencyTotalMap(List<ForecastCategoryInfoBO> forecastCategoryInfoBOS) {
        double postPercent = 0.0;
        Map<Long, Long> frequencyTotalMap = forecastCategoryInfoBOS.stream().collect(Collectors.groupingBy(ForecastCategoryInfoBO::getTempL3CategoryId, Collectors.counting()));
        FrequencyLinkHashMap frequencySeqMap = frequencyTotalMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, FrequencyLinkHashMap::new));
        int post = (int)Math.ceil((double)frequencySeqMap.size() * postPercent);
        FrequencyLinkHashMap deleteMap = new FrequencyLinkHashMap();
        for (int i = frequencySeqMap.size() - post; i < frequencySeqMap.size(); ++i) {
            FrequencyLinkHashMap map = new FrequencyLinkHashMap();
            Map.Entry entry = frequencySeqMap.getEntry(i);
            map.put(entry.getKey(), entry.getValue());
            deleteMap.putAll((Map)map);
        }
        Set bigMapKey = frequencySeqMap.keySet();
        Set smallMapKey = deleteMap.keySet();
        Sets.SetView differenceSet = Sets.difference((Set)bigMapKey, (Set)smallMapKey);
        HashMap resultMap = Maps.newHashMap();
        for (Long key : differenceSet) {
            resultMap.put(key, frequencySeqMap.get((Object)key));
        }
        return resultMap;
    }

    int fibonacci(int n) {
        int[] nums = new int[]{1, 13, 233, 1597, 4181, 10946, 28657, 75025, 196418, 514229, 1346269};
        return nums[n];
    }
}

