/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchCommodityRedisDataServiceImpl
implements SearchCommodityRedisDataService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityRedisDataServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchSortConfig searchSortConfig;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writerCache(SeSearchRspBO rspB, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            if (searchSortMsgBo.getRedisEnabled().booleanValue() && this.searchSortConfig.getRedisUse().booleanValue() && !"null".equals(searchSortMsgBo.getSessionId()) && CollectionUtils.isEmpty((Collection)searchSortMsgBo.getQueryFilterList()) && CollectionUtils.isEmpty((Collection)searchSortMsgBo.getQueryPropertyList()) && !searchSortMsgBo.isSalesPriceJudge()) {
                Set keys = this.cacheClient.getkeys("*" + searchSortMsgBo.getSessionId() + "*");
                List collect = keys.stream().sorted().collect(Collectors.toList());
                if (collect.size() >= Integer.parseInt(this.searchSortConfig.getRedisCacheNumber())) {
                    this.cacheClient.delete((String)collect.get(0));
                }
                rspB.setRecordsTotal(rspB.getSkuList().size());
                rspB.setTotal(searchSortMsgBo.getPageSize());
                Gson s = new Gson();
                String json = s.toJson((Object)rspB);
                if (rspB.getSkuList().size() == 0) throw new SearchSortException("7204", "\u67e5\u8be2\u4e3a\u7a7a\uff0c\u62d2\u7edd\u5199\u5165\u7f13\u5b58\uff01");
                this.cacheClient.set(searchSortMsgBo.getSessionIdKey(), (Object)json, Integer.parseInt(this.searchSortConfig.getRedisCacheTime()) * 60);
                return;
            } else {
                log.info("redisEnabled:{},redisUse:{},token:{},queryFilterList.size():{},queryPropertyList.size():{},\u4ef7\u683c\u7b5b\u9009:{} \u4e0d\u5199\u5165\u7f13\u5b58\uff01", new Object[]{searchSortMsgBo.getRedisEnabled(), this.searchSortConfig.getRedisUse(), searchSortMsgBo.getSessionId(), searchSortMsgBo.getQueryFilterList().size(), searchSortMsgBo.getQueryPropertyList().size(), searchSortMsgBo.isSalesPriceJudge()});
            }
            return;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"7776", "\u7f13\u5b58\u5199\u5165\uff01", e});
            throw new SearchSortException("7776", "\u7f13\u5b58\u5199\u5165\uff01", (Throwable)e);
        }
    }

    public SeSearchRspBO readCache(SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            String json = (String)this.cacheClient.get(searchSortMsgBo.getSessionIdKey());
            return (SeSearchRspBO)JSON.parseObject((String)json, SeSearchRspBO.class);
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"7779", "\u7f13\u5b58\u8bfb\u53d6\uff01", e});
            throw new SearchSortException("7779", "\u7f13\u5b58\u8bfb\u53d6\uff01", (Throwable)e);
        }
    }

    public SeSearchRspBO dataEncapsulation(SeSearchReqBO reqBO, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            SeSearchRspBO searchEsRspBo = this.readCache(searchSortMsgBo);
            int pageNo = reqBO.getPageNo();
            int pageSize = reqBO.getPageSize();
            if (!CollectionUtils.isEmpty((Collection)searchEsRspBo.getSkuList())) {
                List commodityRspBos = searchEsRspBo.getSkuList();
                searchEsRspBo.setSkuList(commodityRspBos.subList((pageNo - 1) * pageSize, Math.min(pageNo * pageSize, commodityRspBos.size())));
                searchEsRspBo.setTotal(pageSize);
                log.info("\u6709\u7f13\u5b58\uff0c\u8fd4\u56de\u524d\u6570\u636e\u5c55\u793a\uff01");
                SearchSortUtils.printCommodityName((SeSearchRspBO)searchEsRspBo);
            }
            return searchEsRspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "redis\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", e});
            throw new SearchSortException("9999", "redis\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
        }
    }

    public SeSearchRspBO dataEncapsulation(SeSearchRspBO rspBo, SeSearchReqBO reqBO) throws SearchSortException {
        try {
            int pageNo = reqBO.getPageNo();
            int pageSize = reqBO.getPageSize();
            if (!CollectionUtils.isEmpty((Collection)rspBo.getSkuList())) {
                List commodityRspBos = rspBo.getSkuList();
                rspBo.setRecordsTotal(rspBo.getSkuList().size());
                rspBo.setTotal(pageSize);
                rspBo.setSkuList(commodityRspBos.subList((pageNo - 1) * pageSize, Math.min(pageNo * pageSize, commodityRspBos.size())));
                log.info("\u65e0\u7f13\u5b58\uff0c\u8fd4\u56de\u524d\u6570\u636e\u5c55\u793a\uff01");
                SearchSortUtils.printCommodityName((SeSearchRspBO)rspBo);
            } else {
                rspBo.setTotal(pageSize);
                rspBo.setRecordsTotal(0);
            }
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", e});
            throw new SearchSortException("9999", "\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
        }
    }
}

