/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityCustomInterventionService;
import com.tydic.se.search.sort.SearchCommodityRelevanceSortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="SearchCommodityRelevanceSortServiceImpl")
public class SearchCommodityRelevanceSortServiceImpl
implements SearchCommodityRelevanceSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityRelevanceSortServiceImpl.class);
    @Autowired
    private SearchSortConfig searchSortConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchCommodityCustomInterventionService searchCommodityCustomInterventionService;

    public SeSearchRspBO relevanceSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            if (rspBo.getReCallType().equals(2)) {
                rspBo.setQueryResultType("1");
                log.warn("\u5168\u6587\u68c0\u7d22\u4e0d\u9700\u8981\u6267\u884c\u76f8\u5173\u6027\u6392\u5e8f\uff01");
                return rspBo;
            }
            String time1 = SearchSortUtils.getNowTime();
            LinkedList relatedPass = new LinkedList();
            LinkedList related = new LinkedList();
            LinkedList irrelevant = new LinkedList();
            LinkedList seQuerySkuBOList = rspBo.getSkuList();
            TreeMap map = new TreeMap(Comparator.reverseOrder());
            List<Map<String, Double>> splitData = this.correlationData(searchSortMsgBo);
            log.info("\u76f8\u5173\u6027\u5339\u914d\u62c6\u5206\u6570\u636e\uff1a{}", splitData);
            seQuerySkuBOList.forEach(commodityRspBo -> {
                this.weigh(splitData, (SeQuerySkuBO)commodityRspBo, searchSortMsgBo);
                double flag = commodityRspBo.getWeight();
                if (flag < Double.parseDouble(this.searchSortConfig.getIrrelevantRatioLowest())) {
                    irrelevant.add(commodityRspBo);
                } else {
                    this.manualInterventionWeigh(flag, searchSortMsgBo.getQueryStrParticiple(), (SeQuerySkuBO)commodityRspBo, searchSortMsgBo);
                    flag = commodityRspBo.getWeight();
                    if (!map.containsKey(flag)) {
                        map.put(flag, new LinkedList());
                    }
                    ((List)map.get(flag)).add(commodityRspBo);
                }
            });
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                double key = (Double)iterator.next();
                if (key > Double.parseDouble(this.searchSortConfig.getIrrelevantRatioPass())) {
                    relatedPass.addAll((Collection)map.get(key));
                    continue;
                }
                related.addAll((Collection)map.get(key));
            }
            seQuerySkuBOList = relatedPass;
            if (relatedPass.size() > 0) {
                rspBo.setQueryResultType("0");
            } else if (related.size() > 0) {
                seQuerySkuBOList.addAll(related);
                rspBo.setQueryResultType("1");
            } else {
                rspBo.setQueryResultType("2");
            }
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u5408\u683c\u6570\u636e{}\u6761\u6570\u636e\uff01", (Object)relatedPass.size());
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u53ef\u80fd\u76f8\u5173\u6570\u636e{}\u6761\u6570\u636e\uff01", (Object)related.size());
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u8fc7\u6ee4{}\u6761\u6570\u636e\uff01", (Object)irrelevant.size());
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u67e5\u8be2\u7ed3\u679c\u7c7b\u578b:{}", (Object)rspBo.getQueryResultType());
            rspBo.setSkuList(seQuerySkuBOList);
            log.info(SearchSortUtils.timeCalculation((String)"\u76f8\u5173\u6027\u6392\u5e8f", (String)time1, (String)SearchSortUtils.getNowTime()));
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u76f8\u5173\u5ea6\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u76f8\u5173\u5ea6\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private void weigh(List<Map<String, Double>> splitData, SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        try {
            if (searchSortMsgBo.getQueryStrParticiple().size() != 0) {
                AtomicReference<Double> flag = new AtomicReference<Double>(0.0);
                if ("null".equals(this.searchSortConfig.getRelevanceFieldMatching())) {
                    throw new Exception("\u8bf7\u914d\u7f6e\u76f8\u5173\u5ea6\u5339\u914d\u5b57\u6bb5\uff01");
                }
                if ("null".equals(this.searchSortConfig.getRelevanceChineseFieldMatching())) {
                    throw new Exception("\u8bf7\u914d\u7f6e\u76f8\u5173\u5ea6\u4e2d\u6587\u5339\u914d\u5b57\u6bb5\uff01");
                }
                String[] fields = this.searchSortConfig.getRelevanceFieldMatching().split(",");
                String[] chineseFields = this.searchSortConfig.getRelevanceChineseFieldMatching().split(",");
                Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                StringBuilder stringBuilderChinese = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                this.correlationStringPackaging(seQuerySkuBO, chineseFields, clazz, stringBuilderChinese);
                this.correlationStringPackaging(seQuerySkuBO, fields, clazz, stringBuilder);
                stringBuilder.append((CharSequence)stringBuilderChinese);
                LinkedList<String> weightDesc = new LinkedList<String>();
                splitData.forEach(maps -> {
                    boolean judge = Boolean.TRUE;
                    for (Map.Entry entry : maps.entrySet()) {
                        double tmp;
                        if (this.checkNotExistChinese(searchSortMsgBo.getQueryStr())) {
                            tmp = stringBuilder.toString().toUpperCase().contains(((String)entry.getKey()).toUpperCase()) ? (Double)entry.getValue() : 0.0;
                        } else {
                            double d = tmp = stringBuilderChinese.toString().toUpperCase().contains(((String)entry.getKey()).toUpperCase()) ? (Double)entry.getValue() : 0.0;
                        }
                        if (tmp != 0.0 && judge) {
                            flag.updateAndGet(v -> v + tmp);
                            weightDesc.add((String)entry.getKey() + ":" + entry.getValue());
                            break;
                        }
                        judge = Boolean.FALSE;
                        flag.updateAndGet(v -> v + tmp);
                        if (tmp == 0.0) continue;
                        weightDesc.add((String)entry.getKey() + ":" + entry.getValue());
                    }
                });
                if (seQuerySkuBO.getCommodityName().toLowerCase().contains(searchSortMsgBo.getQueryStr().toLowerCase())) {
                    flag.updateAndGet(v -> v + 1.0);
                    weightDesc.add("\u5546\u54c1\u540d\u4e2d\u5b58\u5728:1.0");
                }
                seQuerySkuBO.setWeightDesc(String.join((CharSequence)" , ", weightDesc));
                seQuerySkuBO.setWeight(flag.get().doubleValue());
            } else {
                seQuerySkuBO.setWeightDesc("\u4e0d\u8ba1\u7b97\u6743\u503c\uff01");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6743\u503c\u8ba1\u7b97\uff01", e});
            throw new SearchSortException("9999", "\u6743\u503c\u8ba1\u7b97\uff01", (Throwable)e);
        }
    }

    private void correlationStringPackaging(SeQuerySkuBO seQuerySkuBO, String[] fields, Class<SeQuerySkuBO> clazz, StringBuilder stringBuilder) {
        try {
            for (String fieldName : fields) {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                Type type = field.getGenericType();
                String pattern = "java.util.List<.*>";
                boolean isMatch = Pattern.matches(pattern, type.getTypeName());
                if (isMatch) {
                    List value = (List)field.get(seQuerySkuBO);
                    stringBuilder.append(ObjectUtils.isEmpty((Object)value) ? "" : String.join((CharSequence)",", value) + ",");
                    continue;
                }
                stringBuilder.append(ObjectUtils.isEmpty((Object)field.get(seQuerySkuBO)) ? "" : field.get(seQuerySkuBO) + ",");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5c5e\u6027\u9519\u8bef\uff01", e});
            throw new SearchSortException("9999", "\u5c5e\u6027\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    private void manualInterventionWeigh(double basicPoints, List<String> queryStrParticiple, SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        if (queryStrParticiple.size() != 0) {
            AtomicReference<Double> flag = new AtomicReference<Double>(basicPoints);
            flag.updateAndGet(v -> v + this.searchCommodityCustomInterventionService.locationJudgmentLast(seQuerySkuBO, searchSortMsgBo));
            flag.updateAndGet(v -> v + this.searchCommodityCustomInterventionService.locationJudgmentSpecialChar(seQuerySkuBO, searchSortMsgBo));
            seQuerySkuBO.setWeight(flag.get().doubleValue());
        }
    }

    private List<Map<String, Double>> correlationData(SearchSortMsgBo searchSortMsgBo) {
        LinkedList<Map<String, Double>> list = new LinkedList<Map<String, Double>>();
        for (String name : searchSortMsgBo.getQueryStrParticiple()) {
            char[] chars;
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            map.put(name, 1.0 / (double)searchSortMsgBo.getQueryStrParticiple().size());
            for (char c : chars = name.toCharArray()) {
                map.put(String.valueOf(c), 1.0 / (double)searchSortMsgBo.getQueryStrParticiple().size() * this.searchSortConfig.getBitwiseCorrelationWeight() / (double)chars.length);
            }
            list.add(map);
        }
        return list;
    }

    private boolean checkNotExistChinese(String name) {
        char n = '\u0000';
        for (int i = 0; i < name.length(); ++i) {
            n = name.charAt(i);
            if ('\u4e00' > n || n >= '\u9fa5') continue;
            return false;
        }
        return true;
    }
}

