/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityDefaultSortService;
import com.tydic.se.search.sort.SearchCommodityPredictiveSortService;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.SearchCommodityReflectionService;
import com.tydic.se.search.sort.SearchCommodityRelevanceSortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SearchCommodityDefaultSortServiceImpl
implements SearchCommodityDefaultSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityDefaultSortServiceImpl.class);
    @Autowired
    private SearchSortConfig searchSortConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchCommodityRelevanceSortService searchCommodityRelevanceSortService;
    @Autowired
    private SearchCommodityPredictiveSortService searchCommodityPredictiveSortService;
    @Autowired
    private SearchCommodityRedisDataService searchCommodityRedisDataService;
    @Autowired
    private SearchCommodityReflectionService searchCommodityReflectionService;

    public SeSearchRspBO defaultQuerySort(SeSearchReqBO reqBO, SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            String time1 = SearchSortUtils.getNowTime();
            LinkedList<SeQuerySkuBO> seQuerySkuBOList = new LinkedList<SeQuerySkuBO>();
            for (SeQuerySkuBO seQuerySkuBO : rspBo.getSkuList()) {
                if (ObjectUtils.isEmpty((Object)seQuerySkuBO)) continue;
                if (!StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getSkuName())) {
                    seQuerySkuBO.setSkuName("");
                }
                seQuerySkuBOList.add(seQuerySkuBO);
            }
            log.info("\u521d\u59cb\u5316\u5904\u7406\u5546\u54c1\u7a7a\u6570\u636e,\u539f\u59cb\u6570\u636e\u6709{}\u6761\uff0c\u5904\u7406\u540e\u6709{}\u6761\uff01", (Object)rspBo.getSkuList().size(), (Object)seQuerySkuBOList.size());
            rspBo.setSkuList(seQuerySkuBOList);
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getQueryStrParticiple()) && rspBo.getSkuList().size() > Integer.parseInt(this.searchSortConfig.getStartSortThreshold())) {
                searchSortMsgBo = this.searchCommodityPredictiveSortService.predictiveDataEncapsulation(rspBo, searchSortMsgBo);
                log.info("\u6392\u5e8f\u65b9\u5f0f\u7ed3\u679c\uff1a{}", (Object)searchSortMsgBo.getSortByMethod());
                for (String method : searchSortMsgBo.getSortByMethod()) {
                    rspBo = this.searchCommodityReflectionService.invokeService(method.split("\\.")[0], method.split("\\.")[1], rspBo, searchSortMsgBo);
                }
            } else {
                log.info("\u67e5\u8be2\u8bcd\uff1a{}\uff0c\u67e5\u8be2\u6570\u636e\u6709{}\u6761\uff0c\u4e0d\u9700\u8981\u505a\u6392\u5e8f\uff01", (Object)searchSortMsgBo.getQueryStr(), (Object)rspBo.getSkuList().size());
                rspBo.setQueryResultType("2");
            }
            this.searchCommodityRedisDataService.writerCache(rspBo, searchSortMsgBo);
            log.info("\u9ed8\u8ba4\u6392\u5e8f\u540e\u5546\u54c1\u6570\u91cf\uff1a" + rspBo.getSkuList().size());
            log.info(SearchSortUtils.timeCalculation((String)"\u9ed8\u8ba4\u6392\u5e8f", (String)time1, (String)SearchSortUtils.getNowTime()));
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u9ed8\u8ba4\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u9ed8\u8ba4\u6392\u5e8f\uff01", (Throwable)e);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6392\u5e8f\u53cd\u5c04\uff01", e});
            throw new SearchSortException("9999", "\u6392\u5e8f\u53cd\u5c04\uff01", (Throwable)e);
        }
    }
}

