/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.tydic.se.search.sort.config.SearchSortConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

@Service
public class SearchRelevanceFieldBuilder
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SearchRelevanceFieldBuilder.class);
    private static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    private static final Pattern NUM_PATTERN = Pattern.compile(".*\\d+.*");
    private static final String LONG_ACCURATE_FIELDS_STR_FIELD = "es.accurate.fields";
    private static final String ACCURATE_FIELDS_STR_FIELD = "es.accurate.fields";
    private static final String NULL = "null";
    @Autowired
    @Qualifier(value="searchSortConfig")
    private SearchSortConfig searchSortConfig;
    @Value(value="${es.accurate.fields:null}")
    private String longAccurateFieldsStr;
    @Value(value="${es.accurate.text.fields:null}")
    private String accurateFieldsStr;

    public void run(String ... args) {
        if (!StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceFieldMatching()) || NULL.equals(this.searchSortConfig.getRelevanceFieldMatching())) {
            this.longAccurateFieldsStr2relevanceFieldMatching(this.longAccurateFieldsStr);
        }
        if (!StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceChineseFieldMatching()) || NULL.equals(this.searchSortConfig.getRelevanceChineseFieldMatching())) {
            this.accurateFieldsStr2relevanceChineseFieldMatching(this.accurateFieldsStr);
        }
    }

    @ApolloConfigChangeListener
    private void onChangeToAll(ConfigChangeEvent changeEvent) {
        for (String key : changeEvent.changedKeys()) {
            ConfigChange change;
            if (key.equals("es.accurate.fields")) {
                change = changeEvent.getChange(key);
                if (!StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceFieldMatching())) {
                    this.longAccurateFieldsStr2relevanceFieldMatching(change.getNewValue());
                }
            }
            if (!key.equals("es.accurate.fields")) continue;
            change = changeEvent.getChange(key);
            if (StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceChineseFieldMatching())) continue;
            this.accurateFieldsStr2relevanceChineseFieldMatching(change.getNewValue());
        }
    }

    private void longAccurateFieldsStr2relevanceFieldMatching(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List<String> esFields = Arrays.asList(str.split(","));
            ArrayList esNewFields = new ArrayList();
            esFields.forEach(esField -> esNewFields.add(SearchRelevanceFieldBuilder.lineToHump(esField)));
            log.info("relevanceFieldMatching\u66ff\u6362\u4e3a:" + String.join((CharSequence)",", esNewFields));
            this.searchSortConfig.setRelevanceFieldMatching(String.join((CharSequence)",", esNewFields));
        }
    }

    private void accurateFieldsStr2relevanceChineseFieldMatching(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List<String> esFields = Arrays.asList(str.split(","));
            ArrayList esNewFields = new ArrayList();
            esFields.forEach(esField -> {
                esField = esField.replace(".keyword", "");
                esNewFields.add(SearchRelevanceFieldBuilder.lineToHump(esField));
            });
            log.info("relevanceChineseFieldMatching\u66ff\u6362\u4e3a:" + String.join((CharSequence)",", esNewFields));
            this.searchSortConfig.setRelevanceChineseFieldMatching(String.join((CharSequence)",", esNewFields));
        }
    }

    private static String lineToHump(String str) {
        if (!str.contains("_")) {
            return str;
        }
        str = str.toLowerCase();
        StringBuffer sb = new StringBuffer();
        Matcher lineMatcher = LINE_PATTERN.matcher(str);
        while (lineMatcher.find()) {
            lineMatcher.appendReplacement(sb, lineMatcher.group(1).toUpperCase());
        }
        lineMatcher.appendTail(sb);
        if (!SearchRelevanceFieldBuilder.hasDigit(str)) {
            return sb.toString();
        }
        str = sb.toString();
        sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(str.charAt(i));
            if (!SearchRelevanceFieldBuilder.hasDigit(String.valueOf(str.charAt(i)))) continue;
            sb.append(String.valueOf(str.charAt(++i)).toUpperCase());
        }
        return sb.toString();
    }

    private static boolean hasDigit(String content) {
        boolean flag = false;
        Matcher m = NUM_PATTERN.matcher(content);
        if (m.matches()) {
            flag = true;
        }
        return flag;
    }
}

