/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.se.base.ability.bo.SeEsAssociationaBO;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.search.ability.SeAssociationalService;
import com.tydic.se.search.ability.bo.SeAssociationalReqBO;
import com.tydic.se.search.ability.bo.SeAssociationalRspBO;
import com.tydic.se.search.job.bo.AssociationalBO;
import com.tydic.se.search.job.bo.AssociationalReader;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SeAssociationalServiceImpl
implements SeAssociationalService {
    @Value(value="${es.suggest.field.name:sku_name.keyword}")
    private String field;
    @Value(value="${es.suggest.size:10}")
    private Integer size;
    @Value(value="${es.index_name:commodity_index}")
    private String INDEX_NAME;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    public SeAssociationalRspBO associational(SeAssociationalReqBO reqBO) {
        AssociationalReader associationalReader = new AssociationalReader();
        associationalReader.setField(this.field);
        associationalReader.setSize(this.size);
        associationalReader.setPrefix(reqBO.getQuery());
        AssociationalBO associationalBO = new AssociationalBO();
        associationalBO.init(associationalReader);
        String content = JSON.toJSONString((Object)associationalBO);
        String esStr = this.elasticsearchUtil.postEsSearch(this.INDEX_NAME, content);
        SeEsAssociationaBO seEsAssociationaBO = (SeEsAssociationaBO)JSON.parseObject((String)esStr, SeEsAssociationaBO.class);
        List options = ((SeEsAssociationaBO.Suggest.AssociationalName)seEsAssociationaBO.getSuggest().getAssociationalName().get(0)).getOptions();
        List collect = options.stream().map(SeEsAssociationaBO.Suggest.AssociationalName.AssOptions::getText).collect(Collectors.toList());
        SeAssociationalRspBO rspBO = new SeAssociationalRspBO();
        rspBO.setOptions(collect);
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

