/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.qa.impl;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.tydic.se.base.ability.search.qa.bo.InsertFileDataBO;
import com.tydic.se.base.ability.search.qa.bo.SimplifiedProductInfoBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisExcelDataBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisFileUploadReqBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisSearchGoodsReqBO;
import com.tydic.se.base.ability.search.qa.bo.rsp.QueryAnalysisRspBO;
import com.tydic.se.base.util.ExecutorProcessPool;
import com.tydic.se.base.util.ExecutorServiceFactory;
import com.tydic.se.search.qa.QueryAnalysisSingleAtomService;
import com.tydic.se.search.qa.config.SearchQaConfig;
import com.tydic.se.search.qa.impl.SnowflakeIdWorker;
import com.tydic.se.search.util.MultipartFileToFileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchQaAsyncTask {
    private static final Logger log = LoggerFactory.getLogger(SearchQaAsyncTask.class);
    @Autowired
    private SearchQaConfig searchQaConfig;
    @Autowired
    private QueryAnalysisSingleAtomService queryAnalysisSingleService;

    public void taskData(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO, String beforeFilename, String beforeFilenameDfs) throws Exception {
        try {
            List<List<QueryAnalysisExcelDataBO>> excelDataBos = this.readExcel(queryAnalysisFileUploadReqBO);
            LinkedList<List<QueryAnalysisExcelDataBO>> writeExcelDataBos = new LinkedList<List<QueryAnalysisExcelDataBO>>();
            ExecutorService executorService = ExecutorServiceFactory.getInstance().createCustomThreadPool(this.searchQaConfig.getThreadsNumber().intValue());
            for (List<QueryAnalysisExcelDataBO> queryAnalysisExcelDataBOList : excelDataBos) {
                final LinkedList writeExcelDataBOList = new LinkedList();
                final CountDownLatch countDownLatch = new CountDownLatch(queryAnalysisExcelDataBOList.size());
                for (final QueryAnalysisExcelDataBO queryAnalysisExcelDataBO : queryAnalysisExcelDataBOList) {
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                QueryAnalysisSearchGoodsReqBO queryAnalysisSearchGoodsReqBO = new QueryAnalysisSearchGoodsReqBO();
                                queryAnalysisSearchGoodsReqBO.setQueryStr(queryAnalysisExcelDataBO.getQueryConditions());
                                queryAnalysisSearchGoodsReqBO.setPageSize(SearchQaAsyncTask.this.searchQaConfig.getQuerySize().intValue());
                                QueryAnalysisRspBO queryAnalysisRspBO = SearchQaAsyncTask.this.queryAnalysisSingleService.singleAnalysis(queryAnalysisSearchGoodsReqBO);
                                if ("9999".equals(queryAnalysisRspBO.getRespCode())) {
                                    QueryAnalysisExcelDataBO tmp = new QueryAnalysisExcelDataBO();
                                    tmp.setNum(queryAnalysisExcelDataBO.getNum());
                                    tmp.setQueryConditions(queryAnalysisExcelDataBO.getQueryConditions());
                                    tmp.setRemark(queryAnalysisRspBO.getRespDesc().replace("java.lang.Exception: ", ""));
                                    writeExcelDataBOList.add(tmp);
                                } else {
                                    List queryAnalysisBOList = queryAnalysisRspBO.getQueryResults();
                                    boolean flag = Boolean.TRUE;
                                    if (queryAnalysisBOList.size() == 0) {
                                        QueryAnalysisExcelDataBO tmp = new QueryAnalysisExcelDataBO();
                                        tmp.setNum(queryAnalysisExcelDataBO.getNum());
                                        tmp.setQueryConditions(queryAnalysisExcelDataBO.getQueryConditions());
                                        tmp.setParticiple(String.join((CharSequence)",", queryAnalysisRspBO.getParticiple()));
                                        tmp.setRemark("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                                        writeExcelDataBOList.add(tmp);
                                    } else {
                                        for (SimplifiedProductInfoBO simplifiedProductInfoBO : queryAnalysisBOList) {
                                            QueryAnalysisExcelDataBO tmp = new QueryAnalysisExcelDataBO();
                                            if (flag) {
                                                tmp.setNum(queryAnalysisExcelDataBO.getNum());
                                                tmp.setQueryConditions(queryAnalysisExcelDataBO.getQueryConditions());
                                                tmp.setParticiple(String.join((CharSequence)",", queryAnalysisRspBO.getParticiple()));
                                                tmp.setAnalyzerCatalogIndexData(String.join((CharSequence)",", queryAnalysisRspBO.getAnalyzerCatalogIndexData()));
                                                tmp.setReCallType(queryAnalysisRspBO.getReCallType());
                                                tmp.setFullTextMatchRate(queryAnalysisRspBO.getFullTextMatchRate());
                                                tmp.setKeyFieldsMatchRate(queryAnalysisRspBO.getKeyFieldsMatchRate());
                                                tmp.setQueryResultType(queryAnalysisRspBO.getQueryResultType());
                                                flag = Boolean.FALSE;
                                            }
                                            tmp.setCommodityName(simplifiedProductInfoBO.getCommodityName());
                                            tmp.setCommodityNameParticiples(String.join((CharSequence)",", simplifiedProductInfoBO.getCommodityNameParticiples()));
                                            tmp.setCatalogAllName(simplifiedProductInfoBO.getCatalogAllName());
                                            tmp.setWeigh(simplifiedProductInfoBO.getWeight().toString());
                                            writeExcelDataBOList.add(tmp);
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5355\u5143\u5f02\u6b65\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
                            }
                            finally {
                                countDownLatch.countDown();
                            }
                        }
                    };
                    ExecutorProcessPool.getInstance().executeByCustomThread(run, executorService);
                }
                countDownLatch.await();
                writeExcelDataBos.add(writeExcelDataBOList);
            }
            File beforeFile = new File(beforeFilenameDfs);
            this.writeExcel(beforeFile, writeExcelDataBos, beforeFilename);
            log.info("Search Qa : {} \u6587\u4ef6\u5c01\u88c5\u5b8c\u6210\uff01", (Object)beforeFilename.split("/")[beforeFilename.split("/").length - 1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u5f02\u6b65\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public List<List<QueryAnalysisExcelDataBO>> readExcel(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) throws InterruptedException {
        ArrayList<List<QueryAnalysisExcelDataBO>> arrayList;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(queryAnalysisFileUploadReqBO.getFile());
        try {
            ArrayList<List<QueryAnalysisExcelDataBO>> excelDataBOList = new ArrayList<List<QueryAnalysisExcelDataBO>>();
            ExcelReader reader = ExcelUtil.getReader((InputStream)inputStream);
            List readAll = reader.readAll();
            for (int i = 0; i < readAll.size(); ++i) {
                reader = ExcelUtil.getReader((InputStream)inputStream, (int)i);
                reader.addHeaderAlias("\u7f16\u53f7", "num");
                reader.addHeaderAlias("\u641c\u7d22\u8bcd", "queryConditions");
                List excelDataBOS = reader.readAll(QueryAnalysisExcelDataBO.class);
                excelDataBOList.add(excelDataBOS);
            }
            arrayList = excelDataBOList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new InterruptedException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
            }
        }
        ((InputStream)inputStream).close();
        return arrayList;
    }

    public String getNowTime() {
        LocalDateTime nowDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.searchQaConfig.getTimeFormat());
        return nowDateTime.format(dateTimeFormatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExcel(File fileName, List<List<QueryAnalysisExcelDataBO>> excelDataBOList, String beforeFilename) throws Exception {
        log.info(beforeFilename + "  \u5171\u6709\uff1a" + excelDataBOList.size() + " sheet!");
        for (int i = 0; i < excelDataBOList.size(); ++i) {
            ExcelWriter writer = ExcelUtil.getWriter((File)fileName, (String)Integer.toString(i));
            log.info("\u7a7a\u5904\u7406\u524d\u6709: " + excelDataBOList.get(i).size());
            excelDataBOList.set(i, excelDataBOList.get(i).stream().filter(Objects::nonNull).collect(Collectors.toList()));
            log.info("\u7a7a\u5904\u7406\u540e\u6709: " + excelDataBOList.get(i).size());
            try {
                writer.addHeaderAlias("num", "\u7f16\u53f7");
                writer.addHeaderAlias("queryConditions", "\u641c\u7d22\u8bcd");
                writer.addHeaderAlias("participle", "\u5206\u8bcd\u7ed3\u679c");
                writer.addHeaderAlias("weigh", "\u76f8\u5173\u5ea6");
                writer.addHeaderAlias("commodityName", "\u5546\u54c1\u540d\u79f0");
                writer.addHeaderAlias("catalogAllName", "\u5546\u54c1\u7c7b\u76ee");
                writer.addHeaderAlias("analyzerCatalogIndexData", "\u7c7b\u76ee\u9884\u6d4b");
                writer.addHeaderAlias("reCallType", "reCallType");
                writer.addHeaderAlias("keyFieldsMatchRate", "keyFieldsMatchRate");
                writer.addHeaderAlias("fullTextMatchRate", "fullTextMatchRate");
                writer.addHeaderAlias("queryResultType", "queryResultType");
                writer.addHeaderAlias("remark", "\u5907\u6ce8");
                writer.addHeaderAlias("commodityNameParticiples", "\u5546\u54c1\u540d\u79f0\u5206\u8bcd");
                writer.setColumnWidth(excelDataBOList.get(i).size(), 15);
                writer.write((Iterable)excelDataBOList.get(i), true);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                continue;
            }
            finally {
                writer.close();
            }
        }
        QueryAnalysisFileUploadReqBO fileBo = new QueryAnalysisFileUploadReqBO();
        try (FileInputStream fis = new FileInputStream(fileName);
             ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
            int n;
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            byte[] data = bos.toByteArray();
            fileBo.setFile(data);
            fileBo.setFileName(beforeFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String url = this.queryAnalysisSingleService.fileUpload(fileBo);
        InsertFileDataBO insertFileDataBO = new InsertFileDataBO();
        insertFileDataBO.setId(Long.valueOf(new SnowflakeIdWorker(0L, 0L).nextId()));
        insertFileDataBO.setFilename(beforeFilename);
        insertFileDataBO.setFileurl(url);
        insertFileDataBO.setCategory("before");
        int num = this.queryAnalysisSingleService.insertFileData(insertFileDataBO);
        MultipartFileToFileUtil.delteTempFile((File)fileName);
    }
}

