/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.normalized.AnalyzerTokensService;
import com.tydic.se.search.normalized.TokensMatchIndexService;
import com.tydic.se.search.normalized.UccSearchTextNormalizationBusiService;
import com.tydic.se.search.normalized.bo.AnalyzerTokensReqBO;
import com.tydic.se.search.normalized.bo.AnalyzerTokensRspBO;
import com.tydic.se.search.normalized.bo.TextNormalizationReqBo;
import com.tydic.se.search.normalized.bo.TextNormalizationRspBo;
import com.tydic.se.search.normalized.bo.TokensMatchIndexReqBO;
import com.tydic.se.search.normalized.bo.TokensMatchIndexRspBO;
import com.tydic.se.search.sort.SearchCommodityPredictiveSortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.enumType.PredictiveSortMethodEnum;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="SearchCommodityPredictiveSortServiceImpl")
public class SearchCommodityPredictiveSortServiceImpl
implements SearchCommodityPredictiveSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityPredictiveSortServiceImpl.class);
    @Autowired
    private UccSearchTextNormalizationBusiService uccSearchTextNormalizationBusiService;
    @Autowired
    private AnalyzerTokensService analyzerTokensService;
    @Autowired
    @Qualifier(value="SearchSortForecastCategoryService")
    private TokensMatchIndexService forecastCategoryService;

    public SeSearchRspBO predictiveAnalysis(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            String time1 = SearchSortUtils.getNowTime();
            for (Map map : searchSortMsgBo.getPredictiveRankingMap()) {
                Map.Entry entry = map.entrySet().iterator().next();
                this.predictiveSort(rspBo, (List)entry.getValue(), PredictiveSortMethodEnum.getEumByCode((String)((String)entry.getKey())).getMethod());
            }
            log.info(SearchSortUtils.timeCalculation((String)"\u9884\u6d4b\u6392\u5e8f", (String)time1, (String)SearchSortUtils.getNowTime()));
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u9884\u6d4b\u5206\u6790\uff01", e});
            throw new SearchSortException("9999", "\u9884\u6d4b\u5206\u6790\uff01", (Throwable)e);
        }
    }

    private void predictiveSort(SeSearchRspBO rspBo, List<String> analyzerIndexData, String category) throws SearchSortException {
        try {
            if (analyzerIndexData == null) {
                return;
            }
            log.info("\u7c7b\u578b\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)category, analyzerIndexData);
            LinkedList seQuerySkuBOList = new LinkedList();
            LinkedList unSeQuerySkuBOList = new LinkedList();
            Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
            Method method = clazz.getDeclaredMethod(category, new Class[0]);
            LinkedList oldList = new LinkedList(rspBo.getSkuList());
            Type type = method.getGenericReturnType();
            if (type.equals(String.class)) {
                analyzerIndexData.forEach(parameter -> {
                    Iterator iterator = oldList.iterator();
                    while (iterator.hasNext()) {
                        SeQuerySkuBO seQuerySkuBO = (SeQuerySkuBO)iterator.next();
                        try {
                            String value = (String)method.invoke((Object)seQuerySkuBO, new Object[0]);
                            if (StringUtils.isEmpty((Object)value) || !value.equalsIgnoreCase((String)parameter)) continue;
                            seQuerySkuBOList.add(seQuerySkuBO);
                            iterator.remove();
                        }
                        catch (Exception e) {
                            throw new SearchSortException("9999", "\u9884\u6d4b\u5206\u6790\u6392\u5e8f\u7b5b\u9009\u9519\u8bef\uff01", (Throwable)e);
                        }
                    }
                });
            } else {
                analyzerIndexData.forEach(parameter -> {
                    Iterator iterator = oldList.iterator();
                    while (iterator.hasNext()) {
                        SeQuerySkuBO seQuerySkuBO = (SeQuerySkuBO)iterator.next();
                        try {
                            List values = (List)method.invoke((Object)seQuerySkuBO, new Object[0]);
                            int flag = 0;
                            if (!CollectionUtils.isEmpty((Collection)values)) {
                                for (String value : values) {
                                    if (!value.equalsIgnoreCase((String)parameter)) continue;
                                    ++flag;
                                }
                            }
                            if (flag == 0) continue;
                            seQuerySkuBOList.add(seQuerySkuBO);
                            iterator.remove();
                        }
                        catch (Exception e) {
                            throw new SearchSortException("9999", "\u9884\u6d4b\u5206\u6790\u6392\u5e8f\u7b5b\u9009\u9519\u8bef\uff01", (Throwable)e);
                        }
                    }
                });
            }
            seQuerySkuBOList.addAll(oldList);
            rspBo.setSkuList(seQuerySkuBOList);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u9884\u6d4b\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u9884\u6d4b\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    public SearchSortMsgBo predictiveDataEncapsulation(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        try {
            String time1 = SearchSortUtils.getNowTime();
            boolean judge = Boolean.TRUE;
            TextNormalizationReqBo normalizationReqBo = new TextNormalizationReqBo();
            normalizationReqBo.setQueryStr(searchSortMsgBo.getQueryStr());
            TextNormalizationRspBo normalizationRspBo = this.uccSearchTextNormalizationBusiService.normalization(normalizationReqBo);
            if (!CollectionUtils.isEmpty((Map)searchSortMsgBo.getCatalogAndOrderMap())) {
                TreeMap catalogAndOrderMap = new TreeMap(searchSortMsgBo.getCatalogAndOrderMap());
                ArrayList list = new ArrayList(catalogAndOrderMap.entrySet());
                list.sort(Map.Entry.comparingByValue());
                normalizationRspBo.getMatchResultMap().put("analyzerCatalogIndexService", list.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
                judge = Boolean.FALSE;
            }
            if (!normalizationRspBo.getMatchResultMap().containsKey("analyzerCatalogIndexService") || normalizationRspBo.getMatchResultMap().containsKey("analyzerCatalogIndexService") && ((List)normalizationRspBo.getMatchResultMap().get("analyzerCatalogIndexService")).size() == 0) {
                TokensMatchIndexReqBO tokensMatchIndexReqBO = new TokensMatchIndexReqBO();
                AnalyzerTokensReqBO analyzerTokensReqBO = new AnalyzerTokensReqBO();
                analyzerTokensReqBO.setTokens(searchSortMsgBo.getQueryStr());
                AnalyzerTokensRspBO analyzerTokensRspBO = this.analyzerTokensService.analyzer(analyzerTokensReqBO);
                tokensMatchIndexReqBO.setRows(analyzerTokensRspBO.getRows());
                List seQuerySkuBOList = rspBo.getSkuList();
                tokensMatchIndexReqBO.setResult(seQuerySkuBOList);
                tokensMatchIndexReqBO.setParamsMap(null);
                if (!CollectionUtils.isEmpty((Collection)analyzerTokensRspBO.getRows())) {
                    TokensMatchIndexRspBO tokensMatchIndexRspBO = this.forecastCategoryService.match(tokensMatchIndexReqBO);
                    log.info("\u7c7b\u76ee\u9884\u6d4b\u5206\u6790\u7ed3\u679c{}", (Object)tokensMatchIndexRspBO.getMatchBos());
                    normalizationRspBo.getMatchResultMap().put("analyzerCatalogIndexService", tokensMatchIndexRspBO.getMatchBos());
                } else {
                    log.info("\u8f93\u5165\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff0c\u7c7b\u76ee\u9884\u6d4b\u5206\u6790\u7ed3\u679c\u4e3a\u7a7a");
                    normalizationRspBo.getMatchResultMap().put("analyzerCatalogIndexService", new LinkedList());
                }
                normalizationRspBo.getMatchResultMap().put("analyzerCatalogIndexService", (List)normalizationRspBo.getMatchResultMap().get("analyzerCatalogIndexService"));
                searchSortMsgBo = this.proceduralIntervention(normalizationRspBo, searchSortMsgBo, judge);
            } else {
                searchSortMsgBo = this.proceduralIntervention(normalizationRspBo, searchSortMsgBo, judge);
            }
            rspBo.setL3CategoryPredictionResults((List)normalizationRspBo.getMatchResultMap().get("analyzerCatalogIndexService"));
            log.info(SearchSortUtils.timeCalculation((String)"\u6587\u672c\u5f52\u4e00\u670d\u52a1", (String)time1, (String)SearchSortUtils.getNowTime()));
        }
        catch (Exception e) {
            throw new SearchSortException("9999", "\u6587\u672c\u5f52\u4e00\u670d\u52a1\uff01", (Throwable)e);
        }
        return searchSortMsgBo;
    }

    private SearchSortMsgBo proceduralIntervention(TextNormalizationRspBo normalizationRspBo, SearchSortMsgBo searchSortMsgBo, boolean judge) {
        Iterator entries = normalizationRspBo.getMatchResultMap().entrySet().iterator();
        LinkedHashMap<String, List> dealResult = new LinkedHashMap<String, List>();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String typeKey = (String)entry.getKey();
            List typeValue = (List)entry.getValue();
            if (!judge && typeKey.equalsIgnoreCase("analyzerCatalogIndexService")) {
                dealResult.put(typeKey, typeValue);
                continue;
            }
            LinkedList<String> tmp = new LinkedList<String>();
            TreeMap map = new TreeMap(Comparator.reverseOrder());
            Iterator iterator = typeValue.iterator();
            while (iterator.hasNext()) {
                String str = (String)iterator.next();
                double flag = 0.0;
                if (str.equalsIgnoreCase(searchSortMsgBo.getQueryStr())) {
                    flag += (double)searchSortMsgBo.getQueryStrParticiple().size();
                }
                for (String s : searchSortMsgBo.getQueryStrParticiple()) {
                    double index;
                    if (str.contains(s)) {
                        flag += 1.0;
                    }
                    if (!((index = (double)str.indexOf(s)) > -1.0)) continue;
                    flag += index / (double)str.length();
                }
                if (flag == 0.0) continue;
                map.put(flag, str);
                iterator.remove();
            }
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                double key = (Double)iterator2.next();
                tmp.add((String)map.get(key));
            }
            tmp.addAll(typeValue);
            dealResult.put(typeKey, tmp);
        }
        normalizationRspBo.setMatchResultMap(dealResult);
        return this.setCallingOrder(normalizationRspBo, searchSortMsgBo, judge);
    }

    private SearchSortMsgBo setCallingOrder(final TextNormalizationRspBo normalizationRspBo, SearchSortMsgBo searchSortMsgBo, boolean judge) {
        searchSortMsgBo.setSortByMethod(new LinkedList());
        searchSortMsgBo.getSortByMethod().add("SearchCommodityRelevanceSortServiceImpl.relevanceSort");
        searchSortMsgBo.setPredictiveRankingMap(new LinkedList());
        searchSortMsgBo.getPredictiveRankingMap().add(new HashMap<String, List<String>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("analyzerVendorIndexService", (List)normalizationRspBo.getMatchResultMap().get("analyzerVendorIndexService"));
            }
        });
        searchSortMsgBo.getPredictiveRankingMap().add(new HashMap<String, List<String>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("analyzerBrandIndexService", (List)normalizationRspBo.getMatchResultMap().get("analyzerBrandIndexService"));
            }
        });
        if (judge) {
            if (((List)normalizationRspBo.getMatchResultMap().get("analyzerBrandIndexService")).size() != 0 || ((List)normalizationRspBo.getMatchResultMap().get("analyzerVendorIndexService")).size() != 0) {
                searchSortMsgBo.getSortByMethod().add("SearchCommodityPredictiveSortServiceImpl.predictiveAnalysis");
            } else {
                searchSortMsgBo.getSortByMethod().add(0, "SearchCommodityPredictiveSortServiceImpl.predictiveAnalysis");
            }
            searchSortMsgBo.getPredictiveRankingMap().add(0, new HashMap<String, List<String>>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("analyzerCatalogIndexService", (List)normalizationRspBo.getMatchResultMap().get("analyzerCatalogIndexService"));
                }
            });
        } else {
            searchSortMsgBo.getSortByMethod().add("SearchCommodityPredictiveSortServiceImpl.predictiveAnalysis");
            searchSortMsgBo.getPredictiveRankingMap().add(new HashMap<String, List<String>>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("analyzerCatalogIndexService", (List)normalizationRspBo.getMatchResultMap().get("analyzerCatalogIndexService"));
                }
            });
        }
        return searchSortMsgBo;
    }
}

