/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityCustomInterventionService;
import com.tydic.se.search.sort.SearchCommodityRelevanceSortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="SearchCommodityRelevanceSortServiceImpl")
public class SearchCommodityRelevanceSortServiceImpl
implements SearchCommodityRelevanceSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityRelevanceSortServiceImpl.class);
    @Value(value="${search.synonym.key:ucc_search_remote_synonym_cache_}")
    private String remoteSynonymRedisKey;
    @Value(value="${search.synonym.key:ucc_search_remote_correcting_cache_}")
    private String remoteCorrectingRedisKey;
    @Value(value="${search.synonym.followedBySynonyms:true}")
    private Boolean followedBySynonyms;
    @Value(value="${search.sort.giveUp:true}")
    private Boolean giveUp;
    @Value(value="${search.synonym.enable:true}")
    private Boolean synonymEnable;
    public static final String PROP_SEPA = "*~~";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchSortConfig searchSortConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchCommodityCustomInterventionService searchCommodityCustomInterventionService;

    public SeSearchRspBO relevanceSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            if (!this.searchSortConfig.getAllUseWeights().booleanValue() && rspBo.getReCallType().equals(2)) {
                rspBo.setQueryResultType("1");
                log.warn("\u5168\u6587\u68c0\u7d22\u4e0d\u9700\u8981\u6267\u884c\u76f8\u5173\u6027\u6392\u5e8f\uff01");
                return rspBo;
            }
            String time1 = SearchSortUtils.getNowTime();
            List<SeQuerySkuBO> relatedPass = new LinkedList<SeQuerySkuBO>();
            List<SeQuerySkuBO> related = new LinkedList<SeQuerySkuBO>();
            LinkedList irrelevant = new LinkedList();
            List<SeQuerySkuBO> seQuerySkuBOList = rspBo.getSkuList();
            TreeMap map = new TreeMap(Comparator.reverseOrder());
            List<Map<String, Double>> splitData = this.correlationData(searchSortMsgBo);
            log.info("\u76f8\u5173\u6027\u5339\u914d\u62c6\u5206\u6570\u636e\uff1a{}", splitData);
            seQuerySkuBOList.forEach(seQuerySkuBo -> {
                this.weigh(splitData, (SeQuerySkuBO)seQuerySkuBo, searchSortMsgBo);
                double flag = seQuerySkuBo.getWeight();
                if (this.getIrrelevantRatioLowest(flag).booleanValue()) {
                    irrelevant.add(seQuerySkuBo);
                } else {
                    this.manualInterventionWeigh((SeQuerySkuBO)seQuerySkuBo, searchSortMsgBo);
                    flag = seQuerySkuBo.getWeight();
                    if (!map.containsKey(flag)) {
                        map.put(flag, new LinkedList());
                    }
                    ((List)map.get(flag)).add(seQuerySkuBo);
                }
            });
            for (Map.Entry entry : map.entrySet()) {
                if (this.getIrrelevantRatioPass((Double)entry.getKey()).booleanValue()) {
                    relatedPass.addAll((Collection)entry.getValue());
                    continue;
                }
                related.addAll((Collection)entry.getValue());
            }
            if (this.followedBySynonyms.booleanValue()) {
                relatedPass = this.sameWeightsFollowedBySynonyms(relatedPass);
                related = this.sameWeightsFollowedBySynonyms(related);
            } else {
                relatedPass = this.weightsSynonymsLater(relatedPass);
                related = this.weightsSynonymsLater(related);
            }
            seQuerySkuBOList = relatedPass;
            if (!this.giveUp.booleanValue()) {
                seQuerySkuBOList.addAll(related);
            }
            if (relatedPass.size() > 0) {
                rspBo.setQueryResultType("0");
            } else if (related.size() > 0) {
                if (this.giveUp.booleanValue()) {
                    seQuerySkuBOList.addAll(related);
                }
                rspBo.setQueryResultType("1");
            } else {
                rspBo.setQueryResultType("2");
            }
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u5408\u683c\u6570\u636e{}\u6761\u6570\u636e\uff01", (Object)relatedPass.size());
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u53ef\u80fd\u76f8\u5173\u6570\u636e{}\u6761\u6570\u636e\uff01", (Object)related.size());
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u8fc7\u6ee4{}\u6761\u6570\u636e\uff01", (Object)irrelevant.size());
            log.info("\u76f8\u5173\u6027\u6392\u5e8f\u67e5\u8be2\u7ed3\u679c\u7c7b\u578b:{}", (Object)rspBo.getQueryResultType());
            rspBo.setSkuList(seQuerySkuBOList);
            log.info(SearchSortUtils.timeCalculation((String)"\u76f8\u5173\u6027\u6392\u5e8f", (String)time1, (String)SearchSortUtils.getNowTime()));
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u76f8\u5173\u5ea6\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u76f8\u5173\u5ea6\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    public ExecuteSearchRspBO categoryRelevanceSort(ExecuteSearchRspBO executeSearchRspBO, ExecuteSearchReqBO executeSearchReqBO) {
        if (!this.giveUp.booleanValue() || ObjectUtils.isEmpty((Object)executeSearchReqBO.getQueryStr())) {
            return executeSearchRspBO;
        }
        SearchSortMsgBo searchSortMsgBo = this.searchCommodityBaseService.initParameterCategory(executeSearchReqBO);
        HashMap<String, Map<String, Integer>> categoryFilterMap = new HashMap<String, Map<String, Integer>>();
        for (SeQueryFilterBO queryFilterBO : executeSearchRspBO.getQueryFilterList()) {
            HashMap<String, Integer> category = new HashMap<String, Integer>();
            for (String filterValue : queryFilterBO.getFilterValues()) {
                category.put(filterValue, 0);
            }
            categoryFilterMap.put(queryFilterBO.getFilterId(), category);
        }
        String properties = SearchSortUtils.parseProperties((Object)executeSearchReqBO, ExecuteSearchReqBO.class);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        esResultBO = SearchSortUtils.propertyFilter((SeEsResultBO)esResultBO, (String)properties);
        ArrayList skuList = new ArrayList();
        List hitsList = esResultBO.getHits().getHits();
        hitsList.forEach(hits -> skuList.add(hits.get_source()));
        List<Map<String, Double>> splitData = this.correlationData(searchSortMsgBo);
        for (SeQuerySkuBO seQuerySkuBo : skuList) {
            this.weigh(splitData, seQuerySkuBo, searchSortMsgBo);
            this.manualInterventionWeigh(seQuerySkuBo, searchSortMsgBo);
            double skuWeight = seQuerySkuBo.getWeight();
            if (Boolean.FALSE.equals(this.giveUp)) {
                if (!(skuWeight >= Double.parseDouble(this.searchSortConfig.getIrrelevantRatioLowest()))) continue;
                this.filterMarker(seQuerySkuBo, categoryFilterMap);
                continue;
            }
            if (!this.getIrrelevantRatioPass(skuWeight).booleanValue()) continue;
            this.filterMarker(seQuerySkuBo, categoryFilterMap);
        }
        List queryFilterList = executeSearchRspBO.getQueryFilterList().stream().peek(seQueryFilterBO -> {
            List filterValues = seQueryFilterBO.getFilterValues().stream().filter(s -> {
                if (((Integer)((Map)categoryFilterMap.get(seQueryFilterBO.getFilterId())).get(s)).equals(1)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }).collect(Collectors.toList());
            seQueryFilterBO.setFilterValues(filterValues);
        }).collect(Collectors.toList());
        executeSearchRspBO.setQueryFilterList(queryFilterList);
        return executeSearchRspBO;
    }

    private void filterMarker(SeQuerySkuBO seQuerySkuBO, Map<String, Map<String, Integer>> categoryFilterMap) {
        try {
            for (Map.Entry<String, Map<String, Integer>> entry : categoryFilterMap.entrySet()) {
                Field field;
                if (entry.getKey().contains(PROP_SEPA)) {
                    field = SeQuerySkuBO.class.getDeclaredField("properties");
                    field.setAccessible(true);
                    String properties = (String)field.get(seQuerySkuBO);
                    if (ObjectUtils.isEmpty((Object)properties)) continue;
                    for (Map.Entry<String, Integer> singleEntry : entry.getValue().entrySet()) {
                        String single = entry.getKey() + PROP_SEPA + singleEntry.getKey();
                        if (!properties.contains(single)) continue;
                        singleEntry.setValue(1);
                    }
                    continue;
                }
                field = SeQuerySkuBO.class.getDeclaredField(SearchSortUtils.lineToHump((String)entry.getKey()));
                field.setAccessible(true);
                Object generalValue = field.get(seQuerySkuBO);
                if (ObjectUtils.isEmpty((Object)generalValue)) continue;
                block4: for (Map.Entry<String, Integer> singleEntry : entry.getValue().entrySet()) {
                    if (generalValue instanceof List) {
                        List list = SearchSortUtils.castList((Object)generalValue, Object.class);
                        for (Object obj : list) {
                            if (!String.valueOf(obj).equalsIgnoreCase(singleEntry.getKey())) continue;
                            singleEntry.setValue(1);
                            continue block4;
                        }
                        continue;
                    }
                    if (!String.valueOf(generalValue).equalsIgnoreCase(singleEntry.getKey())) continue;
                    singleEntry.setValue(1);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("\u5c5e\u6027\u7b5b\u9009\u8fc7\u6ee4\u5f02\u5e38\uff01");
            e.printStackTrace();
        }
    }

    private Boolean getIrrelevantRatioPass(Double skuWeight) {
        return skuWeight >= Double.parseDouble(this.searchSortConfig.getIrrelevantRatioPass());
    }

    private Boolean getIrrelevantRatioLowest(Double skuWeight) {
        return skuWeight < Double.parseDouble(this.searchSortConfig.getIrrelevantRatioLowest());
    }

    private void weigh(List<Map<String, Double>> splitData, SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        try {
            if (searchSortMsgBo.getQueryStrParticiple().size() != 0) {
                AtomicReference<Double> flag = new AtomicReference<Double>(0.0);
                if ("null".equals(this.searchSortConfig.getRelevanceFieldMatching())) {
                    throw new Exception("\u8bf7\u914d\u7f6e\u76f8\u5173\u5ea6\u5339\u914d\u5b57\u6bb5\uff01");
                }
                if ("null".equals(this.searchSortConfig.getRelevanceChineseFieldMatching())) {
                    throw new Exception("\u8bf7\u914d\u7f6e\u76f8\u5173\u5ea6\u4e2d\u6587\u5339\u914d\u5b57\u6bb5\uff01");
                }
                String[] fields = this.searchSortConfig.getRelevanceFieldMatching().split(",");
                String[] chineseFields = this.searchSortConfig.getRelevanceChineseFieldMatching().split(",");
                Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                StringBuilder stringBuilderChinese = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                this.correlationStringPackaging(seQuerySkuBO, chineseFields, clazz, stringBuilderChinese);
                this.correlationStringPackaging(seQuerySkuBO, fields, clazz, stringBuilder);
                stringBuilder.append((CharSequence)stringBuilderChinese);
                LinkedList<String> weightDesc = new LinkedList<String>();
                seQuerySkuBO.setWeight(Double.valueOf(0.0));
                seQuerySkuBO.setSynonymWeight(Double.valueOf(0.0));
                splitData.forEach(maps -> {
                    boolean judge = Boolean.TRUE;
                    for (Map.Entry<String, Double> entry : maps.entrySet()) {
                        double tmp = this.checkNotExistChinese(searchSortMsgBo.getQueryStr()) ? this.singleWordWeight(seQuerySkuBO, stringBuilder.toString(), entry) : this.singleWordWeight(seQuerySkuBO, stringBuilderChinese.toString(), entry);
                        if (tmp != 0.0 && judge) {
                            flag.updateAndGet(v -> v + tmp);
                            weightDesc.add(entry.getKey() + ":" + entry.getValue());
                            break;
                        }
                        judge = Boolean.FALSE;
                        flag.updateAndGet(v -> v + tmp);
                        if (tmp == 0.0) continue;
                        weightDesc.add(entry.getKey() + ":" + entry.getValue());
                    }
                });
                Field field = clazz.getDeclaredField(this.searchSortConfig.getSeQuerySkuName());
                field.setAccessible(true);
                if (field.get(seQuerySkuBO).toString().toLowerCase().contains(searchSortMsgBo.getQueryStr().toLowerCase())) {
                    flag.updateAndGet(v -> v + 1.0);
                    weightDesc.add("\u5546\u54c1\u540d\u4e2d\u5b58\u5728:1.0");
                }
                seQuerySkuBO.setWeightDesc(String.join((CharSequence)" , ", weightDesc));
                seQuerySkuBO.setWeight(flag.get());
            } else {
                seQuerySkuBO.setWeightDesc("\u4e0d\u8ba1\u7b97\u6743\u503c\uff01");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6743\u503c\u8ba1\u7b97\uff01", e});
            throw new SearchSortException("9999", "\u6743\u503c\u8ba1\u7b97\uff01", (Throwable)e);
        }
    }

    private double singleWordWeight(SeQuerySkuBO seQuerySkuBO, String featureString, Map.Entry<String, Double> entry) {
        if (featureString.toLowerCase(Locale.ROOT).contains(entry.getKey().toLowerCase(Locale.ROOT))) {
            return entry.getValue();
        }
        if (!this.synonymEnable.booleanValue()) {
            return 0.0;
        }
        Object sync = this.cacheClient.get(this.remoteSynonymRedisKey + entry.getKey());
        Object correct = this.cacheClient.get(this.remoteCorrectingRedisKey + entry.getKey());
        StringBuilder synonymCorrect = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)sync)) {
            SeCorrectionBO syncSeCorrectionBO = (SeCorrectionBO)JSON.parseObject((String)sync.toString(), SeCorrectionBO.class);
            synonymCorrect.append(ObjectUtils.isEmpty((Object)syncSeCorrectionBO.getSynonymList()) ? "" : syncSeCorrectionBO.getSynonymList());
        }
        synonymCorrect.append(",");
        if (!ObjectUtils.isEmpty((Object)correct)) {
            SeCorrectionBO correctSeCorrectionBO = (SeCorrectionBO)JSON.parseObject((String)correct.toString(), SeCorrectionBO.class);
            synonymCorrect.append(ObjectUtils.isEmpty((Object)correctSeCorrectionBO.getCorrectionList()) ? "" : correctSeCorrectionBO.getCorrectionList());
        }
        if (StringUtils.isBlank((CharSequence)synonymCorrect.toString())) {
            return 0.0;
        }
        CharSequence[] synonymList = synonymCorrect.toString().split(",");
        for (int i = 0; i < synonymList.length; ++i) {
            boolean exist = featureString.toLowerCase(Locale.ROOT).contains(synonymList[i].toLowerCase(Locale.ROOT));
            if (!exist) continue;
            int n = i;
            synonymList[n] = synonymList[n] + "(" + entry.getValue() + ")";
            seQuerySkuBO.setSynonymWeightDesc(seQuerySkuBO.getSynonymWeightDesc() + (ObjectUtils.isEmpty((Object)seQuerySkuBO.getSynonymWeightDesc()) ? "" : ",") + String.join((CharSequence)",", synonymList));
            seQuerySkuBO.setSynonymWeight(Double.valueOf((ObjectUtils.isEmpty((Object)seQuerySkuBO.getSynonymWeight()) ? 0.0 : seQuerySkuBO.getSynonymWeight()) + 1.0));
            return entry.getValue();
        }
        return 0.0;
    }

    private void correlationStringPackaging(SeQuerySkuBO seQuerySkuBO, String[] fields, Class<SeQuerySkuBO> clazz, StringBuilder stringBuilder) {
        try {
            for (String fieldName : fields) {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                Type type = field.getGenericType();
                String pattern = "java.util.List<.*>";
                boolean isMatch = Pattern.matches(pattern, type.getTypeName());
                if (isMatch) {
                    List value = (List)field.get(seQuerySkuBO);
                    StringBuilder sb = new StringBuilder();
                    if (!ObjectUtils.isEmpty((Object)value)) {
                        value.forEach(element -> sb.append(String.valueOf(element)));
                    }
                    stringBuilder.append(ObjectUtils.isEmpty((Object)value) ? "" : sb.toString() + ",");
                    continue;
                }
                stringBuilder.append(ObjectUtils.isEmpty((Object)field.get(seQuerySkuBO)) ? "" : field.get(seQuerySkuBO) + ",");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5c5e\u6027\u9519\u8bef\uff01", e});
            throw new SearchSortException("9999", "\u5c5e\u6027\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    private List<SeQuerySkuBO> sameWeightsFollowedBySynonyms(List<SeQuerySkuBO> seQuerySkuBOList) {
        return seQuerySkuBOList.stream().sorted(new Comparator<SeQuerySkuBO>(){

            @Override
            public int compare(SeQuerySkuBO o1, SeQuerySkuBO o2) {
                if (o1.getWeight().equals(o2.getWeight())) {
                    return o2.getSynonymWeight().compareTo(o1.getSynonymWeight());
                }
                return Double.compare(o2.getWeight(), o1.getWeight());
            }
        }).collect(Collectors.toList());
    }

    private List<SeQuerySkuBO> weightsSynonymsLater(List<SeQuerySkuBO> seQuerySkuBOList) {
        List<SeQuerySkuBO> noSynonyms = seQuerySkuBOList.stream().filter(seQuerySkuBO -> seQuerySkuBO.getSynonymWeight() == 0.0).collect(Collectors.toList());
        List synonyms = seQuerySkuBOList.stream().filter(seQuerySkuBO -> seQuerySkuBO.getSynonymWeight() != 0.0).collect(Collectors.toList());
        noSynonyms.addAll(synonyms);
        return noSynonyms;
    }

    private void manualInterventionWeigh(SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        List queryStrParticiple = searchSortMsgBo.getQueryStrParticiple();
        double basicPoints = seQuerySkuBO.getWeight();
        if (queryStrParticiple.size() != 0) {
            AtomicReference<Double> flag = new AtomicReference<Double>(basicPoints);
            flag.updateAndGet(v -> v + this.searchCommodityCustomInterventionService.locationJudgmentLast(seQuerySkuBO, searchSortMsgBo));
            flag.updateAndGet(v -> v + this.searchCommodityCustomInterventionService.locationJudgmentSpecialChar(seQuerySkuBO, searchSortMsgBo));
            seQuerySkuBO.setWeight(flag.get());
        }
    }

    private List<Map<String, Double>> correlationData(SearchSortMsgBo searchSortMsgBo) {
        LinkedList<Map<String, Double>> list = new LinkedList<Map<String, Double>>();
        for (String name : searchSortMsgBo.getQueryStrParticiple()) {
            char[] chars;
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            map.put(name, 1.0 / (double)searchSortMsgBo.getQueryStrParticiple().size());
            for (char c : chars = name.toCharArray()) {
                map.put(String.valueOf(c), 1.0 / (double)searchSortMsgBo.getQueryStrParticiple().size() * this.searchSortConfig.getBitwiseCorrelationWeight() / (double)chars.length);
            }
            list.add(map);
        }
        return list;
    }

    private boolean checkNotExistChinese(String name) {
        char n = '\u0000';
        for (int i = 0; i < name.length(); ++i) {
            n = name.charAt(i);
            if ('\u4e00' > n || n >= '\u9fa5') continue;
            return false;
        }
        return true;
    }
}

