/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityDefaultSortService;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.SearchCommoditySortService;
import com.tydic.se.search.sort.SearchCommoditySpecifySortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SearchCommoditySortServiceImpl
implements SearchCommoditySortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommoditySortServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchSortConfig searchSortConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchCommodityDefaultSortService searchCommodityDefaultSortService;
    @Autowired
    private SearchCommoditySpecifySortService searchCommoditySpecifySortService;
    @Autowired
    private SearchCommodityRedisDataService searchCommodityRedisDataService;
    @Value(value="${search.synonym.key:ucc_search_remote_synonym_cache_}")
    private String remoteSynonymRedisKey;
    @Value(value="${search.synonym.key:ucc_search_remote_correcting_cache_}")
    private String remoteCorrectingRedisKey;
    @Value(value="${search.synonym.display:true}")
    private Boolean synonymDisplay;

    public SeSearchRspBO commoditySorting(SeSearchReqBO reqBO, SeSearchRspBO rspBo) throws SearchSortException {
        SearchSortMsgBo searchSortMsgBo = this.searchCommodityBaseService.initParameter(reqBO);
        rspBo.setSynonymMap(new LinkedHashMap());
        if (Boolean.TRUE.equals(this.synonymDisplay)) {
            this.initSynonymMap(rspBo, searchSortMsgBo);
        }
        Boolean seComSortExist = searchSortMsgBo.getComSortList().stream().anyMatch(seComSortBO -> "_score".equals(seComSortBO.getOrderByColumn()));
        Boolean seComSortPosition = !searchSortMsgBo.getComSortList().isEmpty() && "_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn());
        try {
            if (StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr()) && Boolean.TRUE.equals(seComSortExist) && Boolean.TRUE.equals(seComSortPosition)) {
                log.info("\u9ed8\u8ba4\u67e5\u8be2\u5546\u54c1\uff01\uff01");
                if (searchSortMsgBo.getRedisEnabled().booleanValue() && this.searchSortConfig.getRedisUse().booleanValue() && !CollectionUtils.isEmpty((Collection)searchSortMsgBo.getSessionIdKeySet())) {
                    log.info("\u6709\u7f13\u5b58\uff01");
                    searchSortMsgBo.setSessionIdKey((String)searchSortMsgBo.getSessionIdKeySet().toArray()[0]);
                    rspBo = this.searchCommodityRedisDataService.readCache(searchSortMsgBo);
                } else {
                    log.info("\u65e0\u7f13\u5b58\uff01");
                    rspBo = this.searchCommodityDefaultSortService.defaultQuerySort(reqBO, rspBo, searchSortMsgBo);
                }
                log.info("redis\u53ef\u7528\u6027:{},redisUse\uff1a{},\u7f13\u5b58\u6570\u91cf:{}", new Object[]{searchSortMsgBo.getRedisEnabled(), this.searchSortConfig.getRedisUse(), CollectionUtils.isEmpty((Collection)searchSortMsgBo.getSessionIdKeySet()) ? 0 : searchSortMsgBo.getSessionIdKeySet().size()});
            } else {
                log.info("\u67e5\u8be2\u4e3a{},\u6392\u5e8f\u5224\u65ad\u4e3a{}-{},\u4e0d\u9700\u8981\u9ed8\u8ba4\u6392\u5e8f\uff01", new Object[]{searchSortMsgBo.getQueryStr(), seComSortExist, seComSortPosition});
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u9ed8\u8ba4\u67e5\u8be2\u5546\u54c1\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", e});
            throw new SearchSortException("9999", "\u9ed8\u8ba4\u67e5\u8be2\u5546\u54c1\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", (Throwable)e);
        }
        try {
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) || searchSortMsgBo.isSalesPriceJudge()) {
                log.info("\u6307\u5b9a\u6392\u5e8f\uff01\uff01");
                rspBo = this.searchCommoditySpecifySortService.specifySort(rspBo, searchSortMsgBo);
                log.info("\u6307\u5b9a\u6392\u5e8f\u540e\u5546\u54c1\u6570\u91cf\uff1a" + rspBo.getSkuList().size());
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u67e5\u8be2\u6307\u5b9a\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", e});
            throw new SearchSortException("9999", "\u67e5\u8be2\u6307\u5b9a\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", (Throwable)e);
        }
        try {
            return this.searchCommodityRedisDataService.dataEncapsulation(rspBo, reqBO);
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u5c01\u88c5\uff01", e});
            throw new SearchSortException("9999", "\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
        }
    }

    private void initSynonymMap(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        for (String query : searchSortMsgBo.getQueryStrParticiple()) {
            SeCorrectionBO seCorrectionBO;
            Object sync = this.cacheClient.get(this.remoteSynonymRedisKey + query);
            if (!ObjectUtils.isEmpty((Object)sync)) {
                seCorrectionBO = (SeCorrectionBO)JSON.parseObject((String)sync.toString(), SeCorrectionBO.class);
                rspBo.getSynonymMap().put("synonym:" + query, JSON.toJSONString((Object)seCorrectionBO));
            }
            if (ObjectUtils.isEmpty((Object)(sync = this.cacheClient.get(this.remoteCorrectingRedisKey + query)))) continue;
            seCorrectionBO = (SeCorrectionBO)JSON.parseObject((String)sync.toString(), SeCorrectionBO.class);
            rspBo.getSynonymMap().put("correct:" + query, JSON.toJSONString((Object)seCorrectionBO));
        }
    }
}

