/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.ability.bo.SeEsOldResultBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.nlp.intfs.EntityRecognitionService;
import com.tydic.se.nlp.req.EntityRecognitionReqBo;
import com.tydic.se.nlp.rsp.EntityRecognitionRspBo;
import com.tydic.se.nlp.rsp.NerDataRspBo;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.constants.SeSearchConstants;
import com.tydic.se.search.job.AnyTrustStrategy;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.bo.AccurateQueryBO;
import com.tydic.se.search.job.bo.DarticipleQueryBO;
import com.tydic.se.search.job.bo.DarticipleQueryReader;
import com.tydic.se.search.job.bo.EsAnalyzeQueryBO;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SeQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SeQueryBuilder.class);
    @Value(value="${es.index_name:commodity_index}")
    private String INDEX_NAME;
    @Value(value="${es.config.addresses}")
    private String ADDRESSES;
    @Value(value="${es.config.username}")
    private String USERNAME;
    @Value(value="${es.config.password}")
    private String PASSWORD;
    @Value(value="${es.fields:commodity_name^10.0,sku_name^10.0,brand_name^12.0,type_name^5.0,supplier_name^10.0,l2_category_name^7.0,l3_category_name^10.0,l4mg_category_name^1.0,sku_code^5.0,ext_sku_id^5.0,figure^1.0,manufacturer^1.0,material_name^1.0,model^1.0,properties^1.0}")
    private String FIELDS_STR;
    @Value(value="${es.accurate.fields:L4mg_category_id,agreement_id,agreement_details_id,brand_id,channel_id,commodity_id,material_id,labelIds,skuPoolIds,sku_id,commodity_code,l1_category_id,l2_category_id,l3_category_id,material_code,sku_code}")
    private String LONG_ACCURATE_FIELDS_STR;
    @Value(value="${es.accurate.fields:ext_sku_id.keyword,ext_spu_id.keyword,sku_name.keyword,commodity_name.keyword,brand_name.keyword,l3_category_name.keyword,properties.keyword}")
    private String ACCURATE_FIELDS_STR;
    @Autowired
    private EntityRecognitionService entityRecognitionService;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        if (executeSearchReqBO.getQueryStr() == null) {
            executeSearchReqBO.setQueryStr("");
        }
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        darticipleQueryReader.setQuery(executeSearchReqBO.getQueryStr());
        darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        darticipleQueryReader.setZero_terms_query("NONE");
        darticipleQueryReader.setMinimum_should_match("55%");
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        darticipleQueryBO.init(darticipleQueryReader);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = this.elasticsearchUtil.postEsSearch(this.INDEX_NAME, esQueryBody);
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setResult(esResult);
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ExecuteSearchRspBO executeSearch(ExecuteSearchReqBO executeSearchReqBO) {
        if (StringUtils.isEmpty((CharSequence)executeSearchReqBO.getQueryStr())) {
            executeSearchReqBO.setSearchType("L2");
        }
        return this.search(executeSearchReqBO);
    }

    private ExecuteSearchRspBO search(ExecuteSearchReqBO executeSearchReqBO) {
        if (StringUtils.isEmpty((CharSequence)executeSearchReqBO.getQueryStr())) {
            executeSearchReqBO.setQueryStr("");
        }
        if (executeSearchReqBO.getSearchType() == null) {
            executeSearchReqBO.setSearchType("L1");
        }
        DarticipleQueryBO darticipleQueryBO = this.initDarticipleQueryBO(executeSearchReqBO);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = this.elasticsearchUtil.postEsSearch(this.INDEX_NAME, esQueryBody);
        SeEsResultBO esResultBO = new SeEsResultBO();
        try {
            esResultBO = (SeEsResultBO)JSONObject.parseObject((String)esResult, SeEsResultBO.class);
        }
        catch (Exception e) {
            SeEsOldResultBO seEsOldResultBO = (SeEsOldResultBO)JSONObject.parseObject((String)esResult, SeEsOldResultBO.class);
            Integer totalValue = seEsOldResultBO.getHits().getTotal();
            seEsOldResultBO.getHits().setTotal(null);
            String newEsResult = JSON.toJSONString((Object)seEsOldResultBO);
            esResultBO = (SeEsResultBO)JSONObject.parseObject((String)newEsResult, SeEsResultBO.class);
            SeEsResultBO.Hits.Total total = new SeEsResultBO.Hits.Total(esResultBO.getHits());
            total.setValue(totalValue);
            esResultBO.getHits().setTotal(total);
        }
        if (esResultBO.getHits().getTotal().getValue() == 0 && "L1".equals(executeSearchReqBO.getSearchType())) {
            executeSearchReqBO.setSearchType("L2");
            return this.search(executeSearchReqBO);
        }
        if (esResultBO.getHits().getTotal().getValue() == 0 && "L2".equals(executeSearchReqBO.getSearchType())) {
            executeSearchReqBO.setSearchType("L3");
            return this.search(executeSearchReqBO);
        }
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setEsResultBO(esResultBO);
        rspBO.setResult(esResult);
        rspBO.setSearchType(executeSearchReqBO.getSearchType());
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    private Map<String, String> parseEntityMap(String queryStr, List<SeTermsBO> mustTermsList) {
        EntityRecognitionReqBo entityRecognitionReqBo = new EntityRecognitionReqBo();
        entityRecognitionReqBo.setQueryStr(queryStr);
        EntityRecognitionRspBo entityRecognitionRspBo = this.entityRecognitionService.doNer(entityRecognitionReqBo);
        HashMap<String, String> entityMap = new HashMap<String, String>();
        String common = "common";
        entityMap.put(common, queryStr);
        if (entityRecognitionRspBo != null && entityRecognitionRspBo.getNerList() != null) {
            for (NerDataRspBo nerDataRspBo : entityRecognitionRspBo.getNerList()) {
                if (this.verifyEffectEntity(SeSearchConstants.EntityRecognition.CATEGORY_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) {
                    String lv2Category = "l2_category";
                    if (entityMap.containsKey(lv2Category)) {
                        entityMap.put(lv2Category, (String)entityMap.get(lv2Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv2Category, nerDataRspBo.getWord());
                    }
                    String lv3Category = "l3_category";
                    if (entityMap.containsKey(lv3Category)) {
                        entityMap.put(lv3Category, (String)entityMap.get(lv3Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv3Category, nerDataRspBo.getWord());
                    }
                    String lv4Category = "l4mg_category";
                    if (entityMap.containsKey(lv4Category)) {
                        entityMap.put(lv4Category, (String)entityMap.get(lv4Category) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(lv4Category, nerDataRspBo.getWord());
                    continue;
                }
                if (this.verifyEffectEntity(SeSearchConstants.EntityRecognition.BRAND_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) {
                    String brand = "brand";
                    if (entityMap.containsKey(brand)) {
                        entityMap.put(brand, (String)entityMap.get(brand) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(brand, nerDataRspBo.getWord());
                    continue;
                }
                if (!this.verifyEffectEntity(SeSearchConstants.EntityRecognition.VENDOR_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) continue;
                String vendor = "vendor";
                if (entityMap.containsKey(vendor)) {
                    entityMap.put(vendor, (String)entityMap.get(vendor) + "," + nerDataRspBo.getWord());
                    continue;
                }
                entityMap.put(vendor, nerDataRspBo.getWord());
            }
        }
        return entityMap;
    }

    private Boolean verifyEffectEntity(List<String> list, String tag, List<SeTermsBO> mustTermsList) {
        if (list.contains(tag)) {
            if (mustTermsList != null && this.containsName(mustTermsList, tag)) {
                return false;
            }
            return true;
        }
        return false;
    }

    private List<SeTermsBO> parseTempTermsList(Map<String, String> entityMap) {
        HashMap<String, SeTermsBO> termsBOMap = new HashMap<String, SeTermsBO>();
        for (String key : entityMap.keySet()) {
            SeTermsBO termsBO;
            String[] categoryArr = entityMap.get(key).split(",");
            Map<String, String> singleMap = SeEntityCache.getEntityCacheMap().get(key);
            if (categoryArr == null || singleMap == null || (termsBO = this.parseTerms(key, categoryArr, singleMap)) == null) continue;
            termsBOMap.put(key, termsBO);
        }
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        if (termsBOMap.containsKey(lv4Category)) {
            termsBOMap.remove(lv2Category);
            termsBOMap.remove(lv3Category);
        } else if (termsBOMap.containsKey(lv3Category)) {
            termsBOMap.remove(lv2Category);
        }
        ArrayList<SeTermsBO> termsBOList = new ArrayList<SeTermsBO>();
        for (SeTermsBO termsBO : termsBOMap.values()) {
            termsBOList.add(termsBO);
        }
        return termsBOList;
    }

    private SeTermsBO parseTerms(String key, String[] categoryArr, Map<String, String> cacheMap) {
        ArrayList<String> valueList = new ArrayList<String>();
        String valueStr = "";
        for (String category : categoryArr) {
            if (!cacheMap.containsKey(category)) continue;
            valueStr = StringUtils.isNotBlank((CharSequence)valueStr) ? valueStr + "," + cacheMap.get(category) : cacheMap.get(category);
        }
        valueList.add(valueStr);
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            SeTermsBO termsBO = new SeTermsBO(key + "_id", valueList);
            return termsBO;
        }
        return null;
    }

    private Map<String, String> matchTerms(Map<String, String> entityMap, List<SeTermsBO> tempTermsList) {
        String value;
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(lv3Category) && !this.containsName(tempTermsList, lv2Category) && !this.containsName(tempTermsList, lv3Category) && !this.containsName(tempTermsList, lv4Category)) {
            value = entityMap.get(lv3Category);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(brand) && !this.containsName(tempTermsList, brand)) {
            value = entityMap.get(brand);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(vendor) && !this.containsName(tempTermsList, vendor)) {
            value = entityMap.get(vendor);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        return entityMap;
    }

    private DarticipleQueryBO initDarticipleQueryBO(ExecuteSearchReqBO executeSearchReqBO) {
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        if (executeSearchReqBO.getFrom() != null) {
            darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        }
        if (executeSearchReqBO.getSize() != null) {
            darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        }
        List<String> catalogIdList = SeEntityCache.getCatalogIdList();
        ArrayList<String> list = new ArrayList<String>();
        List termsList1 = darticipleQueryReader.getTermsList();
        for (SeTermsBO seTermsBO : termsList1) {
            list.add(seTermsBO.getName());
        }
        ArrayList<String> list1 = new ArrayList<String>();
        List mustTermsList = executeSearchReqBO.getMustTermsList();
        List termsList = null;
        if (mustTermsList != null) {
            termsList = mustTermsList;
            for (SeTermsBO seTermsBO : mustTermsList) {
                list1.add(seTermsBO.getName());
            }
            if (StringUtils.isEmpty((CharSequence)executeSearchReqBO.getQueryStr()) && list.containsAll(list1) && catalogIdList.size() > 0 && executeSearchReqBO.getCheckBlankQueryStr().booleanValue()) {
                termsList.add(new SeTermsBO("l3_category_id", catalogIdList));
            }
        } else {
            termsList = termsList1;
        }
        darticipleQueryReader.setTermsList(termsList);
        List notTermsList = null;
        notTermsList = executeSearchReqBO.getMustNotTermsList() != null ? executeSearchReqBO.getMustNotTermsList() : darticipleQueryReader.getNotTermsList();
        darticipleQueryReader.setNotTermsList(notTermsList);
        darticipleQueryReader.setIsAggregation(executeSearchReqBO.getIsAggregation());
        String queryStr = executeSearchReqBO.getQueryStr();
        String[] fieldArr = null;
        ArrayList<String> fields = new ArrayList<String>();
        if (StringUtils.isNumeric((CharSequence)queryStr)) {
            String[] split;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String field : fieldArr = this.ACCURATE_FIELDS_STR.split(",")) {
                map.put(field, "*" + queryStr + "*");
            }
            HashMap<String, String> longMap = new HashMap<String, String>();
            for (String s : split = this.LONG_ACCURATE_FIELDS_STR.split(",")) {
                longMap.put(s, queryStr);
            }
            darticipleQueryReader.setShould(map);
            darticipleQueryReader.setLondShould(longMap);
            darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
        } else if ("L1".equals(executeSearchReqBO.getSearchType())) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String field : fieldArr = this.ACCURATE_FIELDS_STR.split(",")) {
                map.put(field, "*" + queryStr + "*");
            }
            darticipleQueryReader.setShould(map);
            darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
        } else {
            for (String field : fieldArr = this.FIELDS_STR.split(",")) {
                fields.add(field);
            }
            darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
        }
        darticipleQueryReader.setFields(fields);
        darticipleQueryReader.setQuery(queryStr);
        darticipleQueryReader.setProperties(executeSearchReqBO.getProperties());
        darticipleQueryReader.setShouldList(executeSearchReqBO.getShouldList());
        darticipleQueryBO.init(darticipleQueryReader);
        return darticipleQueryBO;
    }

    private boolean containsName(List<SeTermsBO> tempTermsList, String name) {
        for (SeTermsBO termsBO : tempTermsList) {
            if (!termsBO.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> reduceEntityMap(Map<String, String> entityMap) {
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(brand)) {
            entityMap.remove(brand);
            return entityMap;
        }
        if (entityMap.containsKey(vendor)) {
            entityMap.remove(vendor);
            return entityMap;
        }
        if (entityMap.containsKey(lv4Category)) {
            entityMap.remove(lv4Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv3Category)) {
            entityMap.remove(lv3Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv2Category)) {
            entityMap.remove(lv2Category);
            return entityMap;
        }
        entityMap = new HashMap<String, String>();
        entityMap.put(common, "");
        return entityMap;
    }

    private boolean queryAgain(SeEsResultBO esResultBO, Map<String, String> entityMap) {
        if (esResultBO != null && esResultBO.getHits() != null && esResultBO.getHits().getTotal().getValue() == 0) {
            return entityMap != null && entityMap.size() > 1;
        }
        return false;
    }

    private String parseContent(DarticipleQueryBO darticipleQueryBO) {
        String content = JSON.toJSONString((Object)darticipleQueryBO);
        return content;
    }

    private String parseContentAccurateQueryBO(AccurateQueryBO accurateQueryBO) {
        String content = JSON.toJSONString((Object)accurateQueryBO);
        return content;
    }

    public String sendPost(String esQueryBody) {
        String resultCode = "";
        try {
            Long startTime = System.currentTimeMillis();
            String url = new StringBuffer().append("http://").append(this.ADDRESSES).append("/").append(this.INDEX_NAME).append("/_search").toString();
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, (TrustStrategy)new AnyTrustStrategy()).build();
            SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = registryBuilder.register("https", (Object)sslSF).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
            CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            HttpPost httpPost = new HttpPost(url);
            StringEntity uefEntity = new StringEntity(esQueryBody, "UTF-8");
            uefEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)uefEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            if (response != null) {
                if (200 != response.getStatusLine().getStatusCode()) {
                    resultCode = "";
                } else {
                    HttpEntity entity = response.getEntity();
                    resultCode = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
                    EntityUtils.consume((HttpEntity)entity);
                    response.close();
                }
            } else {
                resultCode = "";
            }
            Long endTime = System.currentTimeMillis();
            log.info("\u672c\u6b21es\u67e5\u8be2\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms\uff0cesQueryBody:" + esQueryBody);
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
        }
        return resultCode;
    }

    public String postEsAnalyze(EsAnalyzeQueryBO esAnalyzeQueryBO) {
        String esQueryBody = JSON.toJSONString((Object)esAnalyzeQueryBO);
        String esResult = this.elasticsearchUtil.postEsAnalyze(this.INDEX_NAME, esQueryBody);
        return esResult;
    }
}

