/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.qa.impl;

import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.search.qa.bo.InsertFileDataBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisFileUploadReqBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisFilesListReqBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisReqBO;
import com.tydic.se.base.ability.search.qa.bo.rsp.QueryAnalysisFileRspBO;
import com.tydic.se.base.ability.search.qa.bo.rsp.QueryAnalysisFilesListRspBO;
import com.tydic.se.base.ability.search.qa.bo.rsp.QueryAnalysisRspBO;
import com.tydic.se.base.dao.QueryAnalysisFilesListMapper;
import com.tydic.se.base.dao.po.QueryAnalysisFilesListPO;
import com.tydic.se.search.qa.QueryAnalysisService;
import com.tydic.se.search.qa.QueryAnalysisSingleAtomService;
import com.tydic.se.search.qa.config.SearchQaConfig;
import com.tydic.se.search.qa.impl.ExecutorProcessPool;
import com.tydic.se.search.qa.impl.SearchQaAsyncTask;
import com.tydic.se.search.qa.impl.SnowflakeIdWorker;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class QueryAnalysisServiceImpl
implements QueryAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(QueryAnalysisServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(QueryAnalysisServiceImpl.class);
    @Autowired
    SearchQaAsyncTask searchQaAsyncTask;
    @Autowired
    SearchQaConfig searchQaConfig;
    @Autowired
    QueryAnalysisFilesListMapper queryAnalysisFilesListMapper;
    @Autowired
    QueryAnalysisSingleAtomService queryAnalysisSingleAtomService;

    public QueryAnalysisRspBO fileUpload(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) {
        try {
            if (!ObjectUtils.isEmpty((Object)queryAnalysisFileUploadReqBO.getFile())) {
                return this.saveAfterFile(queryAnalysisFileUploadReqBO);
            }
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
            queryAnalysisRspBO.setRespCode("9999");
            queryAnalysisRspBO.setRespDesc(e.getMessage());
            return queryAnalysisRspBO;
        }
    }

    public QueryAnalysisRspBO fileAnalysisReturnList(QueryAnalysisReqBO queryAnalysisReqBO) {
        return null;
    }

    public QueryAnalysisRspBO saveAfterFile(final QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) {
        QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
        try {
            String snowflakes = Long.toString(new SnowflakeIdWorker(0L, 0L).nextId());
            String[] files = queryAnalysisFileUploadReqBO.getFileName().split("\\.");
            String fileType = files[files.length - 1];
            String afterFilename = this.searchQaAsyncTask.getNowTime() + "_" + snowflakes + "_" + queryAnalysisFileUploadReqBO.getFileName();
            String afterFilenameDfs = this.searchQaAsyncTask.getNowTime() + "_" + snowflakes + "." + fileType;
            final String beforeFilename = this.searchQaAsyncTask.getNowTime() + "_" + snowflakes + "_" + queryAnalysisFileUploadReqBO.getFileName();
            final String beforeFilenameDfs = this.searchQaAsyncTask.getNowTime() + "_" + snowflakes + "." + fileType;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        QueryAnalysisServiceImpl.this.searchQaAsyncTask.taskData(queryAnalysisFileUploadReqBO, beforeFilename, beforeFilenameDfs);
                    }
                    catch (Exception e) {
                        throw new Exception("\u5f02\u5e38\u6267\u884c\u67e5\u8be2\u5206\u6790\u9519\u8bef" + e.getMessage());
                    }
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThread(run);
            QueryAnalysisFileUploadReqBO fileBo = new QueryAnalysisFileUploadReqBO();
            fileBo.setFile(queryAnalysisFileUploadReqBO.getFile());
            fileBo.setFileName(afterFilenameDfs);
            String url = this.queryAnalysisSingleAtomService.fileUpload(fileBo);
            InsertFileDataBO insertFileDataBO = new InsertFileDataBO();
            insertFileDataBO.setId(Long.valueOf(new SnowflakeIdWorker(0L, 0L).nextId()));
            insertFileDataBO.setFileurl(url);
            insertFileDataBO.setFilename(afterFilename);
            insertFileDataBO.setCategory("after");
            int num = this.queryAnalysisSingleAtomService.insertFileData(insertFileDataBO);
            queryAnalysisRspBO.setRespCode("0000");
            queryAnalysisRspBO.setRespDesc("\u4e0a\u4f20\u6210\u529f");
            queryAnalysisRspBO.setDownloadFileName(this.searchQaAsyncTask.getNowTime() + "_" + snowflakes + "_" + queryAnalysisFileUploadReqBO.getFileName());
            queryAnalysisRspBO.setQueryConditions(queryAnalysisFileUploadReqBO.getFileName());
            LOGGER.info("Search Qa : {}\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01", (Object)queryAnalysisRspBO.getDownloadFileName());
            return queryAnalysisRspBO;
        }
        catch (Exception e) {
            e.printStackTrace();
            queryAnalysisRspBO.setRespCode("9999");
            queryAnalysisRspBO.setRespDesc(e.getMessage() + "\u6587\u4ef6\u5206\u6790\u5931\u8d25!");
            queryAnalysisRspBO.setQueryConditions(queryAnalysisFileUploadReqBO.getFileName());
            return queryAnalysisRspBO;
        }
    }

    public RspUccBo deleteByCategory(QueryAnalysisFilesListReqBO queryAnalysisFilesListReqBO) {
        RspUccBo rspUccBo = new RspUccBo();
        try {
            this.queryAnalysisFilesListMapper.deleteByCategory(queryAnalysisFilesListReqBO.getCategory());
            rspUccBo.setRespDesc("\u5220\u9664\u6210\u529f! ");
            rspUccBo.setRespCode("0000");
        }
        catch (Exception e) {
            rspUccBo.setRespCode("9999");
            rspUccBo.setRespDesc(e.getMessage() + "\u5220\u9664\u5931\u8d25\uff01");
        }
        return rspUccBo;
    }

    public QueryAnalysisFilesListRspBO filesList() {
        try {
            List queryAnalysisFilesListPOS = this.queryAnalysisFilesListMapper.selectAll();
            QueryAnalysisFilesListRspBO queryAnalysisFilesListRspBO = new QueryAnalysisFilesListRspBO();
            LinkedList<QueryAnalysisFileRspBO> queryAnalysisFileRspBOS = new LinkedList<QueryAnalysisFileRspBO>();
            for (QueryAnalysisFilesListPO queryAnalysisFilesListPO : queryAnalysisFilesListPOS) {
                QueryAnalysisFileRspBO queryAnalysisFileRspBO = new QueryAnalysisFileRspBO();
                queryAnalysisFileRspBO.setId(queryAnalysisFilesListPO.getId());
                queryAnalysisFileRspBO.setFilename(queryAnalysisFilesListPO.getFilename());
                queryAnalysisFileRspBO.setFileurl(queryAnalysisFilesListPO.getFileurl());
                queryAnalysisFileRspBO.setCategory(queryAnalysisFilesListPO.getCategory());
                queryAnalysisFileRspBOS.add(queryAnalysisFileRspBO);
            }
            queryAnalysisFilesListRspBO.setResultList(queryAnalysisFileRspBOS);
            Collections.reverse(queryAnalysisFilesListRspBO.getResultList());
            queryAnalysisFilesListRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            queryAnalysisFilesListRspBO.setRespCode("0000");
            return queryAnalysisFilesListRspBO;
        }
        catch (Exception e) {
            QueryAnalysisFilesListRspBO queryAnalysisFilesListRspBO = new QueryAnalysisFilesListRspBO();
            queryAnalysisFilesListRspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25");
            queryAnalysisFilesListRspBO.setRespCode("9999");
            return queryAnalysisFilesListRspBO;
        }
    }
}

