/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.impl;

import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSkuPropertiesBO;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.ability.bo.SeEntityCacheBO;
import com.tydic.se.search.ability.bo.SeEntityCacheRspBO;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.SeQueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="seQueryService")
public class SeQueryServiceImpl
implements SeQueryService {
    @Autowired
    private SeQueryBuilder seQueryBuilder;
    @Autowired
    private SeEntityCache seEntityCache;

    public ExecuteSearchRspBO search(ExecuteSearchReqBO executeSearchReqBO) {
        return this.seQueryBuilder.executeSearch(executeSearchReqBO);
    }

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        return this.seQueryBuilder.simpleSearch(executeSearchReqBO);
    }

    public SeEntityCacheRspBO refreshCache() {
        SeEntityCacheBO seEntityCacheBO = this.seEntityCache.init();
        SeEntityCacheRspBO rspBO = new SeEntityCacheRspBO();
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        rspBO.setData(seEntityCacheBO);
        return rspBO;
    }

    public ExecuteSearchRspBO categoryList(ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setIsAggregation(Boolean.valueOf(true));
        ExecuteSearchRspBO executeSearchRspBO = this.search(executeSearchReqBO);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        executeSearchRspBO.setResult(null);
        executeSearchRspBO.setQueryBody(null);
        List<SeSkuPropertiesBO> skuPropertiesList = this.parseSkuPropertiesList(esResultBO);
        List<SeQueryFilterBO> queryFilterList = this.parseQueryFilterList(esResultBO, skuPropertiesList);
        executeSearchRspBO.setQueryFilterList(queryFilterList);
        List<SeQueryPropertyBO> queryPropertyList = this.parseQueryPropertyList(skuPropertiesList);
        executeSearchRspBO.setQueryPropertyList(queryPropertyList);
        return executeSearchRspBO;
    }

    private SeQueryFilterBO parseQueryFilter(SeEsResultBO.Aggregations.Category category, String filterId, String filterName) {
        SeQueryFilterBO seQueryFilterBO = new SeQueryFilterBO();
        seQueryFilterBO.setFilterId(filterId);
        seQueryFilterBO.setFilterName(filterName);
        ArrayList<String> filterValues = new ArrayList<String>();
        for (SeEsResultBO.Aggregations.Category.Buckets buckets : category.getBuckets()) {
            filterValues.add(buckets.getKey());
        }
        seQueryFilterBO.setFilterValues(filterValues);
        return seQueryFilterBO;
    }

    private List<SeQueryFilterBO> parseQueryFilterList(SeEsResultBO esResultBO, List<SeSkuPropertiesBO> skuPropertiesList) {
        SeEsResultBO.Aggregations.Category group_by_vendor_name = esResultBO.getAggregations().getGroup_by_vendor_name();
        SeEsResultBO.Aggregations.Category group_by_l3_category_name = esResultBO.getAggregations().getGroup_by_l3_category_name();
        SeEsResultBO.Aggregations.Category group_by_brand_name = esResultBO.getAggregations().getGroup_by_brand_name();
        SeQueryFilterBO vendor_id_name = this.parseQueryFilter(group_by_vendor_name, "vendor_name", "\u4f9b\u5e94\u5546\u540d\u79f0");
        SeQueryFilterBO l3_category_id_name = this.parseQueryFilter(group_by_l3_category_name, "l3_category_name", "\u4e09\u7ea7\u7c7b\u76ee\u540d\u79f0");
        SeQueryFilterBO brand_id_name = this.parseQueryFilter(group_by_brand_name, "brand_name", "\u54c1\u724c\u540d\u79f0");
        ArrayList<SeQueryFilterBO> seQueryFilterBO = new ArrayList<SeQueryFilterBO>();
        seQueryFilterBO.add(vendor_id_name);
        seQueryFilterBO.add(l3_category_id_name);
        seQueryFilterBO.add(brand_id_name);
        HashMap<String, SeQueryFilterBO> queryFilterMap = new HashMap<String, SeQueryFilterBO>();
        HashSet<String> skuPropertiesSet = new HashSet<String>();
        for (SeSkuPropertiesBO skuPropertiesBO : skuPropertiesList) {
            SeQueryFilterBO filterBO;
            String setKey;
            if ("2".equals(skuPropertiesBO.getPropTag()) || skuPropertiesSet.contains(setKey = skuPropertiesBO.getCommodityPropGrpName() + skuPropertiesBO.getPropValue())) continue;
            if (queryFilterMap.containsKey(skuPropertiesBO.getCommodityPropGrpName())) {
                filterBO = (SeQueryFilterBO)queryFilterMap.get(skuPropertiesBO.getCommodityPropGrpName());
                List filterValues = filterBO.getFilterValues();
                filterValues.add(skuPropertiesBO.getPropValue());
                filterBO.setFilterValues(filterValues);
                queryFilterMap.put(skuPropertiesBO.getCommodityPropGrpName(), filterBO);
                skuPropertiesSet.add(setKey);
                continue;
            }
            filterBO = new SeQueryFilterBO();
            String propertyId = skuPropertiesBO.getPropTag() + "*~~" + "1" + "*~~" + skuPropertiesBO.getCommodityPropGrpName();
            filterBO.setFilterId(propertyId);
            filterBO.setFilterName(skuPropertiesBO.getCommodityPropGrpName());
            ArrayList<String> filterValues = new ArrayList<String>();
            filterValues.add(skuPropertiesBO.getPropValue());
            filterBO.setFilterValues(filterValues);
            queryFilterMap.put(skuPropertiesBO.getCommodityPropGrpName(), filterBO);
            skuPropertiesSet.add(setKey);
        }
        List tempQueryFilterBO = queryFilterMap.values().stream().collect(Collectors.toList());
        seQueryFilterBO.addAll(tempQueryFilterBO);
        return seQueryFilterBO;
    }

    private List<SeQueryPropertyBO> parseQueryPropertyList(List<SeSkuPropertiesBO> skuPropertiesList) {
        HashMap<String, SeQueryPropertyBO> queryPropertyMap = new HashMap<String, SeQueryPropertyBO>();
        HashSet<String> skuPropertiesSet = new HashSet<String>();
        for (SeSkuPropertiesBO skuPropertiesBO : skuPropertiesList) {
            SeQueryPropertyBO propertyBO;
            String setKey;
            if (!"2".equals(skuPropertiesBO.getPropTag()) || skuPropertiesSet.contains(setKey = skuPropertiesBO.getCommodityPropGrpName() + skuPropertiesBO.getPropValue())) continue;
            if (queryPropertyMap.containsKey(skuPropertiesBO.getCommodityPropGrpName())) {
                propertyBO = (SeQueryPropertyBO)queryPropertyMap.get(skuPropertiesBO.getCommodityPropGrpName());
                List propertyValues = propertyBO.getPropertyValues();
                propertyValues.add(skuPropertiesBO.getPropValue());
                propertyBO.setPropertyValues(propertyValues);
                skuPropertiesSet.add(setKey);
                continue;
            }
            propertyBO = new SeQueryPropertyBO();
            String propertyId = skuPropertiesBO.getPropTag() + "*~~" + "1" + "*~~" + skuPropertiesBO.getCommodityPropGrpName();
            propertyBO.setPropertyId(propertyId);
            propertyBO.setPropertyName(skuPropertiesBO.getCommodityPropGrpName());
            ArrayList<String> propertyValues = new ArrayList<String>();
            propertyValues.add(skuPropertiesBO.getPropValue());
            propertyBO.setPropertyValues(propertyValues);
            queryPropertyMap.put(skuPropertiesBO.getCommodityPropGrpName(), propertyBO);
            skuPropertiesSet.add(setKey);
        }
        List<SeQueryPropertyBO> queryPropertyList = queryPropertyMap.values().stream().collect(Collectors.toList());
        return queryPropertyList;
    }

    private String parseQueryPropertyName(String name) {
        if ("texture".equals(name)) {
            return "\u6750\u8d28";
        }
        if ("model".equals(name)) {
            return "\u578b\u53f7";
        }
        if ("spec".equals(name)) {
            return "\u8bf4\u660e";
        }
        if ("measure_name".equals(name)) {
            return "\u5355\u4f4d";
        }
        return "\u5176\u5b83";
    }

    private List<SeSkuPropertiesBO> parseSkuPropertiesList(SeEsResultBO esResultBO) {
        ArrayList<SeSkuPropertiesBO> skuPropertiesList = new ArrayList<SeSkuPropertiesBO>();
        for (SeEsResultBO.Hits.InHits inHits : esResultBO.getHits().getHits()) {
            String[] proAttrList;
            SeQuerySkuBO seQuerySkuBO = inHits.get_source();
            if (!StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getProperties()) || (proAttrList = seQuerySkuBO.getProperties().split("\n")) == null) continue;
            for (int i = 0; i < proAttrList.length; ++i) {
                String[] proAttr = proAttrList[i].split("\\*~~");
                if (proAttr.length < 5) continue;
                SeSkuPropertiesBO skuPropertiesBO = new SeSkuPropertiesBO();
                skuPropertiesBO.setCommodityPropDefId(proAttr[0]);
                skuPropertiesBO.setPropTag(proAttr[1]);
                skuPropertiesBO.setPropertyLink(proAttr[2]);
                skuPropertiesBO.setCommodityPropGrpName(proAttr[3]);
                skuPropertiesBO.setPropValue(proAttr[4]);
                if (!"1".equals(proAttr[2])) continue;
                skuPropertiesList.add(skuPropertiesBO);
            }
        }
        return skuPropertiesList;
    }
}

