/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import com.tydic.se.base.dao.UccBrandMapper;
import com.tydic.se.base.dao.UccCatalogDealMapper;
import com.tydic.se.base.dao.UccCommodityTypeMapper;
import com.tydic.se.base.dao.UccGuideCatalogMapper;
import com.tydic.se.base.dao.UccVendorMapper;
import com.tydic.se.base.dao.po.UccBrandPO;
import com.tydic.se.base.dao.po.UccCommodityTypePo;
import com.tydic.se.base.dao.po.UccGuideCatalogPO;
import com.tydic.se.base.dao.po.UccVendorPO;
import com.tydic.se.behavior.dao.SeCommDetailInLogMapper;
import com.tydic.se.behavior.po.SeCommDetailInLogPO;
import com.tydic.se.search.ability.bo.SeEntityCacheBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class SeEntityCache {
    private static final Logger log = LoggerFactory.getLogger(SeEntityCache.class);
    private static Map<String, Map<String, String>> entityCacheMap;
    private static List<String> catalogIdList;
    @Autowired
    UccGuideCatalogMapper uccGuideCatalogMapper;
    @Autowired
    UccBrandMapper uccBrandMapper;
    @Autowired
    UccVendorMapper uccVendorMapper;
    @Autowired
    UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    SeCommDetailInLogMapper seCommDetailInLogMapper;
    @Autowired
    UccCatalogDealMapper uccCatalogDealMapper;

    @Bean
    public void SeEntityCache() {
        this.init();
    }

    public SeEntityCacheBO init() {
        entityCacheMap = new HashMap<String, Map<String, String>>();
        catalogIdList = new ArrayList<String>();
        SeEntityCacheBO seEntityCacheBO = new SeEntityCacheBO();
        log.info("initialization Search frequency max...");
        HashMap<Long, String> map = new HashMap<Long, String>();
        ArrayList<String> skuIds = new ArrayList<String>();
        List seCommDetailInLogPOS = this.seCommDetailInLogMapper.selectMonthSkuIdList();
        if (seCommDetailInLogPOS.size() > 0) {
            int i;
            if (seCommDetailInLogPOS.size() > 9) {
                for (i = 0; i < 10; ++i) {
                    skuIds.add(((SeCommDetailInLogPO)seCommDetailInLogPOS.get(i)).getSkuId());
                }
            } else {
                for (i = 0; i < seCommDetailInLogPOS.size(); ++i) {
                    skuIds.add(((SeCommDetailInLogPO)seCommDetailInLogPOS.get(i)).getSkuId());
                }
            }
        }
        for (String skuId : skuIds) {
            UccGuideCatalogPO uccGuideCatalogPO = this.uccCatalogDealMapper.selectBySkuId(skuId);
            if (uccGuideCatalogPO == null || map.containsKey(uccGuideCatalogPO.getGuideCatalogId())) continue;
            map.put(uccGuideCatalogPO.getGuideCatalogId(), "0");
            catalogIdList.add(String.valueOf(uccGuideCatalogPO.getGuideCatalogId()));
        }
        log.info("initialization Search frequency max complete");
        log.info("initialization level2categoryMap...");
        UccGuideCatalogPO selectUccGuideCatalogPO2 = new UccGuideCatalogPO();
        selectUccGuideCatalogPO2.setCatalogLevel(Integer.valueOf(2));
        List uccGuideCatalogPOList2 = this.uccGuideCatalogMapper.selectCatalogList(selectUccGuideCatalogPO2);
        if (uccGuideCatalogPOList2 != null) {
            HashMap<String, String> level2categoryTempMap = new HashMap<String, String>();
            for (UccGuideCatalogPO uccGuideCatalogPO : uccGuideCatalogPOList2) {
                String[] catalogNames;
                String tempCatalogName = uccGuideCatalogPO.getCatalogName();
                for (String catalogName : catalogNames = this.parseName(tempCatalogName)) {
                    if (StringUtils.isBlank((CharSequence)catalogName) || this.parseIntegerCheck(catalogName)) continue;
                    if (level2categoryTempMap.containsKey(catalogName = catalogName.trim())) {
                        level2categoryTempMap.put(catalogName, (String)level2categoryTempMap.get(catalogName) + "," + uccGuideCatalogPO.getGuideCatalogId());
                        continue;
                    }
                    level2categoryTempMap.put(catalogName, String.valueOf(uccGuideCatalogPO.getGuideCatalogId()));
                }
            }
            seEntityCacheBO.setLevel2categoryListSize(Integer.valueOf(uccGuideCatalogPOList2.size()));
            seEntityCacheBO.setLevel2categoryMapSize(Integer.valueOf(level2categoryTempMap.size()));
            entityCacheMap.put("l2_category", level2categoryTempMap);
        }
        log.info("initialization level2categoryMap complete");
        log.info("initialization level3categoryMap...");
        UccGuideCatalogPO selectUccGuideCatalogPO = new UccGuideCatalogPO();
        selectUccGuideCatalogPO.setCatalogLevel(Integer.valueOf(3));
        List uccGuideCatalogPOList = this.uccGuideCatalogMapper.selectCatalogList(selectUccGuideCatalogPO);
        if (uccGuideCatalogPOList != null) {
            HashMap<String, String> level3categoryTempMap = new HashMap<String, String>();
            for (Object uccGuideCatalogPO : uccGuideCatalogPOList) {
                String[] catalogNames;
                String tempCatalogName = uccGuideCatalogPO.getCatalogName();
                for (String catalogName : catalogNames = this.parseName(tempCatalogName)) {
                    if (StringUtils.isBlank((CharSequence)catalogName) || this.parseIntegerCheck(catalogName)) continue;
                    if (level3categoryTempMap.containsKey(catalogName = catalogName.trim())) {
                        level3categoryTempMap.put(catalogName, (String)level3categoryTempMap.get(catalogName) + "," + uccGuideCatalogPO.getGuideCatalogId());
                        continue;
                    }
                    level3categoryTempMap.put(catalogName, String.valueOf(uccGuideCatalogPO.getGuideCatalogId()));
                }
            }
            seEntityCacheBO.setLevel3categoryListSize(Integer.valueOf(uccGuideCatalogPOList.size()));
            seEntityCacheBO.setLevel3categoryMapSize(Integer.valueOf(level3categoryTempMap.size()));
            entityCacheMap.put("l3_category", level3categoryTempMap);
        }
        log.info("initialization level3categoryMap complete");
        log.info("initialization level4categoryMap...");
        List uccCommodityTypePOS = this.uccCommodityTypeMapper.selectByCondition(new UccCommodityTypePo());
        if (uccCommodityTypePOS.size() > 0) {
            HashMap<String, String> level4categoryTempMap = new HashMap<String, String>();
            for (Object commodityTypePO : uccCommodityTypePOS) {
                String[] commodityTypeNames;
                String commodityTypeName = commodityTypePO.getCommodityTypeName();
                for (String typeName : commodityTypeNames = this.parseName(commodityTypeName)) {
                    if (StringUtils.isBlank((CharSequence)typeName) || this.parseIntegerCheck(typeName)) continue;
                    if (level4categoryTempMap.containsKey(typeName = typeName.trim())) {
                        level4categoryTempMap.put(typeName, (String)level4categoryTempMap.get(typeName) + "," + commodityTypePO.getCatalogId());
                        continue;
                    }
                    level4categoryTempMap.put(typeName, String.valueOf(commodityTypePO.getCatalogId()));
                }
            }
            seEntityCacheBO.setLevel4categoryMapSize(Integer.valueOf(level4categoryTempMap.size()));
            seEntityCacheBO.setLevel4categoryListSize(Integer.valueOf(uccCommodityTypePOS.size()));
            entityCacheMap.put("l4mg_category", level4categoryTempMap);
        }
        log.info("initialization level4categoryMap complete");
        log.info("initialization brandMap...");
        List<UccBrandPO> uccBrandPOList = this.selectBrandListPage(new UccBrandPO());
        if (uccBrandPOList != null) {
            HashMap<String, String> brandTempMap = new HashMap<String, String>();
            for (UccBrandPO uccBrandPO : uccBrandPOList) {
                String[] brandNames;
                String tempBrandName = uccBrandPO.getBrandName();
                for (String brandName : brandNames = this.parseName(tempBrandName)) {
                    if (StringUtils.isBlank((CharSequence)brandName) || this.parseIntegerCheck(brandName)) continue;
                    if (brandTempMap.containsKey(brandName = brandName.trim())) {
                        brandTempMap.put(brandName, (String)brandTempMap.get(brandName) + "," + uccBrandPO.getBrandId());
                        continue;
                    }
                    brandTempMap.put(brandName, String.valueOf(uccBrandPO.getBrandId()));
                }
            }
            seEntityCacheBO.setBrandListSize(Integer.valueOf(uccBrandPOList.size()));
            seEntityCacheBO.setBrandMapSize(Integer.valueOf(brandTempMap.size()));
            entityCacheMap.put("brand", brandTempMap);
        }
        log.info("initialization brandMap complete");
        log.info("initialization vendorMap...");
        List uccVendorPOList = this.uccVendorMapper.selectVendorList(new UccVendorPO());
        if (uccVendorPOList != null) {
            HashMap<String, String> vendorTempMap = new HashMap<String, String>();
            for (UccVendorPO uccVendorPO : uccVendorPOList) {
                String tempVendorName = uccVendorPO.getVendorName();
                List<String> vendorNames = Arrays.asList(tempVendorName);
                for (String vendorName : vendorNames) {
                    if (StringUtils.isBlank((CharSequence)vendorName) || this.parseIntegerCheck(vendorName)) continue;
                    if (vendorTempMap.containsKey(vendorName = vendorName.trim())) {
                        vendorTempMap.put(vendorName, (String)vendorTempMap.get(vendorName) + "," + uccVendorPO.getVendorId());
                        continue;
                    }
                    vendorTempMap.put(vendorName, String.valueOf(uccVendorPO.getVendorId()));
                }
            }
            seEntityCacheBO.setVendorListSize(Integer.valueOf(uccVendorPOList.size()));
            seEntityCacheBO.setVendorMapSize(Integer.valueOf(vendorTempMap.size()));
            entityCacheMap.put("vendor", vendorTempMap);
        }
        log.info("initialization vendorMap complete");
        return seEntityCacheBO;
    }

    private String[] parseName(String name) {
        name = name.replaceAll("\uff09", "");
        name = name.replaceAll("\uff08", "/");
        return name.split("/");
    }

    private List<UccBrandPO> selectBrandListPage(UccBrandPO selectUccBrandPO) {
        Integer pageNo = 1;
        Integer pageSize = 1000;
        ArrayList<UccBrandPO> uccBrandBOList = new ArrayList<UccBrandPO>();
        while (true) {
            List uccBrandPOResult = this.uccBrandMapper.selectBrandListPage(selectUccBrandPO, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            uccBrandBOList.addAll(uccBrandPOResult);
            if (uccBrandPOResult == null || uccBrandPOResult != null && uccBrandPOResult.size() < pageSize) break;
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        }
        return uccBrandBOList;
    }

    private boolean parseIntegerCheck(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, Map<String, String>> getEntityCacheMap() {
        return entityCacheMap;
    }

    public static List<String> getCatalogIdList() {
        return catalogIdList;
    }

    public UccGuideCatalogMapper getUccGuideCatalogMapper() {
        return this.uccGuideCatalogMapper;
    }

    public UccBrandMapper getUccBrandMapper() {
        return this.uccBrandMapper;
    }

    public UccVendorMapper getUccVendorMapper() {
        return this.uccVendorMapper;
    }

    public UccCommodityTypeMapper getUccCommodityTypeMapper() {
        return this.uccCommodityTypeMapper;
    }

    public SeCommDetailInLogMapper getSeCommDetailInLogMapper() {
        return this.seCommDetailInLogMapper;
    }

    public UccCatalogDealMapper getUccCatalogDealMapper() {
        return this.uccCatalogDealMapper;
    }

    public void setUccGuideCatalogMapper(UccGuideCatalogMapper uccGuideCatalogMapper) {
        this.uccGuideCatalogMapper = uccGuideCatalogMapper;
    }

    public void setUccBrandMapper(UccBrandMapper uccBrandMapper) {
        this.uccBrandMapper = uccBrandMapper;
    }

    public void setUccVendorMapper(UccVendorMapper uccVendorMapper) {
        this.uccVendorMapper = uccVendorMapper;
    }

    public void setUccCommodityTypeMapper(UccCommodityTypeMapper uccCommodityTypeMapper) {
        this.uccCommodityTypeMapper = uccCommodityTypeMapper;
    }

    public void setSeCommDetailInLogMapper(SeCommDetailInLogMapper seCommDetailInLogMapper) {
        this.seCommDetailInLogMapper = seCommDetailInLogMapper;
    }

    public void setUccCatalogDealMapper(UccCatalogDealMapper uccCatalogDealMapper) {
        this.uccCatalogDealMapper = uccCatalogDealMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeEntityCache)) {
            return false;
        }
        SeEntityCache other = (SeEntityCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UccGuideCatalogMapper this$uccGuideCatalogMapper = this.getUccGuideCatalogMapper();
        UccGuideCatalogMapper other$uccGuideCatalogMapper = other.getUccGuideCatalogMapper();
        if (this$uccGuideCatalogMapper == null ? other$uccGuideCatalogMapper != null : !this$uccGuideCatalogMapper.equals(other$uccGuideCatalogMapper)) {
            return false;
        }
        UccBrandMapper this$uccBrandMapper = this.getUccBrandMapper();
        UccBrandMapper other$uccBrandMapper = other.getUccBrandMapper();
        if (this$uccBrandMapper == null ? other$uccBrandMapper != null : !this$uccBrandMapper.equals(other$uccBrandMapper)) {
            return false;
        }
        UccVendorMapper this$uccVendorMapper = this.getUccVendorMapper();
        UccVendorMapper other$uccVendorMapper = other.getUccVendorMapper();
        if (this$uccVendorMapper == null ? other$uccVendorMapper != null : !this$uccVendorMapper.equals(other$uccVendorMapper)) {
            return false;
        }
        UccCommodityTypeMapper this$uccCommodityTypeMapper = this.getUccCommodityTypeMapper();
        UccCommodityTypeMapper other$uccCommodityTypeMapper = other.getUccCommodityTypeMapper();
        if (this$uccCommodityTypeMapper == null ? other$uccCommodityTypeMapper != null : !this$uccCommodityTypeMapper.equals(other$uccCommodityTypeMapper)) {
            return false;
        }
        SeCommDetailInLogMapper this$seCommDetailInLogMapper = this.getSeCommDetailInLogMapper();
        SeCommDetailInLogMapper other$seCommDetailInLogMapper = other.getSeCommDetailInLogMapper();
        if (this$seCommDetailInLogMapper == null ? other$seCommDetailInLogMapper != null : !this$seCommDetailInLogMapper.equals(other$seCommDetailInLogMapper)) {
            return false;
        }
        UccCatalogDealMapper this$uccCatalogDealMapper = this.getUccCatalogDealMapper();
        UccCatalogDealMapper other$uccCatalogDealMapper = other.getUccCatalogDealMapper();
        return !(this$uccCatalogDealMapper == null ? other$uccCatalogDealMapper != null : !this$uccCatalogDealMapper.equals(other$uccCatalogDealMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeEntityCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UccGuideCatalogMapper $uccGuideCatalogMapper = this.getUccGuideCatalogMapper();
        result = result * 59 + ($uccGuideCatalogMapper == null ? 43 : $uccGuideCatalogMapper.hashCode());
        UccBrandMapper $uccBrandMapper = this.getUccBrandMapper();
        result = result * 59 + ($uccBrandMapper == null ? 43 : $uccBrandMapper.hashCode());
        UccVendorMapper $uccVendorMapper = this.getUccVendorMapper();
        result = result * 59 + ($uccVendorMapper == null ? 43 : $uccVendorMapper.hashCode());
        UccCommodityTypeMapper $uccCommodityTypeMapper = this.getUccCommodityTypeMapper();
        result = result * 59 + ($uccCommodityTypeMapper == null ? 43 : $uccCommodityTypeMapper.hashCode());
        SeCommDetailInLogMapper $seCommDetailInLogMapper = this.getSeCommDetailInLogMapper();
        result = result * 59 + ($seCommDetailInLogMapper == null ? 43 : $seCommDetailInLogMapper.hashCode());
        UccCatalogDealMapper $uccCatalogDealMapper = this.getUccCatalogDealMapper();
        result = result * 59 + ($uccCatalogDealMapper == null ? 43 : $uccCatalogDealMapper.hashCode());
        return result;
    }

    public String toString() {
        return "SeEntityCache(uccGuideCatalogMapper=" + this.getUccGuideCatalogMapper() + ", uccBrandMapper=" + this.getUccBrandMapper() + ", uccVendorMapper=" + this.getUccVendorMapper() + ", uccCommodityTypeMapper=" + this.getUccCommodityTypeMapper() + ", seCommDetailInLogMapper=" + this.getSeCommDetailInLogMapper() + ", uccCatalogDealMapper=" + this.getUccCatalogDealMapper() + ")";
    }
}

