/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisReqBO;
import com.tydic.se.search.qa.QueryAnalysisSingleAtomService;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.sort.enumType.SpecifySortFilterEnum;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SearchCommodityBaseServiceImpl
implements SearchCommodityBaseService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityBaseServiceImpl.class);
    @Autowired
    private QueryAnalysisSingleAtomService queryAnalysisSingleService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchSortConfig searchSortConfig;

    public Boolean judgeRedisUse(SearchSortMsgBo searchSortMsgBo) {
        return null;
    }

    public SearchSortMsgBo initParameter(SeSearchReqBO reqBO) {
        SearchSortMsgBo searchSortMsgBo = new SearchSortMsgBo();
        if (reqBO.getProvince() != null) {
            searchSortMsgBo.setProvince(reqBO.getProvince());
        }
        if (reqBO.getCity() != null) {
            searchSortMsgBo.setCity(reqBO.getCity());
        }
        if (reqBO.getCounty() != null) {
            searchSortMsgBo.setCounty(reqBO.getCounty());
        }
        if (reqBO.getTown() != null) {
            searchSortMsgBo.setTown(reqBO.getTown());
        }
        searchSortMsgBo.setQueryStr(reqBO.getQueryStr().trim());
        searchSortMsgBo.setSessionId(StringUtils.isEmpty((Object)reqBO.getQryToken()) ? "null" : reqBO.getQryToken());
        searchSortMsgBo.setCutLen(Integer.parseInt(this.searchSortConfig.getSegLength()));
        searchSortMsgBo.setPageNo(reqBO.getPageNo());
        searchSortMsgBo.setPageSize(reqBO.getPageSize());
        searchSortMsgBo.setQueryStrParticiple(this.getParticiple(reqBO.getQueryStr()));
        searchSortMsgBo.setSessionIdKey(SearchSortUtils.sessionKeyFormat((SearchSortMsgBo)searchSortMsgBo));
        searchSortMsgBo.setSessionIdKeyBlurry(SearchSortUtils.sessionKeyFormatBlurry((SearchSortMsgBo)searchSortMsgBo));
        searchSortMsgBo.setComSortList(CollectionUtils.isEmpty((Collection)reqBO.getComSortList()) ? new LinkedList() : reqBO.getComSortList());
        searchSortMsgBo.setQueryFilterList(CollectionUtils.isEmpty((Collection)reqBO.getQueryFilterList()) ? new LinkedList() : reqBO.getQueryFilterList());
        searchSortMsgBo.setQueryPropertyList(CollectionUtils.isEmpty((Collection)reqBO.getQueryPropertyList()) ? new LinkedList() : reqBO.getQueryPropertyList());
        try {
            if (reqBO.getMinSalePrice() != null && reqBO.getMaxSalePrice() != null) {
                BigDecimal min = new BigDecimal(String.valueOf(reqBO.getMinSalePrice()));
                BigDecimal max = new BigDecimal(String.valueOf(reqBO.getMaxSalePrice()));
                if (max.compareTo(min) < 0) {
                    throw new Exception("max < min");
                }
                searchSortMsgBo.setMinSalesPrice(min);
                searchSortMsgBo.setMaxSalesPrice(max);
                searchSortMsgBo.setSalesPriceJudge(true);
            }
        }
        catch (Exception e) {
            if ("max < min".equals(e.getMessage())) {
                throw new SearchSortException("9999", "\u8bf7\u91cd\u65b0\u8f93\u5165\u4ef7\u683c\u533a\u95f4\uff01", (Throwable)e);
            }
            searchSortMsgBo.setSalesPriceJudge(false);
        }
        searchSortMsgBo.setGuideCatalogCache(CollectionUtils.isEmpty((Collection)reqBO.getGuideCatalogCache()) ? new LinkedList() : reqBO.getGuideCatalogCache());
        String tmp = (String)this.cacheClient.get("ucc_search_guide_catalog_cache" + reqBO.getQueryStr() + "order");
        Map catalogAndOrderMap = (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)tmp), Map.class);
        searchSortMsgBo.setCatalogAndOrderMap(CollectionUtils.isEmpty((Map)catalogAndOrderMap) ? new LinkedHashMap() : catalogAndOrderMap);
        log.info("\u6392\u5e8f\u521d\u59cb\u5316\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)searchSortMsgBo));
        return searchSortMsgBo;
    }

    public List<String> getParticiple(String queryStr) throws SearchSortException {
        try {
            QueryAnalysisReqBO queryAnalysisReqBO = new QueryAnalysisReqBO();
            queryAnalysisReqBO.setQueryConditions(queryStr);
            return this.queryAnalysisSingleService.getQueryAnalysisParticiple(queryAnalysisReqBO);
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", e.getMessage()});
            throw new SearchSortException("9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public Boolean cacheJudgeExist(SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        String sessionIdKeyBlurry = SearchSortUtils.sessionKeyFormatBlurry((SearchSortMsgBo)searchSortMsgBo);
        log.info("\u67e5\u8be2\u7f13\u5b58\u6765\u4e86");
        try {
            if (StringUtils.isEmpty((Object)sessionIdKeyBlurry) || CollectionUtils.isEmpty((Collection)this.cacheClient.getkeys(sessionIdKeyBlurry))) {
                log.info("\u77ed\u65f6\u95f4\u5185\u67e5\u8be2redis\u65e0\u7f13\u5b58,\u8fdb\u884c\u67e5\u8be2\u5e76\u6392\u5e8f\uff01");
                return true;
            }
            log.info("\u77ed\u65f6\u95f4\u5185\u67e5\u8be2redis\u6709\u7f13\u5b58\uff0c\u76f4\u63a5\u6392\u5e8f\uff01");
            return false;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u62a5\u9519\uff1a" + e.getMessage());
            return true;
        }
    }

    public SeSearchRspBO attributeAggr(SeSearchRspBO searchEsRspBo) throws SearchSortException {
        try {
            LinkedList<SeQueryFilterBO> seQueryFilterBOList = new LinkedList<SeQueryFilterBO>();
            seQueryFilterBOList.add(this.encapsulation(SpecifySortFilterEnum.L_3_CATEGORY_ID_NAME));
            seQueryFilterBOList.add(this.encapsulation(SpecifySortFilterEnum.BRAND_ID_NAME));
            seQueryFilterBOList.add(this.encapsulation(SpecifySortFilterEnum.VENDOR_ID_NAME));
            if (!CollectionUtils.isEmpty((Collection)searchEsRspBo.getSkuList())) {
                for (SeQuerySkuBO seQuerySkuBO : searchEsRspBo.getSkuList()) {
                    if (!CollectionUtils.isEmpty((Collection)seQuerySkuBO.getL3CategoryName())) {
                        seQuerySkuBO.getL3CategoryName().forEach(l3CategoryName -> {
                            if (!((SeQueryFilterBO)seQueryFilterBOList.get(0)).getFilterValues().contains(l3CategoryName)) {
                                ((SeQueryFilterBO)seQueryFilterBOList.get(0)).getFilterValues().add(l3CategoryName);
                            }
                        });
                    }
                    if (!StringUtils.isEmpty((Object)seQuerySkuBO.getBrandName()) && !((SeQueryFilterBO)seQueryFilterBOList.get(1)).getFilterValues().contains(seQuerySkuBO.getBrandName())) {
                        ((SeQueryFilterBO)seQueryFilterBOList.get(1)).getFilterValues().add(seQuerySkuBO.getBrandName());
                    }
                    if (StringUtils.isEmpty((Object)seQuerySkuBO.getVendorName()) || ((SeQueryFilterBO)seQueryFilterBOList.get(2)).getFilterValues().contains(seQuerySkuBO.getVendorName())) continue;
                    ((SeQueryFilterBO)seQueryFilterBOList.get(2)).getFilterValues().add(seQuerySkuBO.getVendorName());
                }
            }
            searchEsRspBo.setQueryFilterList(seQueryFilterBOList);
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u5c5e\u6027\u805a\u5408\u9519\u8bef\uff01", e});
        }
        return searchEsRspBo;
    }

    public SeSearchRspBO propertiesAttributeAggr(SeSearchRspBO searchEsRspBo) throws SearchSortException {
        LinkedHashMap propParamsMap = new LinkedHashMap();
        searchEsRspBo.getSkuList().forEach(commodityRspBo -> {
            if (!StringUtils.isEmpty((Object)commodityRspBo.getProperties())) {
                String[] propertiesArray;
                commodityRspBo.setPropertiesMap(new LinkedHashMap());
                for (String properties : propertiesArray = commodityRspBo.getProperties().split("\n")) {
                    String[] strings = properties.trim().split("\\*~~");
                    if (strings.length != 4) continue;
                    commodityRspBo.getPropertiesMap().put("prop_name_" + strings[1], strings[3]);
                    if (propParamsMap.containsKey("prop_name_" + strings[1])) {
                        ((List)propParamsMap.get("prop_name_" + strings[1])).add(strings[3]);
                        continue;
                    }
                    LinkedList<String> tmp = new LinkedList<String>();
                    tmp.add(strings[3]);
                    propParamsMap.put("prop_name_" + strings[1], tmp);
                }
            }
        });
        LinkedList<SeQueryPropertyBO> propParams = new LinkedList<SeQueryPropertyBO>();
        for (Map.Entry entry : propParamsMap.entrySet()) {
            SeQueryPropertyBO seQueryPropertyBO = new SeQueryPropertyBO();
            seQueryPropertyBO.setPropertyId((String)entry.getKey());
            seQueryPropertyBO.setPropertyName(((String)entry.getKey()).replace("prop_name_", ""));
            seQueryPropertyBO.setPropertyValues(new LinkedList(new TreeSet((Collection)entry.getValue())));
            propParams.add(seQueryPropertyBO);
        }
        searchEsRspBo.setQueryPropertyList(propParams);
        return searchEsRspBo;
    }

    private SeQueryFilterBO encapsulation(SpecifySortFilterEnum specifySortFilterEnum) {
        SeQueryFilterBO seQueryFilterBO = new SeQueryFilterBO();
        seQueryFilterBO.setFilterId(specifySortFilterEnum.getDesc());
        seQueryFilterBO.setFilterName(specifySortFilterEnum.getFilterName());
        seQueryFilterBO.setFilterValues(new LinkedList());
        return seQueryFilterBO;
    }
}

