/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.qa.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.tydic.se.base.ability.search.qa.bo.InsertFileDataBO;
import com.tydic.se.base.ability.search.qa.bo.QueryAnalysisBO;
import com.tydic.se.base.ability.search.qa.bo.SimplifiedProductInfoBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisFileUploadReqBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisReqBO;
import com.tydic.se.base.ability.search.qa.bo.req.QueryAnalysisSearchGoodsReqBO;
import com.tydic.se.base.ability.search.qa.bo.rsp.QueryAnalysisRspBO;
import com.tydic.se.base.dao.QueryAnalysisFilesListMapper;
import com.tydic.se.base.dao.po.QueryAnalysisFilesListPO;
import com.tydic.se.search.normalized.AnalyzerTokensService;
import com.tydic.se.search.normalized.bo.AnalyzerTokensBo;
import com.tydic.se.search.normalized.bo.AnalyzerTokensReqBO;
import com.tydic.se.search.normalized.bo.AnalyzerTokensRspBO;
import com.tydic.se.search.qa.QueryAnalysisSingleAtomService;
import com.tydic.se.search.qa.config.SearchQaConfig;
import com.tydic.se.search.qa.impl.FileUpLoad;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchQaHttpUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QueryAnalysisSingleAtomServiceImpl
implements QueryAnalysisSingleAtomService {
    private static final Logger log = LoggerFactory.getLogger(QueryAnalysisSingleAtomServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(QueryAnalysisSingleAtomServiceImpl.class);
    @Autowired
    SearchQaConfig searchQaConfig;
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private QueryAnalysisFilesListMapper queryAnalysisFilesListMapper;
    @Autowired
    private AnalyzerTokensService analyzerTokensService;
    private static final Gson GSON = new Gson();

    public QueryAnalysisRspBO singleAnalysis(QueryAnalysisSearchGoodsReqBO queryAnalysisSearchGoodsReqBO) {
        if (StringUtils.isEmpty((Object)queryAnalysisSearchGoodsReqBO.getQueryStr())) {
            QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
            queryAnalysisRspBO.setRespCode("0000");
            queryAnalysisRspBO.setRespDesc("\u8c03\u7528\u6210\u529f\uff01");
            queryAnalysisRspBO.setQueryConditions(queryAnalysisSearchGoodsReqBO.getQueryStr());
            queryAnalysisRspBO.setQueryResults(new LinkedList());
            queryAnalysisRspBO.setParticiple(new LinkedList());
            return queryAnalysisRspBO;
        }
        QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
        queryAnalysisRspBO.setQueryConditions(queryAnalysisSearchGoodsReqBO.getQueryStr());
        try {
            QueryAnalysisBO queryAnalysisBO = this.taskAtom(queryAnalysisSearchGoodsReqBO);
            if (queryAnalysisBO == null) {
                throw new Exception("\u67e5\u8be2\u7ed3\u679c\u4e3anull");
            }
            queryAnalysisRspBO.setRespCode("0000");
            queryAnalysisRspBO.setRespDesc("\u8c03\u7528\u6210\u529f\uff01");
            queryAnalysisRspBO.setParticiple(queryAnalysisBO.getParticiple());
            if (queryAnalysisBO.getQueryResults().size() == 0) {
                queryAnalysisRspBO.setRemark("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            queryAnalysisRspBO.setQueryResults(queryAnalysisBO.getQueryResults());
            queryAnalysisRspBO.setAnalyzerCatalogIndexData(queryAnalysisBO.getAnalyzerCatalogIndexData());
            queryAnalysisRspBO.setReCallType(queryAnalysisBO.getReCallType());
            queryAnalysisRspBO.setFullTextMatchRate(queryAnalysisBO.getFullTextMatchRate());
            queryAnalysisRspBO.setKeyFieldsMatchRate(queryAnalysisBO.getKeyFieldsMatchRate());
            queryAnalysisRspBO.setQueryResultType(queryAnalysisBO.getQueryResultType());
        }
        catch (Exception e) {
            queryAnalysisRspBO.setRespCode("9999");
            queryAnalysisRspBO.setRespDesc(e.getMessage() + "\uff0c\u67e5\u8be2\u5206\u6790\u5355\u539f\u5b50\u5c42\u8c03\u7528\u5931\u8d25\uff01");
            queryAnalysisRspBO.setRemark(e.getMessage().replace("java.lang.Exception:", ""));
        }
        return queryAnalysisRspBO;
    }

    public QueryAnalysisBO taskAtom(QueryAnalysisSearchGoodsReqBO queryAnalysisSearchGoodsReqBO) throws Exception {
        QueryAnalysisBO queryAnalysisBO = new QueryAnalysisBO();
        QueryAnalysisReqBO queryAnalysisReqBO = new QueryAnalysisReqBO();
        queryAnalysisReqBO.setQueryConditions(queryAnalysisSearchGoodsReqBO.getQueryStr());
        queryAnalysisBO.setParticiple(this.getQueryAnalysisParticiple(queryAnalysisReqBO));
        QueryAnalysisBO tmp = this.getQueryAnalysisQueryResults(queryAnalysisSearchGoodsReqBO);
        queryAnalysisBO.setQueryResults(tmp.getQueryResults());
        queryAnalysisBO.setAnalyzerCatalogIndexData(tmp.getAnalyzerCatalogIndexData());
        queryAnalysisBO.setReCallType(tmp.getReCallType());
        queryAnalysisBO.setFullTextMatchRate(tmp.getFullTextMatchRate());
        queryAnalysisBO.setKeyFieldsMatchRate(tmp.getKeyFieldsMatchRate());
        queryAnalysisBO.setQueryResultType(tmp.getQueryResultType());
        return queryAnalysisBO;
    }

    public List<String> getQueryAnalysisParticiple(QueryAnalysisReqBO queryAnalysisReqBO) {
        try {
            AnalyzerTokensReqBO reqBO = new AnalyzerTokensReqBO();
            reqBO.setTokens(queryAnalysisReqBO.getQueryConditions());
            AnalyzerTokensRspBO rspBO = this.analyzerTokensService.analyzer(reqBO);
            ArrayList analyzerTokensBos = new ArrayList(rspBO.getRows());
            LinkedList<String> stringList = new LinkedList<String>();
            if (!CollectionUtils.isEmpty(analyzerTokensBos)) {
                for (int i = 0; i < analyzerTokensBos.size(); ++i) {
                    stringList.add(((AnalyzerTokensBo)analyzerTokensBos.get(i)).getToken());
                }
            }
            return stringList;
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", e});
            throw new SearchSortException("9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public QueryAnalysisBO getQueryAnalysisQueryResults(QueryAnalysisSearchGoodsReqBO queryAnalysisSearchGoodsReqBO) throws Exception {
        QueryAnalysisBO queryAnalysisBO = new QueryAnalysisBO();
        ArrayList simplifiedProductInfoBOS = new ArrayList();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        queryAnalysisSearchGoodsReqBO.setQryToken("_token_for_query_tool_");
        SearchQaHttpUtil.doPostJson((String)this.searchQaConfig.getQueryUrl().trim(), (String)GSON.toJson((Object)queryAnalysisSearchGoodsReqBO), (status, json) -> {
            if (status != 200) {
                LOGGER.error("\u8c03\u7528\u5931\u8d25\uff01");
                throw new RuntimeException(new Exception("\u65e0\u6cd5\u83b7\u53d6\u6570\u636e"));
            }
            try {
                JSONObject obj = JSONObject.parseObject((String)json);
                JSONObject data = (JSONObject)obj.get((Object)"data");
                List result = (List)data.get((Object)"result");
                List l3CategoryPredictionResults = (List)data.get((Object)"l3CategoryPredictionResults");
                if (l3CategoryPredictionResults.size() != 0) {
                    try {
                        queryAnalysisBO.setAnalyzerCatalogIndexData(l3CategoryPredictionResults);
                    }
                    catch (Exception e) {
                        queryAnalysisBO.setAnalyzerCatalogIndexData((List)new LinkedList<String>(){
                            private static final long serialVersionUID = 7665831013498152493L;
                            {
                                this.add("\u8c03\u7528\u5730\u5740\u5b58\u5728\u95ee\u9898");
                            }
                        });
                    }
                } else {
                    queryAnalysisBO.setAnalyzerCatalogIndexData((List)new LinkedList<String>(){
                        private static final long serialVersionUID = 7665831013498152493L;
                        {
                            this.add("\u4e09\u7ea7\u7c7b\u76ee\u4e3a\u7a7a!");
                        }
                    });
                }
                queryAnalysisBO.setReCallType((Integer)data.get((Object)"reCallType"));
                queryAnalysisBO.setFullTextMatchRate((String)data.get((Object)"fullTextMatchRate"));
                queryAnalysisBO.setKeyFieldsMatchRate((String)data.get((Object)"keyFieldsMatchRate"));
                queryAnalysisBO.setQueryResultType((String)data.get((Object)"queryResultType"));
                int num = 0;
                for (JSONObject jsonObject : result) {
                    ++num;
                    SimplifiedProductInfoBO simplifiedProductInfoBO = new SimplifiedProductInfoBO();
                    simplifiedProductInfoBO.setCommodityName((String)jsonObject.get((Object)"commodityName"));
                    simplifiedProductInfoBO.setCatalogAllName((String)jsonObject.get((Object)"catalogAllName"));
                    if (jsonObject.containsKey((Object)"weight")) {
                        simplifiedProductInfoBO.setWeight(Double.valueOf(Double.parseDouble(String.valueOf(jsonObject.get((Object)"weight")))));
                    } else {
                        simplifiedProductInfoBO.setWeight(Double.valueOf(-1.0));
                    }
                    simplifiedProductInfoBOS.add(simplifiedProductInfoBO);
                    if (num != this.searchQaConfig.getQuerySize()) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new RuntimeException(new Exception("\u8fd4\u56de\u5b57\u6bb5\u83b7\u53d6\u5f02\u5e38"));
            }
            return status;
        }, headerMap);
        queryAnalysisBO.setQueryResults(simplifiedProductInfoBOS);
        return queryAnalysisBO;
    }

    public String fileUpload(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) throws Exception {
        try {
            int len;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(queryAnalysisFileUploadReqBO.getFile());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((len = inputStream.read(b)) > 0) {
                outputStream.write(b, 0, len);
            }
            ((InputStream)inputStream).close();
            String[] files = queryAnalysisFileUploadReqBO.getFileName().split("\\.");
            String fileType = files[files.length - 1];
            CharSequence[] filenameNew = Arrays.copyOf(files, files.length - 1);
            return this.fileUpLoad.upload(String.join((CharSequence)"", filenameNew), outputStream.toByteArray(), "." + fileType);
        }
        catch (Exception e) {
            throw new Exception(queryAnalysisFileUploadReqBO.getFileName() + "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" + e.getMessage());
        }
    }

    public int insertFileData(InsertFileDataBO insertFileDataBO) {
        QueryAnalysisFilesListPO queryAnalysisFilesListPO = new QueryAnalysisFilesListPO();
        queryAnalysisFilesListPO.setId(insertFileDataBO.getId());
        queryAnalysisFilesListPO.setFilename(insertFileDataBO.getFilename());
        queryAnalysisFilesListPO.setFileurl(insertFileDataBO.getFileurl());
        queryAnalysisFilesListPO.setCategory(insertFileDataBO.getCategory());
        return this.queryAnalysisFilesListMapper.insert(queryAnalysisFilesListPO);
    }
}

