/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.qa.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceFactory {
    private static ExecutorServiceFactory executorFactory = new ExecutorServiceFactory();
    private int corePoolSize = Runtime.getRuntime().availableProcessors() + 1;
    private int maximumPoolSize = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private long keepAliveTime = 5L;
    private TimeUnit unit = TimeUnit.MINUTES;
    private BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(200000);

    private ExecutorServiceFactory() {
    }

    public static ExecutorServiceFactory getInstance() {
        return executorFactory;
    }

    public ExecutorService createCachedThreadPool() {
        ExecutorService executorService = Executors.newCachedThreadPool(this.getThreadFactory("cache"));
        return executorService;
    }

    public ExecutorService createFixedThreadPool(int count) {
        ExecutorService executorService = Executors.newFixedThreadPool(count, this.getThreadFactory("fixed"));
        return executorService;
    }

    public ExecutorService createCustomThreadPool() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.unit, this.workQueue, this.getThreadFactory("custom"));
        return executorService;
    }

    private ThreadFactory getThreadFactory(final String type) {
        return new ThreadFactory(){
            AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                SecurityManager s = System.getSecurityManager();
                ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                Thread t = new Thread(group, r);
                t.setName(type + "_Thread-No_" + this.sn.incrementAndGet());
                return t;
            }
        };
    }
}

