/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommoditySpecifySortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.bo.SearchSortOrderColumnBo;
import com.tydic.se.search.sort.enumType.SpecifySortFilterEnum;
import com.tydic.se.search.sort.enumType.SpecifySortMethodEnum;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SearchCommoditySpecifySortServiceImpl
implements SearchCommoditySpecifySortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommoditySpecifySortServiceImpl.class);
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;

    public SeSearchRspBO specifySort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            if (searchSortMsgBo.isSalesPriceJudge()) {
                this.sortPriceSort(rspBo, searchSortMsgBo);
            }
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList())) {
                this.earmarkSort(rspBo, searchSortMsgBo);
            }
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6307\u5b9a\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u6307\u5b9a\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private void dataFiltering(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            List seQueryFilterBOList = searchSortMsgBo.getQueryFilterList();
            LinkedList seQuerySkuBOList = new LinkedList(rspBo.getSkuList());
            for (SeQueryFilterBO seQueryFilterBO : seQueryFilterBOList) {
                Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                Iterator iterator = seQuerySkuBOList.iterator();
                while (iterator.hasNext()) {
                    SeQuerySkuBO seQuerySkuBO = (SeQuerySkuBO)iterator.next();
                    try {
                        List filterValues;
                        boolean filterExist;
                        SpecifySortFilterEnum specifySortFilterEnum = SpecifySortFilterEnum.getEumByCode((String)seQueryFilterBO.getFilterName());
                        if (!"null".equals(specifySortFilterEnum.getField())) {
                            int flag;
                            Object value;
                            Field field = clazz.getDeclaredField(specifySortFilterEnum.getField());
                            field.setAccessible(true);
                            Type type = field.getGenericType();
                            if (type.equals(String.class)) {
                                value = (String)field.get(seQuerySkuBO);
                                flag = 0;
                                if (!StringUtils.isEmpty((Object)value)) {
                                    for (String filterValue : seQueryFilterBO.getFilterValues()) {
                                        if (!((String)value).equals(filterValue)) continue;
                                        ++flag;
                                    }
                                }
                                if (flag != 0) continue;
                                iterator.remove();
                                continue;
                            }
                            value = (List)field.get(seQuerySkuBO);
                            flag = 0;
                            if (!CollectionUtils.isEmpty((Collection)value)) {
                                for (String filterValue : seQueryFilterBO.getFilterValues()) {
                                    if (!value.contains(filterValue)) continue;
                                    ++flag;
                                }
                            }
                            if (flag != 0) continue;
                            iterator.remove();
                            continue;
                        }
                        if (!seQueryFilterBO.getFilterId().equals("prop_name_" + seQueryFilterBO.getFilterName())) continue;
                        if (CollectionUtils.isEmpty((Map)seQuerySkuBO.getPropertiesMap())) {
                            iterator.remove();
                            continue;
                        }
                        if (!seQuerySkuBO.getPropertiesMap().containsKey(seQueryFilterBO.getFilterId())) {
                            iterator.remove();
                            continue;
                        }
                        if (!seQuerySkuBO.getPropertiesMap().containsKey(seQueryFilterBO.getFilterId()) || (filterExist = (filterValues = seQueryFilterBO.getFilterValues()).stream().anyMatch(filter -> ((String)seQuerySkuBO.getPropertiesMap().get(seQueryFilterBO.getFilterId())).equals(filter)))) continue;
                        iterator.remove();
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
            }
            log.info("\u539f\u6709\u6570\u636e{}\u6761\uff0c\u6307\u5b9a\u7b5b\u9009\u6570\u636e\u540e\u6709{}\u6761\uff01", (Object)rspBo.getSkuList().size(), (Object)seQuerySkuBOList.size());
            rspBo.setSkuList(seQuerySkuBOList);
            rspBo.setTotal(seQuerySkuBOList.size());
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u7b5b\u9009\uff01", e});
            throw new SearchSortException("9999", "\u6570\u636e\u7b5b\u9009\uff01", (Throwable)e);
        }
    }

    private void sortPriceSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        LinkedList<SeQuerySkuBO> seQuerySkuBOList = new LinkedList<SeQuerySkuBO>();
        BigDecimal min = new BigDecimal(searchSortMsgBo.getMinSalesPrice().toString());
        BigDecimal max = new BigDecimal(searchSortMsgBo.getMaxSalesPrice().toString());
        for (SeQuerySkuBO seQuerySkuBO : rspBo.getSkuList()) {
            BigDecimal tmp = new BigDecimal(String.valueOf(seQuerySkuBO.getSalePrice()));
            if (tmp.compareTo(min) < 0 || tmp.compareTo(max) >= 0) continue;
            seQuerySkuBOList.add(seQuerySkuBO);
        }
        log.info("\u539f\u6709\u6570\u636e{}\u6761\uff0c\u6307\u5b9a\u4ef7\u683c\u533a\u95f4\u6392\u5e8f\u540e\u6709{}\u6761\uff01", (Object)rspBo.getSkuList().size(), (Object)seQuerySkuBOList.size());
        rspBo.setSkuList(seQuerySkuBOList);
    }

    private void earmarkSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            List seComSortBOList = searchSortMsgBo.getComSortList();
            Collections.reverse(seComSortBOList);
            for (SeComSortBO seComSortBO : seComSortBOList) {
                SpecifySortMethodEnum specifySortMethodEnum = SpecifySortMethodEnum.getEumByCode((String)seComSortBO.getOrderByColumn());
                SearchSortOrderColumnBo searchSortOrderColumnBo = new SearchSortOrderColumnBo();
                searchSortOrderColumnBo.setField(specifySortMethodEnum.getField());
                searchSortOrderColumnBo.setOrderType(seComSortBO.getOrderType());
                if (!SpecifySortMethodEnum.DEFAULT_SORT.getField().equals(specifySortMethodEnum.getField())) {
                    rspBo.setSkuList(this.commoditySort(rspBo.getSkuList(), searchSortOrderColumnBo));
                }
                SearchSortUtils.printCustomize(Arrays.asList(rspBo.getSkuList().toArray()), (String)specifySortMethodEnum.getField(), (SearchSortMsgBo)searchSortMsgBo);
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u6307\u5b9a\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u6570\u636e\u6307\u5b9a\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private SeSearchRspBO preciseSorting(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        List seQuerySkuBOList = rspBo.getSkuList();
        for (int i = searchSortMsgBo.getCutLen(); i < seQuerySkuBOList.size(); i += searchSortMsgBo.getCutLen()) {
            this.categoryInterval(seQuerySkuBOList, "supplier_id", i, searchSortMsgBo);
        }
        rspBo.setSkuList(seQuerySkuBOList);
        log.info("\u67e5\u8be2\u6392\u5e8f \u7cbe\u6392\u7ed3\u679c");
        return rspBo;
    }

    private SeSearchRspBO attentiveSorting(SeSearchRspBO rspBo, SearchSortOrderColumnBo orderColumBo, SearchSortMsgBo searchSortMsgBo) {
        List seQuerySkuBOList = rspBo.getSkuList();
        for (int i = searchSortMsgBo.getCutLen(); i < seQuerySkuBOList.size(); i += searchSortMsgBo.getCutLen()) {
        }
        rspBo.setSkuList(seQuerySkuBOList);
        log.info("\u67e5\u8be2\u6392\u5e8f \u7ec6\u6392\u7ed3\u679c");
        return rspBo;
    }

    private void categoryInterval(List<SeQuerySkuBO> commodityRspBoList, String variable, int index, SearchSortMsgBo searchSortMsgBo) {
        int i;
        LinkedHashMap commodityRspBoMap = new LinkedHashMap();
        for (i = index - searchSortMsgBo.getCutLen(); i < index; ++i) {
            Queue<Object> commodityRspBoQueue = null;
            commodityRspBoQueue = commodityRspBoMap.containsKey(String.valueOf(SearchSortUtils.objectToMap((Object)commodityRspBoList.get(i)).get(variable))) ? (Queue)commodityRspBoMap.get(String.valueOf(SearchSortUtils.objectToMap((Object)commodityRspBoList.get(i)).get(variable))) : new LinkedList<SeQuerySkuBO>();
            commodityRspBoQueue.offer(commodityRspBoList.get(i));
            commodityRspBoMap.put(String.valueOf(SearchSortUtils.objectToMap((Object)commodityRspBoList.get(i)).get(variable)), commodityRspBoQueue);
        }
        log.info("\u67e5\u8be2\u6392\u5e8f \u7cbe\u6392\u4f9b\u5e94\u5546\u7ed3\u679c {}", commodityRspBoMap.keySet());
        i = index - searchSortMsgBo.getCutLen();
        while (i < index) {
            for (Map.Entry tmp : commodityRspBoMap.entrySet()) {
                if (((Queue)tmp.getValue()).isEmpty()) continue;
                commodityRspBoList.set(i++, (SeQuerySkuBO)((Queue)tmp.getValue()).poll());
            }
        }
    }

    public List<SeQuerySkuBO> commoditySort(List<SeQuerySkuBO> commodityRspBoList, SearchSortOrderColumnBo orderColumn) throws SearchSortException {
        try {
            Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
            final Field field = clazz.getDeclaredField(orderColumn.getField());
            field.setAccessible(true);
            if (orderColumn.getOrderType() == 1) {
                return commodityRspBoList.stream().sorted(new Comparator<SeQuerySkuBO>(){

                    @Override
                    public int compare(SeQuerySkuBO o1, SeQuerySkuBO o2) {
                        String v1 = String.valueOf(field.get(o1));
                        String v2 = String.valueOf(field.get(o2));
                        BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                        BigDecimal bd2 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                        return bd1.compareTo(bd2);
                    }
                }).collect(Collectors.toList());
            }
            return commodityRspBoList.stream().sorted(new Comparator<SeQuerySkuBO>(){

                @Override
                public int compare(SeQuerySkuBO o1, SeQuerySkuBO o2) {
                    String v1 = String.valueOf(field.get(o1));
                    String v2 = String.valueOf(field.get(o2));
                    BigDecimal bd1 = "null".equals(v1) ? new BigDecimal("0.0") : new BigDecimal(v1);
                    BigDecimal bd2 = "null".equals(v2) ? new BigDecimal("0.0") : new BigDecimal(v2);
                    return bd1.compareTo(bd2);
                }
            }.reversed()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SearchSortException("9999", "\u5546\u54c1\u6307\u5b9a\u6838\u5fc3\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    private <T> List<List<T>> listCut(List<T> list, int splitSize) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int maxSize = (list.size() + splitSize - 1) / splitSize;
        return ((Stream)Stream.iterate(0, n -> n + 1).limit(maxSize).parallel()).map(a -> list.parallelStream().skip((long)a.intValue() * (long)splitSize).limit(splitSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
    }
}

